/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class LoggingErrorHandler
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoggingErrorHandler.class);

    @Override
    public void warning(SAXParseException exception) throws SAXParseException {
        String message = exception.getMessage() + " (" + exception.getLineNumber() + "," + exception.getColumnNumber() + ")";
        if (exception.getMessage() != null && exception.getMessage().startsWith("schema_reference.4")) {
            if (logger.isErrorEnabled()) {
                logger.error(message);
            }
            throw exception;
        }
        if (logger.isWarnEnabled()) {
            logger.warn(message);
        }
    }

    @Override
    public void error(SAXParseException exception) {
        if (logger.isErrorEnabled()) {
            logger.error(exception.getMessage() + " (" + exception.getLineNumber() + "," + exception.getColumnNumber() + ")");
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
        if (logger.isErrorEnabled()) {
            logger.error(exception.getMessage() + " (" + exception.getLineNumber() + "," + exception.getColumnNumber() + ")");
        }
    }
}

