/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.apache.xerces.impl.Constants;
import org.libj.net.MemoryURLStreamHandler;
import org.libj.net.URLs;
import org.libj.util.StringPaths;
import org.openjax.xml.sax.CachedInputSource;
import org.openjax.xml.sax.DelegateErrorHandler;
import org.openjax.xml.sax.LoggingErrorHandler;
import org.openjax.xml.sax.SAXParsers;
import org.openjax.xml.sax.XmlCatalogResolver;
import org.openjax.xml.sax.XmlPreview;
import org.openjax.xml.sax.XmlPreviewHandler;
import org.openjax.xml.sax.XmlPreviewParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public final class Validator {
    private static final ErrorHandler DEFAULT_ERROR_HANDLER = new LoggingErrorHandler();
    private static final String dynamicXmlRoot = "n892fn298n9w8nds9v";
    private static final String dynamicXmlError = "cvc-elt.1.a: Cannot find the declaration of element 'n892fn298n9w8nds9v'.";
    private static final SchemaFactory factory;

    private static SchemaFactory newSchemaFactory() throws SAXNotRecognizedException, SAXNotSupportedException {
        SchemaFactory factory = SchemaFactory.newInstance(Constants.W3C_XML_SCHEMA11_NS_URI);
        factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        factory.setFeature("http://apache.org/xml/features/validation/schema/augment-psvi", true);
        factory.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
        factory.setFeature("http://apache.org/xml/features/standard-uri-conformant", true);
        factory.setFeature("http://apache.org/xml/features/validate-annotations", true);
        factory.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
        factory.setFeature("http://apache.org/xml/features/internal/tolerate-duplicates", true);
        factory.setFeature("http://apache.org/xml/features/validation/cta-full-xpath-checking", true);
        return factory;
    }

    public static void main(String[] args) throws IOException, SAXException {
        String path;
        if (args.length != 1) {
            System.err.println("Usage: Validator <FILE>");
            System.exit(1);
        }
        Validator.validate(StringPaths.getProtocol((String)(path = args[0])) != null ? new URL(path) : new File(path).toURI().toURL());
    }

    public static void validate(String xml) throws IOException, SAXException {
        Validator.validate(xml, DEFAULT_ERROR_HANDLER);
    }

    public static void validate(String xml, ErrorHandler errorHandler) throws IOException, SAXException {
        Validator.validate(MemoryURLStreamHandler.createURL((byte[])xml.getBytes()), errorHandler);
    }

    public static void validate(URL url) throws IOException, SAXException {
        Validator.validate(url, DEFAULT_ERROR_HANDLER);
    }

    public static void validate(URL url, ErrorHandler errorHandler) throws IOException, SAXException {
        try (CachedInputSource cachedInputSource = new CachedInputSource(null, url.toString(), null, url.openConnection());){
            Validator.validate(url, cachedInputSource, null, errorHandler);
        }
    }

    public static void validate(InputSource inputSource) throws IOException, SAXException {
        Validator.validate(inputSource, DEFAULT_ERROR_HANDLER);
    }

    public static void validate(InputSource inputSource, ErrorHandler errorHandler) throws IOException, SAXException {
        Validator.validate(null, inputSource, null, errorHandler);
    }

    public static void validate(InputSource inputSource, XmlPreviewHandler previewHandler, ErrorHandler errorHandler) throws IOException, SAXException {
        Validator.validate(null, inputSource, previewHandler, errorHandler);
    }

    public static void validate(InputSource inputSource, XmlPreview preview, ErrorHandler errorHandler) throws IOException, SAXException {
        Validator.validate(inputSource instanceof CachedInputSource ? (CachedInputSource)inputSource : new CachedInputSource(inputSource), preview, errorHandler);
    }

    public static void validate(URL url, InputSource inputSource) throws IOException, SAXException {
        CachedInputSource cachedInputSource = inputSource instanceof CachedInputSource ? (CachedInputSource)inputSource : new CachedInputSource(inputSource);
        XmlPreview preview = Validator.initInputSource(url, cachedInputSource, null);
        Validator.validate(cachedInputSource, preview, DEFAULT_ERROR_HANDLER);
    }

    public static void validate(URL url, InputSource inputSource, ErrorHandler errorHandler) throws IOException, SAXException {
        CachedInputSource cachedInputSource = inputSource instanceof CachedInputSource ? (CachedInputSource)inputSource : new CachedInputSource(inputSource);
        XmlPreview preview = Validator.initInputSource(url, cachedInputSource, null);
        Validator.validate(cachedInputSource, preview, errorHandler);
    }

    private static void validate(URL url, InputSource inputSource, XmlPreviewHandler previewHandler, ErrorHandler errorHandler) throws IOException, SAXException {
        CachedInputSource cachedInputSource = inputSource instanceof CachedInputSource ? (CachedInputSource)inputSource : new CachedInputSource(inputSource);
        XmlPreview preview = Validator.initInputSource(url, cachedInputSource, previewHandler);
        Validator.validate(cachedInputSource, preview, errorHandler);
    }

    private static XmlPreview initInputSource(URL url, CachedInputSource inputSource, XmlPreviewHandler previewHandler) throws IOException, SAXParseException {
        if (previewHandler == null) {
            XmlPreview preview = XmlPreviewParser.parse(url != null ? url : new URL(inputSource.getSystemId()), inputSource);
            inputSource.getCharacterStream().close();
            return preview;
        }
        XmlPreview preview = previewHandler.toXmlPreview();
        previewHandler.reset();
        return preview;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validate(CachedInputSource inputSource, XmlPreview preview, ErrorHandler errorHandler) throws IOException, SAXException {
        try {
            SAXSource saxSource;
            SAXParser parser = SAXParsers.newParser(false);
            String systemId = inputSource.getSystemId();
            boolean isSchema = preview.isSchema();
            if (isSchema) {
                StringBuilder xml = new StringBuilder();
                xml.append('<').append(dynamicXmlRoot);
                xml.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                String targetNamespace = preview.getTargetNamespace();
                if (targetNamespace != null && targetNamespace.length() > 0) {
                    xml.append(" xmlns=\"").append(targetNamespace).append('\"');
                    xml.append(" xsi:schemaLocation=\"").append(targetNamespace).append(' ').append(systemId).append('\"');
                } else {
                    xml.append(" xsi:noNamespaceSchemaLocation=\"").append(systemId).append('\"');
                }
                xml.append("/>");
                saxSource = new SAXSource(parser.getXMLReader(), new InputSource(new ByteArrayInputStream(xml.toString().getBytes())));
                saxSource.setSystemId("dynamic:" + systemId);
            } else {
                saxSource = new SAXSource(parser.getXMLReader(), inputSource);
                saxSource.setSystemId(systemId);
            }
            javax.xml.validation.Validator validator = factory.newSchema().newValidator();
            validator.setResourceResolver(new XmlCatalogResolver(preview.getCatalog()));
            ValidatorErrorHandler validatorErrorHandler = new ValidatorErrorHandler(errorHandler, inputSource, isSchema || preview.getImports() != null || preview.getIncludes() != null);
            validator.setErrorHandler(validatorErrorHandler);
            try {
                validator.validate(saxSource);
            }
            catch (IOException | SAXException e) {
                Validator.checkException(validatorErrorHandler, e);
            }
            Validator.checkException(validatorErrorHandler, null);
        }
        finally {
            if (preview != null) {
                preview.getCatalog().close();
            }
        }
    }

    private static <E extends Exception> void checkException(ValidatorErrorHandler validatorErrorHandler, Throwable suppressor) throws E, SAXParseException {
        if (validatorErrorHandler.errors != null) {
            Iterator iterator = validatorErrorHandler.errors.iterator();
            SAXParseException exception = (SAXParseException)iterator.next();
            while (iterator.hasNext()) {
                exception.addSuppressed((Throwable)iterator.next());
            }
            if (suppressor == null) {
                throw exception;
            }
            suppressor.addSuppressed(exception);
            throw (Exception)suppressor;
        }
        if (suppressor != null) {
            throw (Exception)suppressor;
        }
    }

    public static boolean isRemoteAccessException(IOException exception) {
        String methodName = exception.getStackTrace()[0].getMethodName();
        return "openConnection".equals(methodName) || "connect".equals(methodName) || "socketConnect".equals(methodName);
    }

    public static boolean isRemoteAccessException(SAXException exception) {
        String message = exception.getMessage();
        int start = message.indexOf("Failed to read schema document '");
        if (start == -1) {
            return false;
        }
        int end = message.indexOf("', because", start + 32);
        String failedDocument = message.substring(start + 32, end);
        try {
            return !URLs.isLocal((URL)new URL(failedDocument));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private Validator() {
    }

    static {
        try {
            factory = Validator.newSchemaFactory();
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class ValidatorErrorHandler
    extends DelegateErrorHandler {
        private final InputSource inputSource;
        private final boolean hasSchema;
        private List<SAXParseException> errors;

        private ValidatorErrorHandler(ErrorHandler handler, InputSource inputSource, boolean hasSchema) {
            super(handler);
            this.inputSource = Objects.requireNonNull(inputSource);
            this.hasSchema = hasSchema;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (!e.getMessage().startsWith("schema_reference.4: Failed to read schema document '") || this.hasSchema) {
                super.warning(e);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            String message = e.getMessage();
            if (Validator.dynamicXmlError.equals(message)) {
                return;
            }
            if (message.startsWith("cvc-elt.1.a: Cannot find the declaration of element ") && !this.hasSchema) {
                this.warning(new SAXParseException("There is no schema or DTD associated with the document", this.inputSource.getPublicId(), this.inputSource.getSystemId(), 0, 0));
            } else {
                if (this.errors == null) {
                    this.errors = new ArrayList<SAXParseException>();
                }
                this.errors.add(e);
                super.error(e);
            }
        }
    }
}

