/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.libj.net.URLs;
import org.libj.util.StringPaths;
import org.openjax.xml.sax.FastSAXHandler;
import org.openjax.xml.sax.XmlCatalog;
import org.openjax.xml.sax.XmlCatalogResolver;
import org.openjax.xml.sax.XmlPreview;
import org.openjax.xml.schema.SchemaResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XmlPreviewHandler
extends FastSAXHandler {
    private static final Logger logger = LoggerFactory.getLogger(XmlPreviewHandler.class);
    private String systemId;
    private XmlCatalog catalog;
    private final HashSet<String> visitedURIs = new HashSet();
    private final HashSet<URL> visitedURLs = new HashSet();
    private final LinkedHashMap<String, URL> absoluteIncludes = new LinkedHashMap();
    private boolean isLocal = true;
    private String targetNamespace;
    private boolean isSchema;
    private QName rootElement;
    private Map<String, URL> imports;
    private Map<String, URL> includes;

    private static String toString(Map<QName, String> attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.size() == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        Iterator<Map.Entry<QName, String>> iterator = attributes.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<QName, String> entry;
            QName name;
            if (i > 0) {
                b.append(' ');
            }
            if ((name = (entry = iterator.next()).getKey()).getPrefix().length() > 0) {
                b.append(name.getPrefix()).append(':');
            }
            b.append(name.getLocalPart());
            b.append("=\"").append(entry.getValue()).append('\"');
            ++i;
        }
        return b.toString();
    }

    XmlPreviewHandler(XmlCatalog catalog) {
        this.init(catalog);
    }

    private void init(XmlCatalog catalog) {
        this.reader = catalog.getInputSource().getCharacterStream();
        this.systemId = catalog.getInputSource().getSystemId();
        this.catalog = catalog;
    }

    void reset(XmlCatalog catalog) {
        this.reset();
        this.init(catalog);
    }

    String getSystemId() {
        return this.systemId;
    }

    XmlCatalog getCatalog() {
        return this.catalog;
    }

    Set<String> getVisitedURIs() {
        return this.visitedURIs;
    }

    Set<URL> getVisitedURLs() {
        return this.visitedURLs;
    }

    boolean isSchema() {
        if (this.rootElement == null) {
            throw new IllegalStateException("Parsing has not been performed");
        }
        return this.isSchema;
    }

    QName getRootElement() {
        if (this.rootElement == null) {
            throw new IllegalStateException("Parsing has not been performed");
        }
        return this.rootElement;
    }

    String getTargetNamespace() {
        return this.targetNamespace;
    }

    private Map<String, URL> imports() {
        return this.imports == null ? (this.imports = new LinkedHashMap<String, URL>(){

            @Override
            public URL put(String key, URL value) {
                URL schemaUrl = SchemaResolver.resolve((String)key, (String)value.toString());
                return schemaUrl != null ? super.put(key, schemaUrl) : super.put(key, value);
            }
        }) : this.imports;
    }

    Map<String, URL> getImports() {
        return this.imports;
    }

    private void addImport(String namespace, String location) {
        String path = XmlCatalogResolver.getPath(this.systemId, location);
        this.isLocal &= StringPaths.isAbsoluteLocal((String)path);
        if (!this.imports().containsKey(namespace)) {
            this.imports.put(namespace, StringPaths.getProtocol((String)path) == null ? URLs.create((String)("file:" + path)) : URLs.create((String)path));
        }
    }

    private Map<String, URL> includes() {
        return this.includes == null ? (this.includes = new LinkedHashMap<String, URL>()) : this.includes;
    }

    Map<String, URL> getIncludes() {
        return this.includes;
    }

    private void addInclude(String schemaLocation) {
        String path = XmlCatalogResolver.getPath(this.systemId, schemaLocation);
        this.isLocal &= StringPaths.isAbsoluteLocal((String)path);
        URL url = this.absoluteIncludes.get(path);
        if (url == null) {
            url = URLs.create((String)path);
            this.absoluteIncludes.put(path, url);
        }
        this.includes().put(schemaLocation, url);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean startElement(QName name, Map<QName, String> attributes) throws IOException {
        String localPart = name.getLocalPart();
        String namespaceURI = name.getNamespaceURI();
        if (logger.isTraceEnabled()) {
            String attrs = XmlPreviewHandler.toString(attributes);
            logger.trace("<" + localPart + " xmlns=\"" + namespaceURI + "\"" + (attrs != null ? " " + (String)attrs + ">" : ">"));
        }
        if (this.rootElement == null) {
            this.rootElement = name;
            boolean bl = this.isSchema = "http://www.w3.org/2001/XMLSchema".equals(namespaceURI) && "schema".equals(this.rootElement.getLocalPart());
        }
        if (this.isSchema) {
            if ("schema".equals(localPart)) {
                if (attributes.size() > 0) {
                    for (Map.Entry entry : attributes.entrySet()) {
                        String attributeName = ((QName)entry.getKey()).getLocalPart();
                        if (!"targetNamespace".equals(attributeName)) continue;
                        this.targetNamespace = (String)entry.getValue();
                        break;
                    }
                }
            } else if ("import".equals(localPart)) {
                void var6_8;
                String namespace = null;
                Object var6_7 = null;
                if (attributes.size() > 0) {
                    for (Map.Entry<QName, String> entry : attributes.entrySet()) {
                        String attributeName = entry.getKey().getLocalPart();
                        if ("namespace".equals(attributeName)) {
                            namespace = entry.getValue();
                            if (var6_8 == null) continue;
                            break;
                        }
                        if (!"schemaLocation".equals(attributeName)) continue;
                        String string = entry.getValue();
                        if (namespace == null) continue;
                        break;
                    }
                }
                String path = XmlCatalogResolver.getPath(this.systemId, (String)var6_8);
                this.isLocal &= StringPaths.isAbsoluteLocal((String)path);
                this.visitedURIs.add(namespace);
                if (!this.imports().containsKey(namespace)) {
                    this.imports.put(namespace, URLs.create((String)path));
                }
            } else if ("include".equals(localPart)) {
                if (attributes.size() > 0) {
                    for (Map.Entry<QName, String> entry : attributes.entrySet()) {
                        if (!"schemaLocation".equals(entry.getKey().getLocalPart())) continue;
                        this.addInclude(entry.getValue());
                    }
                }
            } else if (!("schema".equals(localPart) || "annotation".equals(localPart) || "redefine".equals(localPart))) {
                return false;
            }
        } else {
            if ("include".equals(localPart)) {
                if (attributes.size() > 0) {
                    for (Map.Entry<QName, String> entry : attributes.entrySet()) {
                        QName key = entry.getKey();
                        if (!"http://www.w3.org/2001/XInclude".equals(key.getNamespaceURI()) || !"href".equals(key.getLocalPart())) continue;
                        this.addInclude(entry.getValue());
                    }
                }
            } else if (attributes != null && attributes.size() > 0) {
                for (Map.Entry<QName, String> entry : attributes.entrySet()) {
                    QName key = entry.getKey();
                    String keyNamespace = key.getNamespaceURI();
                    if ("http://www.w3.org/2001/XMLSchema-instance".equals(keyNamespace)) {
                        String keyLocalPart = key.getLocalPart();
                        if ("noNamespaceSchemaLocation".equals(keyLocalPart)) {
                            this.addInclude(entry.getValue());
                            continue;
                        }
                        if (!"schemaLocation".equals(keyLocalPart)) continue;
                        String value = entry.getValue();
                        StringTokenizer tokenizer = new StringTokenizer(value);
                        while (tokenizer.hasMoreTokens()) {
                            String namespace = tokenizer.nextToken();
                            if (!tokenizer.hasMoreTokens()) continue;
                            String location = tokenizer.nextToken();
                            this.addImport(namespace, location);
                        }
                        continue;
                    }
                    if (keyNamespace.length() == 0) continue;
                    this.visitedURIs.add(keyNamespace);
                }
            }
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI) && namespaceURI.length() != 0) {
                this.visitedURIs.add(namespaceURI);
            }
        }
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.isSchema = false;
        this.rootElement = null;
        this.targetNamespace = null;
        this.isLocal = true;
        if (this.includes != null) {
            this.includes.clear();
        }
        if (this.imports != null) {
            this.imports.clear();
        }
    }

    public XmlPreview toXmlPreview() {
        return new XmlPreview(this.catalog, this.isLocal, this.isSchema, this.rootElement, this.targetNamespace, this.imports == null ? null : new HashMap<String, URL>(this.imports), (Map<String, URL>)(this.includes == null ? null : new HashMap<String, URL>(this.includes)));
    }
}

