/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.results.II_Result_jcstress;
import org.openjdk.jcstress.infra.runners.Runner;
import org.openjdk.jcstress.infra.runners.StateHolder;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.samples.APISample_01_Simple;
import org.openjdk.jcstress.util.Counter;

public class APISample_01_Simple_jcstress
extends Runner<II_Result_jcstress> {
    volatile StateHolder<APISample_01_Simple, II_Result_jcstress> version;

    public APISample_01_Simple_jcstress(TestConfig config, TestResultCollector collector, ExecutorService pool) {
        super(config, collector, pool, "org.openjdk.jcstress.samples.APISample_01_Simple");
    }

    public Counter<II_Result_jcstress> sanityCheck() throws Throwable {
        Counter counter = new Counter();
        this.sanityCheck_API((Counter<II_Result_jcstress>)counter);
        this.sanityCheck_Footprints((Counter<II_Result_jcstress>)counter);
        return counter;
    }

    private void sanityCheck_API(Counter<II_Result_jcstress> counter) throws Throwable {
        APISample_01_Simple s = new APISample_01_Simple();
        II_Result_jcstress r = new II_Result_jcstress();
        ArrayList res = new ArrayList();
        res.add(this.pool.submit(() -> s.actor1(r)));
        res.add(this.pool.submit(() -> s.actor2(r)));
        for (Future future : res) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
        counter.record((Object)r);
    }

    private void sanityCheck_Footprints(Counter<II_Result_jcstress> counter) throws Throwable {
        this.config.adjustStrides(size -> {
            this.version = new StateHolder((Object[])new APISample_01_Simple[size.intValue()], (Object[])new II_Result_jcstress[size.intValue()], 2, this.config.spinLoopStyle);
            for (int c = 0; c < size; ++c) {
                II_Result_jcstress r = new II_Result_jcstress();
                APISample_01_Simple s = new APISample_01_Simple();
                ((II_Result_jcstress[])this.version.rs)[c] = r;
                ((APISample_01_Simple[])this.version.ss)[c] = s;
                s.actor1(r);
                s.actor2(r);
                counter.record((Object)r);
            }
        });
    }

    public Counter<II_Result_jcstress> internalRun() {
        this.version = new StateHolder((Object[])new APISample_01_Simple[0], (Object[])new II_Result_jcstress[0], 2, this.config.spinLoopStyle);
        this.control.isStopped = false;
        ArrayList<Callable<Counter>> tasks = new ArrayList<Callable<Counter>>();
        tasks.add(this::actor1);
        tasks.add(this::actor2);
        Collections.shuffle(tasks);
        ArrayList results = new ArrayList();
        for (Callable callable : tasks) {
            results.add(this.pool.submit(callable));
        }
        try {
            TimeUnit.MILLISECONDS.sleep(this.config.time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.control.isStopped = true;
        this.waitFor(results);
        Counter counter = new Counter();
        for (Future future : results) {
            try {
                counter.merge((Counter)future.get());
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
        return counter;
    }

    public final void jcstress_consume(StateHolder<APISample_01_Simple, II_Result_jcstress> holder, Counter<II_Result_jcstress> cnt, int a, int actors) {
        APISample_01_Simple[] ss = (APISample_01_Simple[])holder.ss;
        II_Result_jcstress[] rs = (II_Result_jcstress[])holder.rs;
        int len = ss.length;
        int left = a * len / actors;
        int right = (a + 1) * len / actors;
        for (int c = left; c < right; ++c) {
            II_Result_jcstress r = rs[c];
            APISample_01_Simple s = ss[c];
            s.v = 0;
            cnt.record((Object)r);
            r.r1 = 0;
            r.r2 = 0;
        }
    }

    public final void jcstress_updateHolder(StateHolder<APISample_01_Simple, II_Result_jcstress> holder) {
        if (!holder.tryStartUpdate()) {
            return;
        }
        Object[] ss = (APISample_01_Simple[])holder.ss;
        II_Result_jcstress[] rs = (II_Result_jcstress[])holder.rs;
        int len = ss.length;
        int newLen = holder.updateStride ? Math.max(this.config.minStride, Math.min(len * 2, this.config.maxStride)) : len;
        Object[] newS = ss;
        II_Result_jcstress[] newR = rs;
        if (newLen > len) {
            newS = Arrays.copyOf(ss, newLen);
            newR = Arrays.copyOf(rs, newLen);
            for (int c = len; c < newLen; ++c) {
                newR[c] = new II_Result_jcstress();
                newS[c] = new APISample_01_Simple();
            }
        }
        this.version = new StateHolder(this.control.isStopped, newS, (Object[])newR, 2, this.config.spinLoopStyle);
        holder.finishUpdate();
    }

    public final Counter<II_Result_jcstress> actor1() {
        Counter counter = new Counter();
        while (true) {
            StateHolder<APISample_01_Simple, II_Result_jcstress> holder = this.version;
            if (holder.stopped) {
                return counter;
            }
            APISample_01_Simple[] ss = (APISample_01_Simple[])holder.ss;
            II_Result_jcstress[] rs = (II_Result_jcstress[])holder.rs;
            int size = ss.length;
            holder.preRun();
            for (int c = 0; c < size; ++c) {
                APISample_01_Simple s = ss[c];
                II_Result_jcstress r = rs[c];
                r.trap = 0;
                s.actor1(r);
            }
            holder.postRun();
            this.jcstress_consume(holder, (Counter<II_Result_jcstress>)counter, 0, 2);
            this.jcstress_updateHolder(holder);
            holder.postUpdate();
        }
    }

    public final Counter<II_Result_jcstress> actor2() {
        Counter counter = new Counter();
        while (true) {
            StateHolder<APISample_01_Simple, II_Result_jcstress> holder = this.version;
            if (holder.stopped) {
                return counter;
            }
            APISample_01_Simple[] ss = (APISample_01_Simple[])holder.ss;
            II_Result_jcstress[] rs = (II_Result_jcstress[])holder.rs;
            int size = ss.length;
            holder.preRun();
            for (int c = 0; c < size; ++c) {
                APISample_01_Simple s = ss[c];
                II_Result_jcstress r = rs[c];
                r.trap = 0;
                s.actor2(r);
            }
            holder.postRun();
            this.jcstress_consume(holder, (Counter<II_Result_jcstress>)counter, 1, 2);
            this.jcstress_updateHolder(holder);
            holder.postUpdate();
        }
    }
}

