/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.results.I_Result_jcstress;
import org.openjdk.jcstress.infra.runners.Runner;
import org.openjdk.jcstress.infra.runners.StateHolder;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.samples.APISample_02_Arbiters;
import org.openjdk.jcstress.util.Counter;

public class APISample_02_Arbiters_jcstress
extends Runner<I_Result_jcstress> {
    volatile StateHolder<APISample_02_Arbiters, I_Result_jcstress> version;

    public APISample_02_Arbiters_jcstress(TestConfig config, TestResultCollector collector, ExecutorService pool) {
        super(config, collector, pool, "org.openjdk.jcstress.samples.APISample_02_Arbiters");
    }

    public Counter<I_Result_jcstress> sanityCheck() throws Throwable {
        Counter counter = new Counter();
        this.sanityCheck_API((Counter<I_Result_jcstress>)counter);
        this.sanityCheck_Footprints((Counter<I_Result_jcstress>)counter);
        return counter;
    }

    private void sanityCheck_API(Counter<I_Result_jcstress> counter) throws Throwable {
        APISample_02_Arbiters s = new APISample_02_Arbiters();
        I_Result_jcstress r = new I_Result_jcstress();
        ArrayList res = new ArrayList();
        res.add(this.pool.submit(() -> s.actor1()));
        res.add(this.pool.submit(() -> s.actor2()));
        for (Future future : res) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
        try {
            this.pool.submit(() -> s.arbiter(r)).get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        counter.record((Object)r);
    }

    private void sanityCheck_Footprints(Counter<I_Result_jcstress> counter) throws Throwable {
        this.config.adjustStrides(size -> {
            this.version = new StateHolder((Object[])new APISample_02_Arbiters[size.intValue()], (Object[])new I_Result_jcstress[size.intValue()], 2, this.config.spinLoopStyle);
            for (int c = 0; c < size; ++c) {
                I_Result_jcstress r = new I_Result_jcstress();
                APISample_02_Arbiters s = new APISample_02_Arbiters();
                ((I_Result_jcstress[])this.version.rs)[c] = r;
                ((APISample_02_Arbiters[])this.version.ss)[c] = s;
                s.actor1();
                s.actor2();
                s.arbiter(r);
                counter.record((Object)r);
            }
        });
    }

    public Counter<I_Result_jcstress> internalRun() {
        this.version = new StateHolder((Object[])new APISample_02_Arbiters[0], (Object[])new I_Result_jcstress[0], 2, this.config.spinLoopStyle);
        this.control.isStopped = false;
        ArrayList<Callable<Counter>> tasks = new ArrayList<Callable<Counter>>();
        tasks.add(this::actor1);
        tasks.add(this::actor2);
        Collections.shuffle(tasks);
        ArrayList results = new ArrayList();
        for (Callable callable : tasks) {
            results.add(this.pool.submit(callable));
        }
        try {
            TimeUnit.MILLISECONDS.sleep(this.config.time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.control.isStopped = true;
        this.waitFor(results);
        Counter counter = new Counter();
        for (Future future : results) {
            try {
                counter.merge((Counter)future.get());
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
        return counter;
    }

    public final void jcstress_consume(StateHolder<APISample_02_Arbiters, I_Result_jcstress> holder, Counter<I_Result_jcstress> cnt, int a, int actors) {
        APISample_02_Arbiters[] ss = (APISample_02_Arbiters[])holder.ss;
        I_Result_jcstress[] rs = (I_Result_jcstress[])holder.rs;
        int len = ss.length;
        int left = a * len / actors;
        int right = (a + 1) * len / actors;
        for (int c = left; c < right; ++c) {
            I_Result_jcstress r = rs[c];
            APISample_02_Arbiters s = ss[c];
            s.arbiter(r);
            s.v = 0;
            cnt.record((Object)r);
            r.r1 = 0;
        }
    }

    public final void jcstress_updateHolder(StateHolder<APISample_02_Arbiters, I_Result_jcstress> holder) {
        if (!holder.tryStartUpdate()) {
            return;
        }
        Object[] ss = (APISample_02_Arbiters[])holder.ss;
        I_Result_jcstress[] rs = (I_Result_jcstress[])holder.rs;
        int len = ss.length;
        int newLen = holder.updateStride ? Math.max(this.config.minStride, Math.min(len * 2, this.config.maxStride)) : len;
        Object[] newS = ss;
        I_Result_jcstress[] newR = rs;
        if (newLen > len) {
            newS = Arrays.copyOf(ss, newLen);
            newR = Arrays.copyOf(rs, newLen);
            for (int c = len; c < newLen; ++c) {
                newR[c] = new I_Result_jcstress();
                newS[c] = new APISample_02_Arbiters();
            }
        }
        this.version = new StateHolder(this.control.isStopped, newS, (Object[])newR, 2, this.config.spinLoopStyle);
        holder.finishUpdate();
    }

    public final Counter<I_Result_jcstress> actor1() {
        Counter counter = new Counter();
        while (true) {
            StateHolder<APISample_02_Arbiters, I_Result_jcstress> holder = this.version;
            if (holder.stopped) {
                return counter;
            }
            APISample_02_Arbiters[] ss = (APISample_02_Arbiters[])holder.ss;
            I_Result_jcstress[] rs = (I_Result_jcstress[])holder.rs;
            int size = ss.length;
            holder.preRun();
            for (int c = 0; c < size; ++c) {
                APISample_02_Arbiters s = ss[c];
                s.actor1();
            }
            holder.postRun();
            this.jcstress_consume(holder, (Counter<I_Result_jcstress>)counter, 0, 2);
            this.jcstress_updateHolder(holder);
            holder.postUpdate();
        }
    }

    public final Counter<I_Result_jcstress> actor2() {
        Counter counter = new Counter();
        while (true) {
            StateHolder<APISample_02_Arbiters, I_Result_jcstress> holder = this.version;
            if (holder.stopped) {
                return counter;
            }
            APISample_02_Arbiters[] ss = (APISample_02_Arbiters[])holder.ss;
            I_Result_jcstress[] rs = (I_Result_jcstress[])holder.rs;
            int size = ss.length;
            holder.preRun();
            for (int c = 0; c < size; ++c) {
                APISample_02_Arbiters s = ss[c];
                s.actor2();
            }
            holder.postRun();
            this.jcstress_consume(holder, (Counter<I_Result_jcstress>)counter, 1, 2);
            this.jcstress_updateHolder(holder);
            holder.postUpdate();
        }
    }
}

