/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openjdk.jcstress.annotations.Actor;
import org.openjdk.jcstress.annotations.Arbiter;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.annotations.JCStressTest;
import org.openjdk.jcstress.annotations.Outcome;
import org.openjdk.jcstress.annotations.State;
import org.openjdk.jcstress.infra.results.LL_Result;

public class ConcurrencySample_02_ConcurrentHashMap {

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"Bar, null", "Baz, null"}, expect=Expect.FORBIDDEN, desc="One update lost."), @Outcome(id={"Bar, Baz", "Baz, Bar"}, expect=Expect.ACCEPTABLE, desc="Both updates.")})
    @State
    public static class CorrectJDK8Multimap
    extends Multimap {
        @Actor
        public void actor1() {
            this.addCorrect8("Foo", "Bar");
        }

        @Actor
        public void actor2() {
            this.addCorrect8("Foo", "Baz");
        }

        @Arbiter
        public void arbiter(LL_Result s) {
            s.r1 = this.poll("Foo", 0);
            s.r2 = this.poll("Foo", 1);
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"Bar, null", "Baz, null"}, expect=Expect.FORBIDDEN, desc="One update lost."), @Outcome(id={"Bar, Baz", "Baz, Bar"}, expect=Expect.ACCEPTABLE, desc="Both updates.")})
    @State
    public static class CorrectMultimap
    extends Multimap {
        @Actor
        public void actor1() {
            this.addCorrect("Foo", "Bar");
        }

        @Actor
        public void actor2() {
            this.addCorrect("Foo", "Baz");
        }

        @Arbiter
        public void arbiter(LL_Result s) {
            s.r1 = this.poll("Foo", 0);
            s.r2 = this.poll("Foo", 1);
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"Bar, null", "Baz, null"}, expect=Expect.ACCEPTABLE_INTERESTING, desc="One update lost."), @Outcome(id={"Bar, Baz", "Baz, Bar"}, expect=Expect.ACCEPTABLE, desc="Both updates.")})
    @State
    public static class BrokenMultimap
    extends Multimap {
        @Actor
        public void actor1() {
            this.addBroken("Foo", "Bar");
        }

        @Actor
        public void actor2() {
            this.addBroken("Foo", "Baz");
        }

        @Arbiter
        public void arbiter(LL_Result s) {
            s.r1 = this.poll("Foo", 0);
            s.r2 = this.poll("Foo", 1);
        }
    }

    public static class Multimap {
        Map<String, List<String>> map = new ConcurrentHashMap<String, List<String>>();

        void addBroken(String key, String val) {
            List<String> list = this.map.get(key);
            if (list == null) {
                list = Collections.synchronizedList(new ArrayList());
                this.map.put(key, list);
            }
            list.add(val);
        }

        void addCorrect(String key, String val) {
            List<String> exist;
            List<String> list = this.map.get(key);
            if (list == null && (exist = this.map.putIfAbsent(key, list = Collections.synchronizedList(new ArrayList()))) != null) {
                list = exist;
            }
            list.add(val);
        }

        void addCorrect8(String key, String val) {
            List list = this.map.computeIfAbsent(key, k -> Collections.synchronizedList(new ArrayList()));
            list.add(val);
        }

        String poll(String key, int idx) {
            List<String> list = this.map.get(key);
            return list.size() > idx ? list.get(idx) : null;
        }
    }
}

