/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.openjdk.jcstress.annotations.Actor;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.annotations.JCStressTest;
import org.openjdk.jcstress.annotations.Outcome;
import org.openjdk.jcstress.annotations.State;
import org.openjdk.jcstress.infra.results.II_Result;

public class JMMSample_03_Coherence {

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0, 0"}, expect=Expect.ACCEPTABLE, desc="Doing both reads early."), @Outcome(id={"1, 1"}, expect=Expect.ACCEPTABLE, desc="Doing both reads late."), @Outcome(id={"0, 1"}, expect=Expect.ACCEPTABLE, desc="Doing first read early, not surprising."), @Outcome(id={"1, 0"}, expect=Expect.FORBIDDEN, desc="Violates coherence.")})
    @State
    public static class SameOpaqueRead {
        static final VarHandle VH;
        private final Holder h1;
        private final Holder h2;

        public SameOpaqueRead() {
            this.h2 = this.h1 = new Holder();
        }

        @Actor
        public void actor1() {
            VH.setOpaque(this.h1, 1);
        }

        @Actor
        public void actor2(II_Result r) {
            Holder h1 = this.h1;
            Holder h2 = this.h2;
            h1.trap = 0;
            h2.trap = 0;
            r.r1 = VH.getOpaque(h1);
            r.r2 = VH.getOpaque(h2);
        }

        static {
            try {
                VH = MethodHandles.lookup().findVarHandle(Holder.class, "a", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }

        private static class Holder {
            int a;
            int trap;

            private Holder() {
            }
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0, 0"}, expect=Expect.ACCEPTABLE, desc="Doing both reads early."), @Outcome(id={"1, 1"}, expect=Expect.ACCEPTABLE, desc="Doing both reads late."), @Outcome(id={"0, 1"}, expect=Expect.ACCEPTABLE, desc="Doing first read early, not surprising."), @Outcome(id={"1, 0"}, expect=Expect.FORBIDDEN, desc="Violates coherence.")})
    @State
    public static class SameVolatileRead {
        private final Holder h1;
        private final Holder h2;

        public SameVolatileRead() {
            this.h2 = this.h1 = new Holder();
        }

        @Actor
        public void actor1() {
            this.h1.a = 1;
        }

        @Actor
        public void actor2(II_Result r) {
            Holder h1 = this.h1;
            Holder h2 = this.h2;
            h1.trap = 0;
            h2.trap = 0;
            r.r1 = h1.a;
            r.r2 = h2.a;
        }

        private static class Holder {
            volatile int a;
            int trap;

            private Holder() {
            }
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0, 0"}, expect=Expect.ACCEPTABLE, desc="Doing both reads early."), @Outcome(id={"1, 1"}, expect=Expect.ACCEPTABLE, desc="Doing both reads late."), @Outcome(id={"0, 1"}, expect=Expect.ACCEPTABLE, desc="Doing first read early, not surprising."), @Outcome(id={"1, 0"}, expect=Expect.ACCEPTABLE_INTERESTING, desc="First read seen racy value early, and the second one did not.")})
    @State
    public static class SameRead {
        private final Holder h1;
        private final Holder h2;

        public SameRead() {
            this.h2 = this.h1 = new Holder();
        }

        @Actor
        public void actor1() {
            this.h1.a = 1;
        }

        @Actor
        public void actor2(II_Result r) {
            Holder h1 = this.h1;
            Holder h2 = this.h2;
            h1.trap = 0;
            h2.trap = 0;
            r.r1 = h1.a;
            r.r2 = h2.a;
        }

        private static class Holder {
            int a;
            int trap;

            private Holder() {
            }
        }
    }
}

