/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.openjdk.jcstress.annotations.Actor;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.annotations.JCStressTest;
import org.openjdk.jcstress.annotations.Outcome;
import org.openjdk.jcstress.annotations.State;
import org.openjdk.jcstress.infra.results.II_Result;

public class JMMSample_04_PartialOrder {

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0, 0"}, expect=Expect.ACCEPTABLE, desc="Doing both reads early."), @Outcome(id={"1, 1"}, expect=Expect.ACCEPTABLE, desc="Doing both reads late."), @Outcome(id={"0, 1"}, expect=Expect.FORBIDDEN, desc="Caught in the middle: $x is visible, $y is not."), @Outcome(id={"1, 0"}, expect=Expect.FORBIDDEN, desc="Seeing $y, but not $x!")})
    @State
    public static class LockGuard {
        int x;
        int y;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Actor
        public void actor1() {
            LockGuard lockGuard = this;
            synchronized (lockGuard) {
                this.x = 1;
                this.y = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Actor
        public void actor2(II_Result r) {
            LockGuard lockGuard = this;
            synchronized (lockGuard) {
                r.r1 = this.y;
                r.r2 = this.x;
            }
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0, 0"}, expect=Expect.ACCEPTABLE, desc="Doing both reads early."), @Outcome(id={"1, 1"}, expect=Expect.ACCEPTABLE, desc="Doing both reads late."), @Outcome(id={"0, 1"}, expect=Expect.ACCEPTABLE, desc="Caught in the middle: $x is visible, $y is not."), @Outcome(id={"1, 0"}, expect=Expect.FORBIDDEN, desc="Seeing $y, but not $x!")})
    @State
    public static class AcquireReleaseGuard {
        static final VarHandle VH;
        int x;
        int y;

        @Actor
        public void actor1() {
            this.x = 1;
            VH.setRelease(this, 1);
        }

        @Actor
        public void actor2(II_Result r) {
            r.r1 = VH.getAcquire(this);
            r.r2 = this.x;
        }

        static {
            try {
                VH = MethodHandles.lookup().findVarHandle(AcquireReleaseGuard.class, "y", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0, 0"}, expect=Expect.ACCEPTABLE, desc="Doing both reads early."), @Outcome(id={"1, 1"}, expect=Expect.ACCEPTABLE, desc="Doing both reads late."), @Outcome(id={"0, 1"}, expect=Expect.ACCEPTABLE, desc="Caught in the middle: $x is visible, $y is not."), @Outcome(id={"1, 0"}, expect=Expect.FORBIDDEN, desc="Seeing $y, but not $x!")})
    @State
    public static class VolatileGuard {
        int x;
        volatile int y;

        @Actor
        public void actor1() {
            this.x = 1;
            this.y = 1;
        }

        @Actor
        public void actor2(II_Result r) {
            r.r1 = this.y;
            r.r2 = this.x;
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0, 0"}, expect=Expect.ACCEPTABLE, desc="Doing both reads early."), @Outcome(id={"1, 1"}, expect=Expect.ACCEPTABLE, desc="Doing both reads late."), @Outcome(id={"0, 1"}, expect=Expect.ACCEPTABLE, desc="Caught in the middle: $x is visible, $y is not."), @Outcome(id={"1, 0"}, expect=Expect.ACCEPTABLE_INTERESTING, desc="Seeing $y, but not $x!")})
    @State
    public static class PlainReads {
        int x;
        int y;

        @Actor
        public void actor1() {
            this.x = 1;
            this.y = 1;
        }

        @Actor
        public void actor2(II_Result r) {
            r.r1 = this.y;
            r.r2 = this.x;
        }
    }
}

