/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.openjdk.jcstress.annotations.Actor;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.annotations.JCStressTest;
import org.openjdk.jcstress.annotations.Outcome;
import org.openjdk.jcstress.annotations.State;
import org.openjdk.jcstress.infra.results.II_Result;

public class JMMSample_05_TotalOrder {

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0, 1", "1, 0", "1, 1"}, expect=Expect.ACCEPTABLE, desc="Trivial under sequential consistency"), @Outcome(id={"0, 0"}, expect=Expect.ACCEPTABLE_INTERESTING, desc="Violates sequential consistency")})
    @State
    public static class AcqRelDekker {
        static final VarHandle VH_X;
        static final VarHandle VH_Y;
        int x;
        int y;

        @Actor
        public void actor1(II_Result r) {
            VH_X.setRelease(this, 1);
            r.r1 = VH_Y.getAcquire(this);
        }

        @Actor
        public void actor2(II_Result r) {
            VH_Y.setRelease(this, 1);
            r.r2 = VH_X.getAcquire(this);
        }

        static {
            try {
                VH_X = MethodHandles.lookup().findVarHandle(AcqRelDekker.class, "x", Integer.TYPE);
                VH_Y = MethodHandles.lookup().findVarHandle(AcqRelDekker.class, "y", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0, 1", "1, 0", "1, 1"}, expect=Expect.ACCEPTABLE, desc="Trivial under sequential consistency"), @Outcome(id={"0, 0"}, expect=Expect.FORBIDDEN, desc="Violates sequential consistency")})
    @State
    public static class VolatileDekker {
        volatile int x;
        volatile int y;

        @Actor
        public void actor1(II_Result r) {
            this.x = 1;
            r.r1 = this.y;
        }

        @Actor
        public void actor2(II_Result r) {
            this.y = 1;
            r.r2 = this.x;
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0, 1", "1, 0", "1, 1"}, expect=Expect.ACCEPTABLE, desc="Trivial under sequential consistency"), @Outcome(id={"0, 0"}, expect=Expect.ACCEPTABLE_INTERESTING, desc="Violates sequential consistency")})
    @State
    public static class PlainDekker {
        int x;
        int y;

        @Actor
        public void actor1(II_Result r) {
            this.x = 1;
            r.r1 = this.y;
        }

        @Actor
        public void actor2(II_Result r) {
            this.y = 1;
            r.r2 = this.x;
        }
    }
}

