/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import org.openjdk.jcstress.annotations.Actor;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.annotations.JCStressTest;
import org.openjdk.jcstress.annotations.Outcome;
import org.openjdk.jcstress.annotations.State;
import org.openjdk.jcstress.infra.results.I_Result;

public class JMMSample_06_Finals {

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"-1"}, expect=Expect.ACCEPTABLE, desc="Object is not seen yet."), @Outcome(id={"8"}, expect=Expect.ACCEPTABLE, desc="Seen the complete object."), @Outcome(expect=Expect.FORBIDDEN, desc="Seeing partially constructed object.")})
    @State
    public static class FinalInit {
        int v = 1;
        MyObject o;

        @Actor
        public void actor1() {
            this.o = new MyObject(this.v);
        }

        @Actor
        public void actor2(I_Result r) {
            MyObject o = this.o;
            r.r1 = o != null ? o.x8 + o.x7 + o.x6 + o.x5 + o.x4 + o.x3 + o.x2 + o.x1 : -1;
        }

        public static class MyObject {
            final int x1;
            final int x2;
            final int x3;
            final int x4;
            final int x5;
            final int x6;
            final int x7;
            final int x8;

            public MyObject(int v) {
                this.x1 = v;
                this.x2 = v;
                this.x3 = v;
                this.x4 = v;
                this.x5 = v;
                this.x6 = v;
                this.x7 = v;
                this.x8 = v;
            }
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"-1"}, expect=Expect.ACCEPTABLE, desc="Object is not seen yet."), @Outcome(id={"0", "1", "2", "3", "4", "5", "6", "7"}, expect=Expect.ACCEPTABLE_INTERESTING, desc="Seeing partially constructed object."), @Outcome(id={"8"}, expect=Expect.ACCEPTABLE, desc="Seen the complete object.")})
    @State
    public static class PlainInit {
        int v = 1;
        MyObject o;

        @Actor
        public void actor1() {
            this.o = new MyObject(this.v);
        }

        @Actor
        public void actor2(I_Result r) {
            MyObject o = this.o;
            r.r1 = o != null ? o.x8 + o.x7 + o.x6 + o.x5 + o.x4 + o.x3 + o.x2 + o.x1 : -1;
        }

        public static class MyObject {
            int x1;
            int x2;
            int x3;
            int x4;
            int x5;
            int x6;
            int x7;
            int x8;

            public MyObject(int v) {
                this.x1 = v;
                this.x2 = v;
                this.x3 = v;
                this.x4 = v;
                this.x5 = v;
                this.x6 = v;
                this.x7 = v;
                this.x8 = v;
            }
        }
    }
}

