/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.labelingrules;

import java.util.HashMap;
import org.openjdk.jmc.common.jvm.JVMArch;
import org.openjdk.jmc.common.jvm.JVMType;
import org.openjdk.jmc.common.labelingrules.IVariableEvaluator;
import org.openjdk.jmc.common.labelingrules.NameConverter;
import org.openjdk.jmc.common.messages.internal.Messages;

class Variables {
    private static final HashMap<String, IVariableEvaluator> variables = new HashMap();
    private static final Variables instance = new Variables();

    public Variables() {
        this.initDefaultVariables();
    }

    private void initDefaultVariables() {
        variables.put("StrJVMType", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                JVMType type = (JVMType)((Object)input[NameConverter.ValueArrayInfo.JVMTYPE.getIndex()]);
                String typeStr = this.getLocalizedTypeStr(type);
                if (typeStr == null) {
                    return "";
                }
                return "[" + typeStr + "]";
            }

            private String getLocalizedTypeStr(JVMType type) {
                if (type == JVMType.JROCKIT) {
                    return Messages.getString("NameConverter_JVM_TYPE_JROCKIT");
                }
                if (type == JVMType.HOTSPOT) {
                    return Messages.getString("NameConverter_JVM_TYPE_HOTSPOT");
                }
                if (type == JVMType.OTHER) {
                    return Messages.getString("NameConverter_JVM_TYPE_OTHER");
                }
                return Messages.getString("NameConverter_JVM_TYPE_UNKNOWN");
            }
        });
        variables.put("UnsupportedStrJVMType", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                JVMType type = (JVMType)((Object)input[NameConverter.ValueArrayInfo.JVMTYPE.getIndex()]);
                String typeStr = this.getLocalizedTypeStr(type);
                if (typeStr == null) {
                    return "";
                }
                return "[" + typeStr + "]";
            }

            private String getLocalizedTypeStr(JVMType type) {
                if (type == JVMType.JROCKIT) {
                    return Messages.getString("NameConverter_JVM_TYPE_JROCKIT");
                }
                if (type == JVMType.HOTSPOT) {
                    return null;
                }
                if (type == JVMType.OTHER) {
                    return null;
                }
                return Messages.getString("NameConverter_JVM_TYPE_UNKNOWN");
            }
        });
        variables.put("StrJVMArch", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                JVMArch arch = (JVMArch)((Object)input[NameConverter.ValueArrayInfo.JVMARCH.getIndex()]);
                String archStr = this.getLocalizedArchStr(arch);
                if (archStr == null) {
                    return "";
                }
                return "[" + archStr + "]";
            }

            private String getLocalizedArchStr(JVMArch arch) {
                if (arch == JVMArch.BIT32) {
                    return Messages.getString("NameConverter_JVM_ARCH_32BIT");
                }
                if (arch == JVMArch.BIT64) {
                    return Messages.getString("NameConverter_JVM_ARCH_64BIT");
                }
                if (arch == JVMArch.OTHER) {
                    return Messages.getString("NameConverter_JVM_ARCH_OTHER");
                }
                return Messages.getString("NameConverter_JVM_ARCH_UNKNOWN");
            }
        });
        variables.put("UnsupportedStrJVMArch", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                JVMType type;
                JVMArch arch = (JVMArch)((Object)input[NameConverter.ValueArrayInfo.JVMARCH.getIndex()]);
                String archStr = this.getLocalizedArchStr(arch, type = (JVMType)((Object)input[NameConverter.ValueArrayInfo.JVMTYPE.getIndex()]));
                if (archStr == null) {
                    return "";
                }
                return "[" + archStr + "]";
            }

            private String getLocalizedArchStr(JVMArch arch, JVMType type) {
                JVMArch thisArch = JVMArch.getCurrentJVMArch();
                if (arch == thisArch) {
                    return null;
                }
                if (arch == JVMArch.BIT32) {
                    return Messages.getString("NameConverter_JVM_ARCH_32BIT");
                }
                if (arch == JVMArch.BIT64) {
                    return Messages.getString("NameConverter_JVM_ARCH_64BIT");
                }
                if (arch == JVMArch.OTHER) {
                    return null;
                }
                return type == JVMType.UNKNOWN ? null : Messages.getString("NameConverter_JVM_ARCH_UNKNOWN");
            }
        });
        variables.put("StrDebug", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                return "true".equals(input[NameConverter.ValueArrayInfo.DEBUG.getIndex()]) ? "[ DEBUG ]" : "";
            }
        });
        variables.put("StrJDK", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                String version = (String)input[NameConverter.ValueArrayInfo.JAVAVERSION.getIndex()];
                return version == null ? "" : "[" + version + "]";
            }
        });
        variables.put("JVMArgs", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                return (String)input[NameConverter.ValueArrayInfo.JVMARGS.getIndex()];
            }
        });
    }

    public static Variables getInstance() {
        return instance;
    }

    public boolean containsVariable(String content) {
        return variables.containsKey(content);
    }

    public IVariableEvaluator getVariable(String content) {
        return variables.get(content);
    }
}

