/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.services.internal;

import javax.management.MBeanServerConnection;
import org.openjdk.jmc.common.jvm.JVMDescriptor;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.rjmx.common.ConnectionException;
import org.openjdk.jmc.rjmx.common.ConnectionToolkit;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.common.services.ICommercialFeaturesService;
import org.openjdk.jmc.rjmx.common.services.IServiceFactory;
import org.openjdk.jmc.rjmx.common.services.internal.CommercialFeaturesServiceUtil;
import org.openjdk.jmc.rjmx.common.services.internal.HotSpot23CommercialFeaturesService;
import org.openjdk.jmc.rjmx.common.services.internal.NoCommercialFeaturesService;

public class CommercialFeaturesServiceFactory
implements IServiceFactory<ICommercialFeaturesService> {
    @Override
    public ICommercialFeaturesService getServiceInstance(IConnectionHandle handle) throws ConnectionException, ServiceNotAvailableException {
        JavaVersion version;
        JVMDescriptor descriptor = handle.getServerDescriptor().getJvmInfo();
        MBeanServerConnection server = handle.getServiceOrThrow(MBeanServerConnection.class);
        if (descriptor != null ? (version = new JavaVersion(descriptor.getJavaVersion())).getMajorVersion() >= 11 : handle.isConnected() && ConnectionToolkit.isOracle(handle) && ConnectionToolkit.isJavaVersionAboveOrEqual(handle, JavaVersionSupport.JDK_11)) {
            return new NoCommercialFeaturesService();
        }
        if (ConnectionToolkit.isOracle(handle) && !CommercialFeaturesServiceUtil.isJfrMBeanAvailable(server)) {
            return new HotSpot23CommercialFeaturesService(handle);
        }
        return new NoCommercialFeaturesService();
    }

    @Override
    public Class<ICommercialFeaturesService> getServiceType() {
        return ICommercialFeaturesService.class;
    }
}

