/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.subscription;

import java.io.Serializable;
import javax.management.ObjectName;
import org.openjdk.jmc.rjmx.common.ConnectionToolkit;

public final class MRI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MRI_DELIMITER = "://";
    private static final char ATTRIBUTE_DELIMITER = '/';
    public static final char VALUE_COMPOSITE_DELIMITER = '/';
    public static final String VALUE_COMPOSITE_DELIMITER_STRING = "/";
    private final ObjectName m_objectName;
    private final Type m_type;
    private final String m_dataPath;
    private final String m_qualifiedName;

    public MRI(Type type, ObjectName objectName, String valuePath) {
        if (objectName == null) {
            throw new NullPointerException("objectName may not be null!");
        }
        if (valuePath == null) {
            throw new NullPointerException("valuePath may not be null!");
        }
        if (type == null) {
            throw new NullPointerException("type may not be null!");
        }
        this.m_type = type;
        this.m_objectName = objectName;
        this.m_dataPath = valuePath;
        this.m_qualifiedName = MRI.generateQualifiedName(type, objectName, valuePath).intern();
    }

    public MRI(Type type, String beanName, String dataPath) {
        this(type, ConnectionToolkit.createObjectName(beanName), dataPath);
    }

    public MRI(MRI mri, String child) {
        this(mri.getType(), mri.getObjectName(), mri.getDataPath() + VALUE_COMPOSITE_DELIMITER_STRING + child);
    }

    public String getQualifiedName() {
        return this.m_qualifiedName;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MRI) {
            return this.m_qualifiedName.equals(((MRI)obj).getQualifiedName());
        }
        return false;
    }

    public int hashCode() {
        return this.m_qualifiedName.hashCode();
    }

    public ObjectName getObjectName() {
        return this.m_objectName;
    }

    public String getDataPath() {
        return this.m_dataPath;
    }

    public Type getType() {
        return this.m_type;
    }

    public String toString() {
        return this.m_qualifiedName;
    }

    public static MRI createFromQualifiedName(String qualName) {
        int index = qualName.indexOf(MRI_DELIMITER);
        if (index < 0) {
            throw new IllegalArgumentException(String.format("Malformed FQN. Could not find %s in %s", MRI_DELIMITER, qualName));
        }
        Type type = Type.fromString(qualName.substring(0, index));
        if (type == null) {
            throw new IllegalArgumentException(String.format("%s is not a recognized type.", qualName.substring(0, index)));
        }
        int mbeanStart = index + MRI_DELIMITER.length();
        if ((index = qualName.indexOf(47, mbeanStart)) >= 0) {
            String beanName = qualName.substring(mbeanStart, index);
            String attributeName = qualName.substring(index + 1);
            return new MRI(type, beanName, attributeName);
        }
        throw new IllegalArgumentException(String.format("Malformed FQN. Could not find attribute name delimiter '%s' in %s", Character.valueOf('/'), qualName));
    }

    private static String generateQualifiedName(Type type, ObjectName objectName, String valuePath) {
        return type.getTypeName() + MRI_DELIMITER + objectName.getCanonicalName() + VALUE_COMPOSITE_DELIMITER_STRING + valuePath;
    }

    public boolean isChild(MRI childCandidate) {
        if (!this.m_objectName.equals(childCandidate.getObjectName()) || childCandidate.getType() != this.m_type) {
            return false;
        }
        String childMRIDataPath = childCandidate.getDataPath();
        if (childMRIDataPath.startsWith(this.m_dataPath)) {
            String childDataPath = childMRIDataPath.substring(this.m_dataPath.length());
            return childDataPath.indexOf(47) == 0 && childDataPath.lastIndexOf(47) == 0;
        }
        return false;
    }

    public MRI[] getParentMRIs() {
        String[] dataParts = this.m_dataPath.split(VALUE_COMPOSITE_DELIMITER_STRING);
        MRI[] parentMris = new MRI[dataParts.length - 1];
        StringBuilder dataPath = new StringBuilder();
        for (int i = 0; i < parentMris.length; ++i) {
            dataPath.append(dataParts[i]);
            parentMris[i] = new MRI(this.m_type, this.m_objectName, dataPath.toString());
            dataPath.append('/');
        }
        return parentMris;
    }

    public static enum Type {
        ATTRIBUTE("attribute"),
        NOTIFICATION("notification"),
        TRANSFORMATION("transformation");

        private String typeName;

        private Type(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public static Type fromString(String typeName) {
            for (Type type : Type.values()) {
                if (!typeName.equals(type.getTypeName())) continue;
                return type;
            }
            return null;
        }
    }
}

