/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.openjdk.jmh.generators.annotations.APClassInfo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.GeneratorSource;

public class APGeneratorSource
implements GeneratorSource {
    private final RoundEnvironment roundEnv;
    private final ProcessingEnvironment processingEnv;
    private Collection<ClassInfo> classInfos;

    public APGeneratorSource(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv) {
        this.roundEnv = roundEnv;
        this.processingEnv = processingEnv;
    }

    public Collection<ClassInfo> getClasses() {
        if (this.classInfos != null) {
            return this.classInfos;
        }
        TreeSet<TypeElement> discoveredClasses = new TreeSet<TypeElement>(new Comparator<TypeElement>(){

            @Override
            public int compare(TypeElement o1, TypeElement o2) {
                return o1.getQualifiedName().toString().compareTo(o2.getQualifiedName().toString());
            }
        });
        ArrayList<TypeElement> front = new ArrayList<TypeElement>();
        for (Element element : this.roundEnv.getRootElements()) {
            if (element.getKind() != ElementKind.CLASS) continue;
            front.add((TypeElement)element);
        }
        while (!front.isEmpty()) {
            discoveredClasses.addAll(front);
            ArrayList<TypeElement> newClasses = new ArrayList<TypeElement>();
            Iterator iterator = front.iterator();
            while (iterator.hasNext()) {
                TypeElement e;
                TypeElement walk = e = (TypeElement)iterator.next();
                do {
                    for (TypeElement nested : ElementFilter.typesIn(walk.getEnclosedElements())) {
                        newClasses.add(nested);
                    }
                } while ((walk = (TypeElement)this.processingEnv.getTypeUtils().asElement(walk.getSuperclass())) != null);
            }
            front = newClasses;
        }
        this.classInfos = this.convert(discoveredClasses);
        return this.classInfos;
    }

    protected Collection<ClassInfo> convert(Collection<TypeElement> els) {
        ArrayList<ClassInfo> list = new ArrayList<ClassInfo>();
        for (TypeElement el : els) {
            list.add(new APClassInfo(this.processingEnv, el));
        }
        return list;
    }

    public ClassInfo resolveClass(String className) {
        return new APClassInfo(this.processingEnv, this.processingEnv.getElementUtils().getTypeElement(className));
    }
}

