/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.openjdk.jmh.generators.annotations.APFieldInfo;
import org.openjdk.jmh.generators.annotations.APMetadataInfo;
import org.openjdk.jmh.generators.annotations.APMethodInfo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.MethodInfo;

class APClassInfo
extends APMetadataInfo
implements ClassInfo {
    private final TypeElement el;
    private final boolean isPrimitive;
    private final TypeMirror mirror;

    public APClassInfo(ProcessingEnvironment processEnv, TypeElement element) {
        super(processEnv, element);
        if (element == null) {
            throw new IllegalArgumentException("element is null");
        }
        this.el = element;
        this.isPrimitive = false;
        this.mirror = null;
    }

    public APClassInfo(ProcessingEnvironment processEnv, TypeMirror mirror) {
        super(processEnv, null);
        this.mirror = mirror;
        this.isPrimitive = mirror.getKind().isPrimitive();
        this.el = !this.isPrimitive ? (TypeElement)processEnv.getTypeUtils().asElement(mirror) : null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        if (this.isPrimitive) {
            return null;
        }
        return this.el.getAnnotation(annClass);
    }

    public Collection<MethodInfo> getConstructors() {
        if (this.isPrimitive) {
            return Collections.emptyList();
        }
        ArrayList<MethodInfo> mis = new ArrayList<MethodInfo>();
        for (ExecutableElement e : ElementFilter.constructorsIn(this.el.getEnclosedElements())) {
            mis.add(new APMethodInfo(this.processEnv, this, e));
        }
        return mis;
    }

    public String getName() {
        if (this.isPrimitive) {
            return ((Object)this.mirror).toString();
        }
        return this.el.getSimpleName().toString();
    }

    public String getQualifiedName() {
        if (this.isPrimitive) {
            return ((Object)this.mirror).toString();
        }
        return this.el.getQualifiedName().toString();
    }

    public Collection<FieldInfo> getFields() {
        if (this.isPrimitive) {
            return Collections.emptyList();
        }
        ArrayList<FieldInfo> ls = new ArrayList<FieldInfo>();
        for (VariableElement e : ElementFilter.fieldsIn(this.el.getEnclosedElements())) {
            ls.add(new APFieldInfo(this.processEnv, e));
        }
        return ls;
    }

    public Collection<MethodInfo> getMethods() {
        if (this.isPrimitive) {
            return Collections.emptyList();
        }
        ArrayList<MethodInfo> mis = new ArrayList<MethodInfo>();
        for (ExecutableElement e : ElementFilter.methodsIn(this.el.getEnclosedElements())) {
            mis.add(new APMethodInfo(this.processEnv, this, e));
        }
        return mis;
    }

    public String getPackageName() {
        if (this.isPrimitive) {
            return "";
        }
        Element walk = this.el;
        while (walk.getKind() != ElementKind.PACKAGE) {
            walk = walk.getEnclosingElement();
        }
        return ((PackageElement)walk).getQualifiedName().toString();
    }

    public ClassInfo getSuperClass() {
        if (this.isPrimitive) {
            return null;
        }
        TypeMirror superclass = this.el.getSuperclass();
        if (superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        TypeElement element = (TypeElement)this.processEnv.getTypeUtils().asElement(superclass);
        return new APClassInfo(this.processEnv, element);
    }

    public ClassInfo getDeclaringClass() {
        if (this.isPrimitive) {
            return null;
        }
        Element enclosingElement = this.el.getEnclosingElement();
        if (enclosingElement.getKind() == ElementKind.CLASS) {
            return new APClassInfo(this.processEnv, (TypeElement)enclosingElement);
        }
        return null;
    }

    public boolean isAbstract() {
        if (this.isPrimitive) {
            return false;
        }
        return this.el.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isPublic() {
        if (this.isPrimitive) {
            return true;
        }
        return this.el.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isStrictFP() {
        if (this.isPrimitive) {
            return false;
        }
        return this.el.getModifiers().contains((Object)Modifier.STRICTFP);
    }

    public boolean isFinal() {
        if (this.isPrimitive) {
            return false;
        }
        return this.el.getModifiers().contains((Object)Modifier.FINAL);
    }

    public boolean isInner() {
        if (this.isPrimitive) {
            return false;
        }
        return this.getDeclaringClass() != null && !this.el.getModifiers().contains((Object)Modifier.STATIC);
    }

    public String toString() {
        return this.getQualifiedName();
    }
}

