/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.asm;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import org.objectweb.asm.AnnotationVisitor;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;

class AnnotationInvocationHandler
extends AnnotationVisitor
implements InvocationHandler {
    private final String className;
    private final Multimap<String, Object> values;

    public AnnotationInvocationHandler(String className, AnnotationVisitor annotationVisitor) {
        super(262144, annotationVisitor);
        this.className = className;
        this.values = new HashMultimap();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String member = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (member.equals("equals") && paramTypes.length == 1 && paramTypes[0] == Object.class) {
            return this.equalsImpl(args[0]);
        }
        if (paramTypes.length != 0) {
            throw new AssertionError((Object)"Too many parameters for an annotation method");
        }
        switch (member) {
            case "toString": {
                return this.toStringImpl();
            }
            case "hashCode": {
                return this.hashcodeImpl();
            }
            case "annotationType": {
                throw new IllegalStateException("annotationType is not implemented");
            }
        }
        Collection vs = this.values.get((Object)member);
        if (vs == null || vs.isEmpty()) {
            return method.getDefaultValue();
        }
        if (!returnType.isArray()) {
            Object res = this.peelSingle(vs);
            if (returnType.isEnum()) {
                return this.parseEnum(returnType, res);
            }
            return res;
        }
        Class<String> componentType = returnType.getComponentType();
        if (componentType.isEnum()) {
            Object res = Array.newInstance(componentType, vs.size());
            int c = 0;
            for (Object v : vs) {
                Array.set(res, c, this.parseEnum(componentType, v));
                ++c;
            }
            return res;
        }
        if (componentType.isAssignableFrom(String.class)) {
            return vs.toArray(new String[0]);
        }
        throw new IllegalStateException("Primitive arrays are not handled yet");
    }

    private Object peelSingle(Collection<Object> vs) {
        if (vs.size() != 1) {
            throw new IllegalStateException("Expected to see a single value, but got " + vs.size());
        }
        Object res = vs.iterator().next();
        return res;
    }

    private String toStringImpl() {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(this.className);
        sb.append("(");
        for (String k : this.values.keys()) {
            sb.append(k);
            sb.append(" = ");
            sb.append(this.values.get((Object)k));
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private Object parseEnum(Class<?> type, Object res) throws Exception {
        if (res == null) {
            throw new IllegalStateException("The argument is null");
        }
        if (!(res instanceof String)) {
            throw new IllegalStateException("The argument is not String, but " + res.getClass());
        }
        Method m = type.getMethod("valueOf", String.class);
        return m.invoke(null, res);
    }

    private int hashcodeImpl() {
        int result = this.className.hashCode();
        for (String k : this.values.keys()) {
            result = 31 * result + k.hashCode();
        }
        return result;
    }

    private boolean equalsImpl(Object arg) {
        AnnotationInvocationHandler other = this.asOneOfUs(arg);
        if (other != null) {
            if (!this.className.equals(other.className)) {
                return false;
            }
            HashSet keys = new HashSet();
            keys.addAll(this.values.keys());
            keys.addAll(other.values.keys());
            for (String k : keys) {
                Collection o1 = this.values.get((Object)k);
                Collection o2 = other.values.get((Object)k);
                if (o1 == null || o2 == null) {
                    return false;
                }
                if (o1.size() != o2.size()) {
                    return false;
                }
                if (o1.containsAll(o2) && o2.containsAll(o1)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalStateException("Expected to see only AnnotationInvocationHandler-backed annotations");
    }

    private AnnotationInvocationHandler asOneOfUs(Object o) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(o.getClass()) && (handler = Proxy.getInvocationHandler(o)) instanceof AnnotationInvocationHandler) {
            return (AnnotationInvocationHandler)handler;
        }
        return null;
    }

    public void visit(String name, Object value) {
        this.values.put((Object)name, value);
        super.visit(name, value);
    }

    public void visitEnum(String name, String desc, String value) {
        this.values.put((Object)name, (Object)value);
        super.visitEnum(name, desc, value);
    }

    public AnnotationVisitor visitArray(final String name) {
        return new AnnotationVisitor(262144, super.visitArray(name)){

            public void visitEnum(String n, String desc, String value) {
                AnnotationInvocationHandler.this.values.put((Object)name, (Object)value);
                super.visitEnum(n, desc, value);
            }

            public void visit(String n, Object value) {
                AnnotationInvocationHandler.this.values.put((Object)name, value);
                super.visit(n, value);
            }
        };
    }
}

