/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.openjdk.jmh.generators.bytecode.ASMGeneratorSource;
import org.openjdk.jmh.generators.core.BenchmarkGenerator;
import org.openjdk.jmh.generators.core.FileSystemDestination;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.generators.core.SourceError;

public class JmhMojo
extends AbstractMojo {
    private File compiledBytecodeDirectory;
    private File outputResourceDirectory;
    private File outputSourceDirectory;
    private MavenProject project;

    public void extendPluginClasspath() throws MojoExecutionException {
        try {
            HashSet<URL> urls = new HashSet<URL>();
            ArrayList elements = new ArrayList();
            elements.addAll(this.project.getTestClasspathElements());
            elements.addAll(this.project.getRuntimeClasspathElements());
            elements.addAll(this.project.getCompileClasspathElements());
            elements.addAll(this.project.getSystemClasspathElements());
            for (String element : elements) {
                urls.add(new File(element).toURI().toURL());
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Internal error", (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Internal error", (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.extendPluginClasspath();
        ASMGeneratorSource source = new ASMGeneratorSource();
        FileSystemDestination destination = new FileSystemDestination(this.outputResourceDirectory, this.outputSourceDirectory);
        try {
            Collection<File> classes = this.getClasses(this.compiledBytecodeDirectory);
            this.getLog().info((CharSequence)("Processing " + classes.size() + " classes from " + this.compiledBytecodeDirectory));
            this.getLog().info((CharSequence)("Writing out Java source to " + this.outputSourceDirectory + " and resources to " + this.outputResourceDirectory));
            source.processClasses(classes);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("IOException", (Exception)ioe);
        }
        BenchmarkGenerator gen = new BenchmarkGenerator();
        gen.generate((GeneratorSource)source, (GeneratorDestination)destination);
        gen.complete((GeneratorSource)source, (GeneratorDestination)destination);
        if (destination.hasErrors()) {
            for (SourceError e : destination.getErrors()) {
                this.getLog().error((CharSequence)(e.toString() + "\n"));
            }
            throw new MojoFailureException("Errors detected.");
        }
    }

    public Collection<File> getClasses(File root) {
        ArrayList<File> result = new ArrayList<File>();
        ArrayList<File> newDirs = new ArrayList<File>();
        newDirs.add(root);
        while (!newDirs.isEmpty()) {
            ArrayList<File> add = new ArrayList<File>();
            for (File dir : newDirs) {
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (f.isDirectory()) {
                        add.add(f);
                        continue;
                    }
                    if (!f.getName().endsWith(".class")) continue;
                    result.add(f);
                }
            }
            newDirs.clear();
            newDirs = add;
        }
        return result;
    }
}

