/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.NodeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.InsetsConverter;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.css.converter.StringConverter;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.OverrunStyle;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="text")
public abstract class Labeled
extends Control {
    private static final String DEFAULT_ELLIPSIS_STRING = "...";
    private StringProperty text;
    private ObjectProperty<Pos> alignment;
    private ObjectProperty<TextAlignment> textAlignment;
    private ObjectProperty<OverrunStyle> textOverrun;
    private StringProperty ellipsisString;
    private BooleanProperty wrapText;
    private ObjectProperty<Font> font;
    private ObjectProperty<Node> graphic;
    private StyleableStringProperty imageUrl = null;
    private BooleanProperty underline;
    private DoubleProperty lineSpacing;
    private ObjectProperty<ContentDisplay> contentDisplay;
    private ObjectProperty<Insets> labelPadding;
    private DoubleProperty graphicTextGap;
    private ObjectProperty<Paint> textFill;
    private BooleanProperty mnemonicParsing;

    public Labeled() {
    }

    public Labeled(String string) {
        this.setText(string);
    }

    public Labeled(String string, Node node) {
        this.setText(string);
        ((StyleableProperty)this.graphicProperty()).applyStyle(null, (Object)node);
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty((Object)this, "text", "");
        }
        return this.text;
    }

    public final void setText(String string) {
        this.textProperty().setValue(string);
    }

    public final String getText() {
        return this.text == null ? "" : this.text.getValue();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.CENTER_LEFT){

                public CssMetaData<Labeled, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set((Object)pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.CENTER_LEFT : (Pos)this.alignment.get();
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new StyleableObjectProperty<TextAlignment>(TextAlignment.LEFT){

                public CssMetaData<Labeled, TextAlignment> getCssMetaData() {
                    return StyleableProperties.TEXT_ALIGNMENT;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "textAlignment";
                }
            };
        }
        return this.textAlignment;
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().setValue((Object)textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        return this.textAlignment == null ? TextAlignment.LEFT : (TextAlignment)this.textAlignment.getValue();
    }

    public final ObjectProperty<OverrunStyle> textOverrunProperty() {
        if (this.textOverrun == null) {
            this.textOverrun = new StyleableObjectProperty<OverrunStyle>(OverrunStyle.ELLIPSIS){

                public CssMetaData<Labeled, OverrunStyle> getCssMetaData() {
                    return StyleableProperties.TEXT_OVERRUN;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "textOverrun";
                }
            };
        }
        return this.textOverrun;
    }

    public final void setTextOverrun(OverrunStyle overrunStyle) {
        this.textOverrunProperty().setValue((Object)overrunStyle);
    }

    public final OverrunStyle getTextOverrun() {
        return this.textOverrun == null ? OverrunStyle.ELLIPSIS : (OverrunStyle)((Object)this.textOverrun.getValue());
    }

    public final StringProperty ellipsisStringProperty() {
        if (this.ellipsisString == null) {
            this.ellipsisString = new StyleableStringProperty(DEFAULT_ELLIPSIS_STRING){

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "ellipsisString";
                }

                public CssMetaData<Labeled, String> getCssMetaData() {
                    return StyleableProperties.ELLIPSIS_STRING;
                }
            };
        }
        return this.ellipsisString;
    }

    public final void setEllipsisString(String string) {
        this.ellipsisStringProperty().set((Object)(string == null ? "" : string));
    }

    public final String getEllipsisString() {
        return this.ellipsisString == null ? DEFAULT_ELLIPSIS_STRING : (String)this.ellipsisString.get();
    }

    public final BooleanProperty wrapTextProperty() {
        if (this.wrapText == null) {
            this.wrapText = new StyleableBooleanProperty(){

                public CssMetaData<Labeled, Boolean> getCssMetaData() {
                    return StyleableProperties.WRAP_TEXT;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "wrapText";
                }
            };
        }
        return this.wrapText;
    }

    public final void setWrapText(boolean bl) {
        this.wrapTextProperty().setValue(Boolean.valueOf(bl));
    }

    public final boolean isWrapText() {
        return this.wrapText == null ? false : this.wrapText.getValue();
    }

    public Orientation getContentBias() {
        return this.isWrapText() ? Orientation.HORIZONTAL : null;
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new StyleableObjectProperty<Font>(Font.getDefault()){
                private boolean fontSetByCss;
                {
                    this.fontSetByCss = false;
                }

                public void applyStyle(StyleOrigin styleOrigin, Font font) {
                    try {
                        this.fontSetByCss = true;
                        super.applyStyle(styleOrigin, (Object)font);
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                    finally {
                        this.fontSetByCss = false;
                    }
                }

                public void set(Font font) {
                    Font font2 = (Font)this.get();
                    if (font != null ? !font.equals((Object)font2) : font2 != null) {
                        super.set((Object)font);
                    }
                }

                protected void invalidated() {
                    if (!this.fontSetByCss) {
                        NodeHelper.reapplyCSS((Node)Labeled.this);
                    }
                }

                public CssMetaData<Labeled, Font> getCssMetaData() {
                    return StyleableProperties.FONT;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "font";
                }
            };
        }
        return this.font;
    }

    public final void setFont(Font font) {
        this.fontProperty().setValue((Object)font);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.getValue();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new StyleableObjectProperty<Node>(){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.GRAPHIC;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "graphic";
                }
            };
        }
        return this.graphic;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().setValue((Object)node);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.getValue();
    }

    private StyleableStringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new StyleableStringProperty(){
                StyleOrigin origin = StyleOrigin.USER;

                public void applyStyle(StyleOrigin styleOrigin, String string) {
                    this.origin = styleOrigin;
                    if (Labeled.this.graphic == null || !Labeled.this.graphic.isBound()) {
                        super.applyStyle(styleOrigin, string);
                    }
                    this.origin = StyleOrigin.USER;
                }

                protected void invalidated() {
                    String string = super.get();
                    if (string == null) {
                        ((StyleableProperty)Labeled.this.graphicProperty()).applyStyle(this.origin, null);
                    } else {
                        String string2;
                        ImageView imageView;
                        Image image;
                        Node node = Labeled.this.getGraphic();
                        if (node instanceof ImageView && (image = (imageView = (ImageView)node).getImage()) != null && string.equals(string2 = image.getUrl())) {
                            return;
                        }
                        imageView = StyleManager.getInstance().getCachedImage(string);
                        if (imageView != null) {
                            ((StyleableProperty)Labeled.this.graphicProperty()).applyStyle(this.origin, (Object)new ImageView((Image)imageView));
                        }
                    }
                }

                public String get() {
                    Image image;
                    Node node = Labeled.this.getGraphic();
                    if (node instanceof ImageView && (image = ((ImageView)node).getImage()) != null) {
                        return image.getUrl();
                    }
                    return null;
                }

                public StyleOrigin getStyleOrigin() {
                    return Labeled.this.graphic != null ? ((StyleableProperty)Labeled.this.graphic).getStyleOrigin() : null;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "imageUrl";
                }

                public CssMetaData<Labeled, String> getCssMetaData() {
                    return StyleableProperties.GRAPHIC;
                }
            };
        }
        return this.imageUrl;
    }

    public final BooleanProperty underlineProperty() {
        if (this.underline == null) {
            this.underline = new StyleableBooleanProperty(false){

                public CssMetaData<Labeled, Boolean> getCssMetaData() {
                    return StyleableProperties.UNDERLINE;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "underline";
                }
            };
        }
        return this.underline;
    }

    public final void setUnderline(boolean bl) {
        this.underlineProperty().setValue(Boolean.valueOf(bl));
    }

    public final boolean isUnderline() {
        return this.underline == null ? false : this.underline.getValue();
    }

    public final DoubleProperty lineSpacingProperty() {
        if (this.lineSpacing == null) {
            this.lineSpacing = new StyleableDoubleProperty(0.0){

                public CssMetaData<Labeled, Number> getCssMetaData() {
                    return StyleableProperties.LINE_SPACING;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "lineSpacing";
                }
            };
        }
        return this.lineSpacing;
    }

    public final void setLineSpacing(double d) {
        this.lineSpacingProperty().setValue((Number)d);
    }

    public final double getLineSpacing() {
        return this.lineSpacing == null ? 0.0 : this.lineSpacing.getValue();
    }

    public final ObjectProperty<ContentDisplay> contentDisplayProperty() {
        if (this.contentDisplay == null) {
            this.contentDisplay = new StyleableObjectProperty<ContentDisplay>(ContentDisplay.LEFT){

                public CssMetaData<Labeled, ContentDisplay> getCssMetaData() {
                    return StyleableProperties.CONTENT_DISPLAY;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "contentDisplay";
                }
            };
        }
        return this.contentDisplay;
    }

    public final void setContentDisplay(ContentDisplay contentDisplay) {
        this.contentDisplayProperty().setValue((Object)contentDisplay);
    }

    public final ContentDisplay getContentDisplay() {
        return this.contentDisplay == null ? ContentDisplay.LEFT : (ContentDisplay)((Object)this.contentDisplay.getValue());
    }

    public final ReadOnlyObjectProperty<Insets> labelPaddingProperty() {
        return this.labelPaddingPropertyImpl();
    }

    private ObjectProperty<Insets> labelPaddingPropertyImpl() {
        if (this.labelPadding == null) {
            this.labelPadding = new StyleableObjectProperty<Insets>(Insets.EMPTY){
                private Insets lastValidValue;
                {
                    this.lastValidValue = Insets.EMPTY;
                }

                public void invalidated() {
                    Insets insets = (Insets)this.get();
                    if (insets == null) {
                        this.set(this.lastValidValue);
                        throw new NullPointerException("cannot set labelPadding to null");
                    }
                    this.lastValidValue = insets;
                    Labeled.this.requestLayout();
                }

                public CssMetaData<Labeled, Insets> getCssMetaData() {
                    return StyleableProperties.LABEL_PADDING;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "labelPadding";
                }
            };
        }
        return this.labelPadding;
    }

    private void setLabelPadding(Insets insets) {
        this.labelPaddingPropertyImpl().set((Object)insets);
    }

    public final Insets getLabelPadding() {
        return this.labelPadding == null ? Insets.EMPTY : (Insets)this.labelPadding.get();
    }

    public final DoubleProperty graphicTextGapProperty() {
        if (this.graphicTextGap == null) {
            this.graphicTextGap = new StyleableDoubleProperty(4.0){

                public CssMetaData<Labeled, Number> getCssMetaData() {
                    return StyleableProperties.GRAPHIC_TEXT_GAP;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "graphicTextGap";
                }
            };
        }
        return this.graphicTextGap;
    }

    public final void setGraphicTextGap(double d) {
        this.graphicTextGapProperty().setValue((Number)d);
    }

    public final double getGraphicTextGap() {
        return this.graphicTextGap == null ? 4.0 : this.graphicTextGap.getValue();
    }

    public final void setTextFill(Paint paint) {
        this.textFillProperty().set((Object)paint);
    }

    public final Paint getTextFill() {
        return this.textFill == null ? Color.BLACK : (Paint)this.textFill.get();
    }

    public final ObjectProperty<Paint> textFillProperty() {
        if (this.textFill == null) {
            this.textFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData<Labeled, Paint> getCssMetaData() {
                    return StyleableProperties.TEXT_FILL;
                }

                public Object getBean() {
                    return Labeled.this;
                }

                public String getName() {
                    return "textFill";
                }
            };
        }
        return this.textFill;
    }

    public final void setMnemonicParsing(boolean bl) {
        this.mnemonicParsingProperty().set(bl);
    }

    public final boolean isMnemonicParsing() {
        return this.mnemonicParsing == null ? false : this.mnemonicParsing.get();
    }

    public final BooleanProperty mnemonicParsingProperty() {
        if (this.mnemonicParsing == null) {
            this.mnemonicParsing = new SimpleBooleanProperty((Object)this, "mnemonicParsing");
        }
        return this.mnemonicParsing;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString()).append("'").append(this.getText()).append("'");
        return stringBuilder.toString();
    }

    protected Pos getInitialAlignment() {
        return Pos.CENTER_LEFT;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Labeled.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final FontCssMetaData<Labeled> FONT = new FontCssMetaData<Labeled>("-fx-font", Font.getDefault()){

            public boolean isSettable(Labeled labeled) {
                return labeled.font == null || !labeled.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.fontProperty();
            }
        };
        private static final CssMetaData<Labeled, Pos> ALIGNMENT = new CssMetaData<Labeled, Pos>("-fx-alignment", (StyleConverter)new EnumConverter(Pos.class), Pos.CENTER_LEFT){

            public boolean isSettable(Labeled labeled) {
                return labeled.alignment == null || !labeled.alignment.isBound();
            }

            public StyleableProperty<Pos> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.alignmentProperty();
            }

            public Pos getInitialValue(Labeled labeled) {
                return labeled.getInitialAlignment();
            }
        };
        private static final CssMetaData<Labeled, TextAlignment> TEXT_ALIGNMENT = new CssMetaData<Labeled, TextAlignment>("-fx-text-alignment", (StyleConverter)new EnumConverter(TextAlignment.class), TextAlignment.LEFT){

            public boolean isSettable(Labeled labeled) {
                return labeled.textAlignment == null || !labeled.textAlignment.isBound();
            }

            public StyleableProperty<TextAlignment> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.textAlignmentProperty();
            }
        };
        private static final CssMetaData<Labeled, Paint> TEXT_FILL = new CssMetaData<Labeled, Paint>("-fx-text-fill", PaintConverter.getInstance(), (Paint)Color.BLACK){

            public boolean isSettable(Labeled labeled) {
                return labeled.textFill == null || !labeled.textFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.textFillProperty();
            }
        };
        private static final CssMetaData<Labeled, OverrunStyle> TEXT_OVERRUN = new CssMetaData<Labeled, OverrunStyle>("-fx-text-overrun", (StyleConverter)new EnumConverter(OverrunStyle.class), OverrunStyle.ELLIPSIS){

            public boolean isSettable(Labeled labeled) {
                return labeled.textOverrun == null || !labeled.textOverrun.isBound();
            }

            public StyleableProperty<OverrunStyle> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.textOverrunProperty();
            }
        };
        private static final CssMetaData<Labeled, String> ELLIPSIS_STRING = new CssMetaData<Labeled, String>("-fx-ellipsis-string", StringConverter.getInstance(), "..."){

            public boolean isSettable(Labeled labeled) {
                return labeled.ellipsisString == null || !labeled.ellipsisString.isBound();
            }

            public StyleableProperty<String> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.ellipsisStringProperty();
            }
        };
        private static final CssMetaData<Labeled, Boolean> WRAP_TEXT = new CssMetaData<Labeled, Boolean>("-fx-wrap-text", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(Labeled labeled) {
                return labeled.wrapText == null || !labeled.wrapText.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.wrapTextProperty();
            }
        };
        private static final CssMetaData<Labeled, String> GRAPHIC = new CssMetaData<Labeled, String>("-fx-graphic", StringConverter.getInstance()){

            public boolean isSettable(Labeled labeled) {
                return labeled.graphic == null || !labeled.graphic.isBound();
            }

            public StyleableProperty<String> getStyleableProperty(Labeled labeled) {
                return labeled.imageUrlProperty();
            }
        };
        private static final CssMetaData<Labeled, Boolean> UNDERLINE = new CssMetaData<Labeled, Boolean>("-fx-underline", BooleanConverter.getInstance(), Boolean.FALSE){

            public boolean isSettable(Labeled labeled) {
                return labeled.underline == null || !labeled.underline.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.underlineProperty();
            }
        };
        private static final CssMetaData<Labeled, Number> LINE_SPACING = new CssMetaData<Labeled, Number>("-fx-line-spacing", SizeConverter.getInstance(), (Number)0){

            public boolean isSettable(Labeled labeled) {
                return labeled.lineSpacing == null || !labeled.lineSpacing.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.lineSpacingProperty();
            }
        };
        private static final CssMetaData<Labeled, ContentDisplay> CONTENT_DISPLAY = new CssMetaData<Labeled, ContentDisplay>("-fx-content-display", (StyleConverter)new EnumConverter(ContentDisplay.class), ContentDisplay.LEFT){

            public boolean isSettable(Labeled labeled) {
                return labeled.contentDisplay == null || !labeled.contentDisplay.isBound();
            }

            public StyleableProperty<ContentDisplay> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.contentDisplayProperty();
            }
        };
        private static final CssMetaData<Labeled, Insets> LABEL_PADDING = new CssMetaData<Labeled, Insets>("-fx-label-padding", InsetsConverter.getInstance(), Insets.EMPTY){

            public boolean isSettable(Labeled labeled) {
                return labeled.labelPadding == null || !labeled.labelPadding.isBound();
            }

            public StyleableProperty<Insets> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.labelPaddingPropertyImpl();
            }
        };
        private static final CssMetaData<Labeled, Number> GRAPHIC_TEXT_GAP = new CssMetaData<Labeled, Number>("-fx-graphic-text-gap", SizeConverter.getInstance(), (Number)4.0){

            public boolean isSettable(Labeled labeled) {
                return labeled.graphicTextGap == null || !labeled.graphicTextGap.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(Labeled labeled) {
                return (StyleableProperty)labeled.graphicTextGapProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(arrayList, FONT, ALIGNMENT, TEXT_ALIGNMENT, TEXT_FILL, TEXT_OVERRUN, ELLIPSIS_STRING, WRAP_TEXT, GRAPHIC, UNDERLINE, LINE_SPACING, CONTENT_DISPLAY, LABEL_PADDING, GRAPHIC_TEXT_GAP);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

