/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import com.sun.javafx.charts.Legend;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public abstract class Chart
extends Region {
    private static final int MIN_WIDTH_TO_LEAVE_FOR_CHART_CONTENT = 200;
    private static final int MIN_HEIGHT_TO_LEAVE_FOR_CHART_CONTENT = 150;
    private final Label titleLabel = new Label();
    private final Pane chartContent = new Pane(){

        protected void layoutChildren() {
            double d = this.snappedTopInset();
            double d2 = this.snappedLeftInset();
            double d3 = this.snappedBottomInset();
            double d4 = this.snappedRightInset();
            double d5 = this.getWidth();
            double d6 = this.getHeight();
            double d7 = this.snapSizeX(d5 - (d2 + d4));
            double d8 = this.snapSizeY(d6 - (d + d3));
            Chart.this.layoutChartChildren(this.snapPositionY(d), this.snapPositionX(d2), d7, d8);
        }

        public boolean usesMirroring() {
            return Chart.this.useChartContentMirroring;
        }
    };
    boolean useChartContentMirroring = true;
    private final ChartLayoutAnimator animator = new ChartLayoutAnimator((Parent)this.chartContent);
    private StringProperty title = new StringPropertyBase(){

        protected void invalidated() {
            Chart.this.titleLabel.setText(this.get());
        }

        public Object getBean() {
            return Chart.this;
        }

        public String getName() {
            return "title";
        }
    };
    private ObjectProperty<Side> titleSide = new StyleableObjectProperty<Side>(Side.TOP){

        protected void invalidated() {
            Chart.this.requestLayout();
        }

        public CssMetaData<Chart, Side> getCssMetaData() {
            return StyleableProperties.TITLE_SIDE;
        }

        public Object getBean() {
            return Chart.this;
        }

        public String getName() {
            return "titleSide";
        }
    };
    private final ObjectProperty<Node> legend = new ObjectPropertyBase<Node>(){
        private Node old = null;

        protected void invalidated() {
            Node node = (Node)this.get();
            if (this.old != null) {
                Chart.this.getChildren().remove((Object)this.old);
            }
            if (node != null) {
                Chart.this.getChildren().add((Object)node);
                node.setVisible(Chart.this.isLegendVisible());
            }
            this.old = node;
        }

        public Object getBean() {
            return Chart.this;
        }

        public String getName() {
            return "legend";
        }
    };
    private final BooleanProperty legendVisible = new StyleableBooleanProperty(true){

        protected void invalidated() {
            Chart.this.requestLayout();
        }

        public CssMetaData<Chart, Boolean> getCssMetaData() {
            return StyleableProperties.LEGEND_VISIBLE;
        }

        public Object getBean() {
            return Chart.this;
        }

        public String getName() {
            return "legendVisible";
        }
    };
    private ObjectProperty<Side> legendSide = new StyleableObjectProperty<Side>(Side.BOTTOM){

        protected void invalidated() {
            Side side = (Side)this.get();
            Node node = Chart.this.getLegend();
            if (node instanceof Legend) {
                ((Legend)node).setVertical(Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side));
            }
            Chart.this.requestLayout();
        }

        public CssMetaData<Chart, Side> getCssMetaData() {
            return StyleableProperties.LEGEND_SIDE;
        }

        public Object getBean() {
            return Chart.this;
        }

        public String getName() {
            return "legendSide";
        }
    };
    private BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", true);

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final void setTitle(String string) {
        this.title.set((Object)string);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final Side getTitleSide() {
        return (Side)this.titleSide.get();
    }

    public final void setTitleSide(Side side) {
        this.titleSide.set((Object)side);
    }

    public final ObjectProperty<Side> titleSideProperty() {
        return this.titleSide;
    }

    protected final Node getLegend() {
        return (Node)this.legend.getValue();
    }

    protected final void setLegend(Node node) {
        this.legend.setValue((Object)node);
    }

    protected final ObjectProperty<Node> legendProperty() {
        return this.legend;
    }

    public final boolean isLegendVisible() {
        return this.legendVisible.getValue();
    }

    public final void setLegendVisible(boolean bl) {
        this.legendVisible.setValue(Boolean.valueOf(bl));
    }

    public final BooleanProperty legendVisibleProperty() {
        return this.legendVisible;
    }

    public final Side getLegendSide() {
        return (Side)this.legendSide.get();
    }

    public final void setLegendSide(Side side) {
        this.legendSide.set((Object)side);
    }

    public final ObjectProperty<Side> legendSideProperty() {
        return this.legendSide;
    }

    public final boolean getAnimated() {
        return this.animated.get();
    }

    public final void setAnimated(boolean bl) {
        this.animated.set(bl);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    protected ObservableList<Node> getChartChildren() {
        return this.chartContent.getChildren();
    }

    public Chart() {
        this.titleLabel.setAlignment(Pos.CENTER);
        this.titleLabel.focusTraversableProperty().bind((ObservableValue)Platform.accessibilityActiveProperty());
        this.getChildren().addAll((Object[])new Node[]{this.titleLabel, this.chartContent});
        this.getStyleClass().add((Object)"chart");
        this.titleLabel.getStyleClass().add((Object)"chart-title");
        this.chartContent.getStyleClass().add((Object)"chart-content");
        this.chartContent.setManaged(false);
    }

    void animate(KeyFrame ... keyFrameArray) {
        this.animator.animate(keyFrameArray);
    }

    protected void animate(Animation animation) {
        this.animator.animate(animation);
    }

    protected void requestChartLayout() {
        this.chartContent.requestLayout();
    }

    protected final boolean shouldAnimate() {
        return this.getAnimated() && NodeHelper.isTreeShowing((Node)this);
    }

    protected abstract void layoutChartChildren(double var1, double var3, double var5, double var7);

    protected void layoutChildren() {
        double d = this.snappedTopInset();
        double d2 = this.snappedLeftInset();
        double d3 = this.snappedBottomInset();
        double d4 = this.snappedRightInset();
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        if (this.getTitle() != null) {
            this.titleLabel.setVisible(true);
            if (this.getTitleSide().equals((Object)Side.TOP)) {
                var13_7 = this.snapSizeY(this.titleLabel.prefHeight(d5 - d2 - d4));
                this.titleLabel.resizeRelocate(d2, d, d5 - d2 - d4, var13_7);
                d += var13_7;
            } else if (this.getTitleSide().equals((Object)Side.BOTTOM)) {
                var13_7 = this.snapSizeY(this.titleLabel.prefHeight(d5 - d2 - d4));
                this.titleLabel.resizeRelocate(d2, d6 - d3 - var13_7, d5 - d2 - d4, var13_7);
                d3 += var13_7;
            } else if (this.getTitleSide().equals((Object)Side.LEFT)) {
                var13_7 = this.snapSizeX(this.titleLabel.prefWidth(d6 - d - d3));
                this.titleLabel.resizeRelocate(d2, d, var13_7, d6 - d - d3);
                d2 += var13_7;
            } else if (this.getTitleSide().equals((Object)Side.RIGHT)) {
                var13_7 = this.snapSizeX(this.titleLabel.prefWidth(d6 - d - d3));
                this.titleLabel.resizeRelocate(d5 - d4 - var13_7, d, var13_7, d6 - d - d3);
                d4 += var13_7;
            }
        } else {
            this.titleLabel.setVisible(false);
        }
        Node node = this.getLegend();
        if (node != null) {
            boolean bl = this.isLegendVisible();
            if (bl) {
                if (this.getLegendSide() == Side.TOP) {
                    double d7 = this.snapSizeY(node.prefHeight(d5 - d2 - d4));
                    double d8 = Utils.boundedSize(this.snapSizeX(node.prefWidth(d7)), 0.0, d5 - d2 - d4);
                    node.resizeRelocate(d2 + (d5 - d2 - d4 - d8) / 2.0, d, d8, d7);
                    if (d6 - d3 - d - d7 < 150.0) {
                        bl = false;
                    } else {
                        d += d7;
                    }
                } else if (this.getLegendSide() == Side.BOTTOM) {
                    double d9 = this.snapSizeY(node.prefHeight(d5 - d2 - d4));
                    double d10 = Utils.boundedSize(this.snapSizeX(node.prefWidth(d9)), 0.0, d5 - d2 - d4);
                    node.resizeRelocate(d2 + (d5 - d2 - d4 - d10) / 2.0, d6 - d3 - d9, d10, d9);
                    if (d6 - d3 - d - d9 < 150.0) {
                        bl = false;
                    } else {
                        d3 += d9;
                    }
                } else if (this.getLegendSide() == Side.LEFT) {
                    double d11 = this.snapSizeX(node.prefWidth(d6 - d - d3));
                    double d12 = Utils.boundedSize(this.snapSizeY(node.prefHeight(d11)), 0.0, d6 - d - d3);
                    node.resizeRelocate(d2, d + (d6 - d - d3 - d12) / 2.0, d11, d12);
                    if (d5 - d2 - d4 - d11 < 200.0) {
                        bl = false;
                    } else {
                        d2 += d11;
                    }
                } else if (this.getLegendSide() == Side.RIGHT) {
                    double d13 = this.snapSizeX(node.prefWidth(d6 - d - d3));
                    double d14 = Utils.boundedSize(this.snapSizeY(node.prefHeight(d13)), 0.0, d6 - d - d3);
                    node.resizeRelocate(d5 - d4 - d13, d + (d6 - d - d3 - d14) / 2.0, d13, d14);
                    if (d5 - d2 - d4 - d13 < 200.0) {
                        bl = false;
                    } else {
                        d4 += d13;
                    }
                }
            }
            node.setVisible(bl);
        }
        this.chartContent.resizeRelocate(d2, d, d5 - d2 - d4, d6 - d - d3);
    }

    protected double computeMinHeight(double d) {
        return 150.0;
    }

    protected double computeMinWidth(double d) {
        return 200.0;
    }

    protected double computePrefWidth(double d) {
        return 500.0;
    }

    protected double computePrefHeight(double d) {
        return 400.0;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Chart.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Chart, Side> TITLE_SIDE = new CssMetaData<Chart, Side>("-fx-title-side", (StyleConverter)new EnumConverter(Side.class), Side.TOP){

            public boolean isSettable(Chart chart) {
                return chart.titleSide == null || !chart.titleSide.isBound();
            }

            public StyleableProperty<Side> getStyleableProperty(Chart chart) {
                return (StyleableProperty)chart.titleSideProperty();
            }
        };
        private static final CssMetaData<Chart, Side> LEGEND_SIDE = new CssMetaData<Chart, Side>("-fx-legend-side", (StyleConverter)new EnumConverter(Side.class), Side.BOTTOM){

            public boolean isSettable(Chart chart) {
                return chart.legendSide == null || !chart.legendSide.isBound();
            }

            public StyleableProperty<Side> getStyleableProperty(Chart chart) {
                return (StyleableProperty)chart.legendSideProperty();
            }
        };
        private static final CssMetaData<Chart, Boolean> LEGEND_VISIBLE = new CssMetaData<Chart, Boolean>("-fx-legend-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public boolean isSettable(Chart chart) {
                return chart.legendVisible == null || !chart.legendVisible.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(Chart chart) {
                return (StyleableProperty)chart.legendVisibleProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> arrayList = new ArrayList<Object>(Region.getClassCssMetaData());
            arrayList.add(TITLE_SIDE);
            arrayList.add(LEGEND_VISIBLE);
            arrayList.add(LEGEND_SIDE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

