/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.SeparatorSkin;

public class Separator
extends Control {
    private ObjectProperty<Orientation> orientation = new StyleableObjectProperty<Orientation>(Orientation.HORIZONTAL){

        protected void invalidated() {
            boolean bl = this.get() == Orientation.VERTICAL;
            Separator.this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, bl);
            Separator.this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, !bl);
        }

        public CssMetaData<Separator, Orientation> getCssMetaData() {
            return StyleableProperties.ORIENTATION;
        }

        public Object getBean() {
            return Separator.this;
        }

        public String getName() {
            return "orientation";
        }
    };
    private ObjectProperty<HPos> halignment;
    private ObjectProperty<VPos> valignment;
    private static final String DEFAULT_STYLE_CLASS = "separator";
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"horizontal");

    public Separator() {
        this(Orientation.HORIZONTAL);
    }

    public Separator(Orientation orientation) {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        ((StyleableProperty)this.focusTraversableProperty()).applyStyle(null, (Object)Boolean.FALSE);
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, orientation != Orientation.VERTICAL);
        this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, orientation == Orientation.VERTICAL);
        ((StyleableProperty)this.orientationProperty()).applyStyle(null, (Object)(orientation != null ? orientation : Orientation.HORIZONTAL));
    }

    public final void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public final Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public final void setHalignment(HPos hPos) {
        this.halignmentProperty().set((Object)hPos);
    }

    public final HPos getHalignment() {
        return this.halignment == null ? HPos.CENTER : (HPos)this.halignment.get();
    }

    public final ObjectProperty<HPos> halignmentProperty() {
        if (this.halignment == null) {
            this.halignment = new StyleableObjectProperty<HPos>(HPos.CENTER){

                public Object getBean() {
                    return Separator.this;
                }

                public String getName() {
                    return "halignment";
                }

                public CssMetaData<Separator, HPos> getCssMetaData() {
                    return StyleableProperties.HALIGNMENT;
                }
            };
        }
        return this.halignment;
    }

    public final void setValignment(VPos vPos) {
        this.valignmentProperty().set((Object)vPos);
    }

    public final VPos getValignment() {
        return this.valignment == null ? VPos.CENTER : (VPos)this.valignment.get();
    }

    public final ObjectProperty<VPos> valignmentProperty() {
        if (this.valignment == null) {
            this.valignment = new StyleableObjectProperty<VPos>(VPos.CENTER){

                public Object getBean() {
                    return Separator.this;
                }

                public String getName() {
                    return "valignment";
                }

                public CssMetaData<Separator, VPos> getCssMetaData() {
                    return StyleableProperties.VALIGNMENT;
                }
            };
        }
        return this.valignment;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new SeparatorSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Separator.getClassCssMetaData();
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }

    private static class StyleableProperties {
        private static final CssMetaData<Separator, Orientation> ORIENTATION = new CssMetaData<Separator, Orientation>("-fx-orientation", (StyleConverter)new EnumConverter(Orientation.class), Orientation.HORIZONTAL){

            public Orientation getInitialValue(Separator separator) {
                return separator.getOrientation();
            }

            public boolean isSettable(Separator separator) {
                return separator.orientation == null || !separator.orientation.isBound();
            }

            public StyleableProperty<Orientation> getStyleableProperty(Separator separator) {
                return (StyleableProperty)separator.orientationProperty();
            }
        };
        private static final CssMetaData<Separator, HPos> HALIGNMENT = new CssMetaData<Separator, HPos>("-fx-halignment", (StyleConverter)new EnumConverter(HPos.class), HPos.CENTER){

            public boolean isSettable(Separator separator) {
                return separator.halignment == null || !separator.halignment.isBound();
            }

            public StyleableProperty<HPos> getStyleableProperty(Separator separator) {
                return (StyleableProperty)separator.halignmentProperty();
            }
        };
        private static final CssMetaData<Separator, VPos> VALIGNMENT = new CssMetaData<Separator, VPos>("-fx-valignment", (StyleConverter)new EnumConverter(VPos.class), VPos.CENTER){

            public boolean isSettable(Separator separator) {
                return separator.valignment == null || !separator.valignment.isBound();
            }

            public StyleableProperty<VPos> getStyleableProperty(Separator separator) {
                return (StyleableProperty)separator.valignmentProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Control.getClassCssMetaData());
            arrayList.add(ORIENTATION);
            arrayList.add(HALIGNMENT);
            arrayList.add(VALIGNMENT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

