/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.TitledPaneBehavior;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TitledPane;
import javafx.scene.control.skin.LabeledSkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class TitledPaneSkin
extends LabeledSkinBase<TitledPane> {
    private static final Duration TRANSITION_DURATION = new Duration(350.0);
    private static final boolean CACHE_ANIMATION = PlatformUtil.isEmbedded();
    private final TitledPaneBehavior behavior;
    private final TitleRegion titleRegion;
    private final StackPane contentContainer;
    private Node content;
    private Timeline timeline;
    private double transitionStartValue;
    private Rectangle clipRect;
    private Pos pos;
    private DoubleProperty transition;
    private double prefHeightFromAccordion = 0.0;

    public TitledPaneSkin(TitledPane titledPane) {
        super(titledPane);
        this.behavior = new TitledPaneBehavior(titledPane);
        this.clipRect = new Rectangle();
        this.transitionStartValue = 0.0;
        this.titleRegion = new TitleRegion();
        this.content = ((TitledPane)this.getSkinnable()).getContent();
        this.contentContainer = new StackPane(){
            {
                this.getStyleClass().setAll((Object[])new String[]{"content"});
                if (TitledPaneSkin.this.content != null) {
                    this.getChildren().setAll((Object[])new Node[]{TitledPaneSkin.this.content});
                }
            }
        };
        this.contentContainer.setClip((Node)this.clipRect);
        this.updateClip();
        if (titledPane.isExpanded()) {
            this.setTransition(1.0);
            this.setExpanded(titledPane.isExpanded());
        } else {
            this.setTransition(0.0);
            if (this.content != null) {
                this.content.setVisible(false);
            }
        }
        this.getChildren().setAll((Object[])new Node[]{this.contentContainer, this.titleRegion});
        this.registerChangeListener((ObservableValue<?>)titledPane.contentProperty(), observableValue -> {
            this.content = ((TitledPane)this.getSkinnable()).getContent();
            if (this.content == null) {
                this.contentContainer.getChildren().clear();
            } else {
                this.contentContainer.getChildren().setAll((Object[])new Node[]{this.content});
            }
        });
        this.registerChangeListener((ObservableValue<?>)titledPane.expandedProperty(), observableValue -> this.setExpanded(((TitledPane)this.getSkinnable()).isExpanded()));
        this.registerChangeListener((ObservableValue<?>)titledPane.collapsibleProperty(), observableValue -> this.titleRegion.update());
        this.registerChangeListener((ObservableValue<?>)titledPane.alignmentProperty(), observableValue -> {
            this.pos = ((TitledPane)this.getSkinnable()).getAlignment();
        });
        this.registerChangeListener((ObservableValue<?>)titledPane.widthProperty(), observableValue -> this.updateClip());
        this.registerChangeListener((ObservableValue<?>)titledPane.heightProperty(), observableValue -> this.updateClip());
        this.registerChangeListener((ObservableValue<?>)this.titleRegion.alignmentProperty(), observableValue -> {
            this.pos = this.titleRegion.getAlignment();
        });
        this.pos = titledPane.getAlignment();
    }

    private final void setTransition(double d) {
        this.transitionProperty().set(d);
    }

    private final double getTransition() {
        return this.transition == null ? 0.0 : this.transition.get();
    }

    private final DoubleProperty transitionProperty() {
        if (this.transition == null) {
            this.transition = new SimpleDoubleProperty(this, "transition", 0.0){

                protected void invalidated() {
                    TitledPaneSkin.this.contentContainer.requestLayout();
                }
            };
        }
        return this.transition;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected void updateChildren() {
        if (this.titleRegion != null) {
            this.titleRegion.update();
        }
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        double d5 = this.snapSizeY(this.titleRegion.prefHeight(-1.0));
        this.titleRegion.resize(d3, d5);
        this.positionInArea((Node)this.titleRegion, d, d2, d3, d5, 0.0, HPos.LEFT, VPos.CENTER);
        this.titleRegion.requestLayout();
        double d6 = (d4 - d5) * this.getTransition();
        if (this.isInsideAccordion() && this.prefHeightFromAccordion != 0.0) {
            d6 = (this.prefHeightFromAccordion - d5) * this.getTransition();
        }
        d6 = this.snapSizeY(d6);
        this.contentContainer.resize(d3, d6);
        this.clipRect.setHeight(d6);
        this.positionInArea((Node)this.contentContainer, d, d2 += d5, d3, d6, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        double d6 = this.snapSizeX(this.titleRegion.prefWidth(d));
        double d7 = this.snapSizeX(this.contentContainer.minWidth(d));
        return Math.max(d6, d7) + d5 + d3;
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        double d6 = this.snapSizeY(this.titleRegion.prefHeight(d));
        double d7 = this.contentContainer.minHeight(d) * this.getTransition();
        return d6 + this.snapSizeY(d7) + d2 + d4;
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        double d6 = this.snapSizeX(this.titleRegion.prefWidth(d));
        double d7 = this.snapSizeX(this.contentContainer.prefWidth(d));
        return Math.max(d6, d7) + d5 + d3;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        double d6 = this.snapSizeY(this.titleRegion.prefHeight(d));
        double d7 = this.contentContainer.prefHeight(d) * this.getTransition();
        return d6 + this.snapSizeY(d7) + d2 + d4;
    }

    @Override
    protected double computeMaxWidth(double d, double d2, double d3, double d4, double d5) {
        return Double.MAX_VALUE;
    }

    private void updateClip() {
        this.clipRect.setWidth(((TitledPane)this.getSkinnable()).getWidth());
        this.clipRect.setHeight(this.contentContainer.getHeight());
    }

    private void setExpanded(boolean bl) {
        if (!((TitledPane)this.getSkinnable()).isCollapsible()) {
            this.setTransition(1.0);
            return;
        }
        if (Platform.isFxApplicationThread() && ((TitledPane)this.getSkinnable()).isAnimated()) {
            this.transitionStartValue = this.getTransition();
            this.doAnimationTransition();
        } else {
            if (bl) {
                this.setTransition(1.0);
            } else {
                this.setTransition(0.0);
            }
            if (this.content != null) {
                this.content.setVisible(bl);
            }
            ((TitledPane)this.getSkinnable()).requestLayout();
        }
    }

    private boolean isInsideAccordion() {
        return ((TitledPane)this.getSkinnable()).getParent() != null && ((TitledPane)this.getSkinnable()).getParent() instanceof Accordion;
    }

    double getTitleRegionSize(double d) {
        return this.snapSizeY(this.titleRegion.prefHeight(d)) + this.snappedTopInset() + this.snappedBottomInset();
    }

    void setMaxTitledPaneHeightForAccordion(double d) {
        this.prefHeightFromAccordion = d;
    }

    double getTitledPaneHeightForAccordion() {
        double d = this.snapSizeY(this.titleRegion.prefHeight(-1.0));
        double d2 = (this.prefHeightFromAccordion - d) * this.getTransition();
        return d + this.snapSizeY(d2) + this.snappedTopInset() + this.snappedBottomInset();
    }

    private void doAnimationTransition() {
        KeyFrame keyFrame;
        KeyFrame keyFrame2;
        Duration duration;
        if (this.content == null) {
            return;
        }
        if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
            duration = this.timeline.getCurrentTime();
            this.timeline.stop();
        } else {
            duration = TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (((TitledPane)this.getSkinnable()).isExpanded()) {
            keyFrame2 = new KeyFrame(Duration.ZERO, actionEvent -> {
                if (CACHE_ANIMATION) {
                    this.content.setCache(true);
                }
                this.content.setVisible(true);
            }, new KeyValue[]{new KeyValue((WritableValue)this.transitionProperty(), (Object)this.transitionStartValue)});
            keyFrame = new KeyFrame(duration, actionEvent -> {
                if (CACHE_ANIMATION) {
                    this.content.setCache(false);
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transitionProperty(), (Object)1, Interpolator.LINEAR)});
        } else {
            keyFrame2 = new KeyFrame(Duration.ZERO, actionEvent -> {
                if (CACHE_ANIMATION) {
                    this.content.setCache(true);
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transitionProperty(), (Object)this.transitionStartValue)});
            keyFrame = new KeyFrame(duration, actionEvent -> {
                this.content.setVisible(false);
                if (CACHE_ANIMATION) {
                    this.content.setCache(false);
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transitionProperty(), (Object)0, Interpolator.LINEAR)});
        }
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{keyFrame2, keyFrame});
        this.timeline.play();
    }

    @Override
    double leftLabelPadding() {
        return 0.0;
    }

    @Override
    double rightLabelPadding() {
        return 0.0;
    }

    @Override
    double topLabelPadding() {
        return 0.0;
    }

    @Override
    double bottomLabelPadding() {
        return 0.0;
    }

    class TitleRegion
    extends StackPane {
        private final StackPane arrowRegion;

        public TitleRegion() {
            this.getStyleClass().setAll((Object[])new String[]{"title"});
            this.arrowRegion = new StackPane();
            this.arrowRegion.setId("arrowRegion");
            this.arrowRegion.getStyleClass().setAll((Object[])new String[]{"arrow-button"});
            StackPane stackPane = new StackPane();
            stackPane.setId("arrow");
            stackPane.getStyleClass().setAll((Object[])new String[]{"arrow"});
            this.arrowRegion.getChildren().setAll((Object[])new Node[]{stackPane});
            stackPane.rotateProperty().bind((ObservableValue)new DoubleBinding(){
                {
                    this.bind(new Observable[]{TitledPaneSkin.this.transitionProperty()});
                }

                protected double computeValue() {
                    return -90.0 * (1.0 - TitledPaneSkin.this.getTransition());
                }
            });
            this.setAlignment(Pos.CENTER_LEFT);
            this.setOnMouseReleased(mouseEvent -> {
                if (mouseEvent.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                ContextMenu contextMenu = ((TitledPane)TitledPaneSkin.this.getSkinnable()).getContextMenu();
                if (contextMenu != null) {
                    contextMenu.hide();
                }
                if (((TitledPane)TitledPaneSkin.this.getSkinnable()).isCollapsible() && ((TitledPane)TitledPaneSkin.this.getSkinnable()).isFocused()) {
                    titledPaneSkin.behavior.toggle();
                }
            });
            this.update();
        }

        private void update() {
            this.getChildren().clear();
            TitledPane titledPane = (TitledPane)TitledPaneSkin.this.getSkinnable();
            if (titledPane.isCollapsible()) {
                this.getChildren().add((Object)this.arrowRegion);
            }
            if (TitledPaneSkin.this.graphic != null) {
                TitledPaneSkin.this.graphic.layoutBoundsProperty().removeListener(TitledPaneSkin.this.graphicPropertyChangedListener);
            }
            TitledPaneSkin.this.graphic = titledPane.getGraphic();
            if (TitledPaneSkin.this.isIgnoreGraphic()) {
                if (titledPane.getContentDisplay() == ContentDisplay.GRAPHIC_ONLY) {
                    this.getChildren().clear();
                    this.getChildren().add((Object)this.arrowRegion);
                } else {
                    this.getChildren().add((Object)TitledPaneSkin.this.text);
                }
            } else {
                TitledPaneSkin.this.graphic.layoutBoundsProperty().addListener(TitledPaneSkin.this.graphicPropertyChangedListener);
                if (TitledPaneSkin.this.isIgnoreText()) {
                    this.getChildren().add((Object)TitledPaneSkin.this.graphic);
                } else {
                    this.getChildren().addAll((Object[])new Node[]{TitledPaneSkin.this.graphic, TitledPaneSkin.this.text});
                }
            }
            this.setCursor(((TitledPane)TitledPaneSkin.this.getSkinnable()).isCollapsible() ? Cursor.HAND : Cursor.DEFAULT);
        }

        protected double computePrefWidth(double d) {
            double d2 = this.snappedLeftInset();
            double d3 = this.snappedRightInset();
            double d4 = 0.0;
            double d5 = TitledPaneSkin.super.computePrefWidth(d, 0.0, 0.0, 0.0, 0.0);
            if (this.arrowRegion != null) {
                d4 = this.snapSizeX(this.arrowRegion.prefWidth(d));
            }
            return d2 + d4 + d5 + d3;
        }

        protected double computePrefHeight(double d) {
            double d2 = this.snappedTopInset();
            double d3 = this.snappedBottomInset();
            double d4 = 0.0;
            double d5 = TitledPaneSkin.super.computePrefHeight(d, 0.0, 0.0, 0.0, 0.0);
            if (this.arrowRegion != null) {
                d4 = this.snapSizeY(this.arrowRegion.prefHeight(d));
            }
            return d2 + Math.max(d4, d5) + d3;
        }

        protected void layoutChildren() {
            double d = this.snappedTopInset();
            double d2 = this.snappedBottomInset();
            double d3 = this.snappedLeftInset();
            double d4 = this.snappedRightInset();
            double d5 = this.getWidth() - (d3 + d4);
            double d6 = this.getHeight() - (d + d2);
            double d7 = this.snapSizeX(this.arrowRegion.prefWidth(-1.0));
            double d8 = this.snapSizeY(this.arrowRegion.prefHeight(-1.0));
            double d9 = d3 + d7;
            double d10 = d;
            this.arrowRegion.resize(d7, d8);
            this.positionInArea((Node)this.arrowRegion, d3, d, d7, d6, 0.0, HPos.CENTER, VPos.CENTER);
            TitledPaneSkin.this.layoutLabelInArea(d9, d10, d5 - d7, d6, TitledPaneSkin.this.pos);
        }
    }
}

