/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.javafx.PlatformUtil;
import java.security.AccessController;

final class Platform {
    public static final String MAC = "Mac";
    public static final String WINDOWS = "Win";
    public static final String GTK = "Gtk";
    public static final String IOS = "Ios";
    public static final String UNKNOWN = "unknown";
    private static String type = null;

    Platform() {
    }

    public static synchronized String determinePlatform() {
        if (type == null) {
            String string = AccessController.doPrivileged(() -> System.getProperty("glass.platform"));
            if (string != null) {
                type = string.equals("macosx") ? MAC : (string.equals("windows") ? WINDOWS : (string.equals("linux") ? GTK : (string.equals("gtk") ? GTK : (string.equals("ios") ? IOS : string))));
                return type;
            }
            if (PlatformUtil.isMac()) {
                type = MAC;
            } else if (PlatformUtil.isWindows()) {
                type = WINDOWS;
            } else if (PlatformUtil.isLinux()) {
                type = GTK;
            } else if (PlatformUtil.isIOS()) {
                type = IOS;
            }
        }
        return type;
    }
}

