/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import java.util.Objects;
import javafx.animation.Interpolator;

public final class StepInterpolator
extends Interpolator {
    private final int intervalCount;
    private final Interpolator.StepPosition position;

    public StepInterpolator(int n, Interpolator.StepPosition stepPosition) {
        if (stepPosition == Interpolator.StepPosition.NONE && n <= 1) {
            throw new IllegalArgumentException("intervalCount must be greater than 1");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("intervalCount must be greater than 0");
        }
        this.position = Objects.requireNonNull(stepPosition, "position cannot be null");
        this.intervalCount = n;
    }

    @Override
    protected double curve(double d) {
        int n;
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        int n2 = (int)(d * (double)this.intervalCount);
        if (this.position == Interpolator.StepPosition.START || this.position == Interpolator.StepPosition.BOTH) {
            ++n2;
        }
        if (bl && d * (double)this.intervalCount % 1.0 == 0.0) {
            --n2;
        }
        if (d >= 0.0 && n2 < 0) {
            n2 = 0;
        }
        switch (this.position) {
            default: {
                throw new MatchException(null, null);
            }
            case START: 
            case END: {
                int n3 = this.intervalCount;
                break;
            }
            case NONE: {
                int n3 = this.intervalCount - 1;
                break;
            }
            case BOTH: {
                int n3 = n = this.intervalCount + 1;
            }
        }
        if (d <= 1.0 && n2 > n) {
            n2 = n;
        }
        return (double)n2 / (double)n;
    }

    public int hashCode() {
        return Integer.hashCode(this.intervalCount) + 31 * this.position.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof StepInterpolator)) return false;
        StepInterpolator stepInterpolator = (StepInterpolator)object;
        if (this.intervalCount != stepInterpolator.intervalCount) return false;
        if (this.position != stepInterpolator.position) return false;
        return true;
    }

    public String toString() {
        return "StepInterpolator [intervalCount=" + this.intervalCount + ", position=" + String.valueOf((Object)this.position) + "]";
    }
}

