/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableDoubleProperty
extends DoublePropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableDoubleProperty() {
    }

    public StyleableDoubleProperty(double d) {
        super(d);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        double d;
        TransitionDefinition transitionDefinition;
        Object object;
        if (this.origin != null && (object = this.getBean()) instanceof Node) {
            Node node = (Node)object;
            transitionDefinition = NodeHelper.findTransitionDefinition(node, this.getCssMetaData());
        } else {
            transitionDefinition = null;
        }
        TransitionDefinition transitionDefinition2 = transitionDefinition;
        double d2 = d = number != null ? number.doubleValue() : 0.0;
        if (transitionDefinition2 == null) {
            this.set(d);
        } else if (this.mediator == null || this.mediator.endValue != d) {
            this.mediator = new TransitionMediatorImpl(this.get(), d);
            this.mediator.run(transitionDefinition2, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    public void set(double d) {
        super.set(d);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private class TransitionMediatorImpl
    extends TransitionMediator {
        private final double startValue;
        private final double endValue;
        private double reversingAdjustedStartValue;

        public TransitionMediatorImpl(double d, double d2) {
            this.startValue = d;
            this.endValue = d2;
            this.reversingAdjustedStartValue = d;
        }

        @Override
        public void onUpdate(double d) {
            StyleableDoubleProperty.super.set(d < 1.0 ? this.startValue + (this.endValue - this.startValue) * d : this.endValue);
        }

        @Override
        public void onStop() {
            StyleableDoubleProperty.this.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableDoubleProperty.this;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (transitionMediatorImpl.reversingAdjustedStartValue == this.endValue) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

