/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLine;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import javafx.geometry.Rectangle2D;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.TextLineInfo;

public final class TextUtils {
    public static PathElement[] getRange(TextLayout textLayout, int n, int n2, int n3, double d, double d2) {
        ArrayList arrayList = new ArrayList();
        textLayout.getRange(n, n2, n3, (f, f2, f3, f4) -> {
            double d3 = (double)f + d;
            double d4 = (double)f3 + d;
            double d5 = (double)f2 + d2;
            double d6 = (double)f4 + d2;
            arrayList.add(new MoveTo(d3, d5));
            arrayList.add(new LineTo(d4, d5));
            arrayList.add(new LineTo(d4, d6));
            arrayList.add(new LineTo(d3, d6));
            arrayList.add(new LineTo(d3, d5));
        });
        return (PathElement[])arrayList.toArray(PathElement[]::new);
    }

    public static TextLineInfo toLineInfo(TextLine textLine, double d, double d2, double d3) {
        int n = textLine.getStart();
        int n2 = textLine.getStart() + textLine.getLength();
        int n3 = 0;
        Object object = textLine.getRuns();
        int n4 = ((GlyphList[])object).length;
        if (n3 < n4) {
            GlyphList glyphList = object[n3];
            Point2D point2D = glyphList.getLocation();
            d += (double)point2D.x;
            d2 += (double)point2D.y;
        }
        object = TextUtils.toRectangle2D(textLine.getBounds(), d, d2, d3);
        return new TextLineInfo(n, n2, (Rectangle2D)object);
    }

    public static Rectangle2D toRectangle2D(BaseBounds baseBounds, double d, double d2, double d3) {
        double d4 = Math.abs(baseBounds.getWidth());
        return new Rectangle2D((double)baseBounds.getMinX() + d, d2, d4, (double)baseBounds.getHeight() + d3);
    }

    public static PathElement[] getCaretPathElements(TextLayout.CaretGeometry caretGeometry, double d, double d2) {
        TextLayout.CaretGeometry caretGeometry2 = caretGeometry;
        Objects.requireNonNull(caretGeometry2);
        TextLayout.CaretGeometry caretGeometry3 = caretGeometry2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextLayout.CaretGeometry.Single.class, TextLayout.CaretGeometry.Split.class}, (TextLayout.CaretGeometry)caretGeometry3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                TextLayout.CaretGeometry.Single single = (TextLayout.CaretGeometry.Single)caretGeometry3;
                double d3 = (double)single.x() + d;
                double d4 = (double)single.y() + d2;
                return new PathElement[]{new MoveTo(d3, d4), new LineTo(d3, d4 + (double)single.height())};
            }
            case 1: 
        }
        TextLayout.CaretGeometry.Split split = (TextLayout.CaretGeometry.Split)caretGeometry3;
        double d5 = (double)split.x1() + d;
        double d6 = (double)split.x2() + d;
        double d7 = (double)split.y() + d2;
        double d8 = d7 + (double)split.height() / 2.0;
        return new PathElement[]{new MoveTo(d5, d7), new LineTo(d5, d8), new MoveTo(d6, d8), new LineTo(d6, d7 + (double)split.height())};
    }

    public static Rectangle2D[] getCaretRectangles(TextLayout.CaretGeometry caretGeometry, double d, double d2) {
        TextLayout.CaretGeometry caretGeometry2 = caretGeometry;
        Objects.requireNonNull(caretGeometry2);
        TextLayout.CaretGeometry caretGeometry3 = caretGeometry2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextLayout.CaretGeometry.Single.class, TextLayout.CaretGeometry.Split.class}, (TextLayout.CaretGeometry)caretGeometry3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                TextLayout.CaretGeometry.Single single = (TextLayout.CaretGeometry.Single)caretGeometry3;
                return new Rectangle2D[]{new Rectangle2D((double)single.x() + d, (double)single.y() + d2, 0.0, single.height())};
            }
            case 1: 
        }
        TextLayout.CaretGeometry.Split split = (TextLayout.CaretGeometry.Split)caretGeometry3;
        double d3 = (double)split.x1() + d;
        double d4 = (double)split.x2() + d;
        double d5 = (double)split.y() + d2;
        double d6 = (double)split.height() / 2.0;
        return new Rectangle2D[]{new Rectangle2D(d3, d5, 0.0, d6), new Rectangle2D(d4, d5 + d6, 0.0, d6)};
    }
}

