/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk.screencast;

import com.sun.glass.ui.Screen;
import com.sun.glass.ui.gtk.screencast.TokenItem;
import com.sun.glass.ui.gtk.screencast.TokenStorage;
import com.sun.glass.ui.gtk.screencast.XdgDesktopPortal;
import com.sun.javafx.geom.Rectangle;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import java.util.stream.IntStream;

public final class ScreencastHelper {
    static final boolean SCREENCAST_DEBUG;
    private static final boolean IS_NATIVE_LOADED;
    private static final int ERROR = -1;
    private static final int DENIED = -11;
    private static final int OUT_OF_BOUNDS = -12;
    private static final int NO_STREAMS = -13;
    private static final int XDG_METHOD_SCREENCAST = 0;
    private static final int XDG_METHOD_REMOTE_DESKTOP = 1;
    private static final int DELAY_BEFORE_SESSION_CLOSE = 2000;
    private static volatile TimerTask timerTask;
    private static final Timer timerCloseSession;

    private ScreencastHelper() {
    }

    public static boolean isAvailable() {
        return IS_NATIVE_LOADED;
    }

    private static native boolean loadPipewire(int var0, boolean var1);

    private static native int getRGBPixelsImpl(int var0, int var1, int var2, int var3, int[] var4, int[] var5, String var6);

    public static int clipRound(double d) {
        double d2 = d - 0.5;
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.ceil(d2);
    }

    private static List<Rectangle> getSystemScreensBounds() {
        return Screen.getScreens().stream().map(screen -> new Rectangle(ScreencastHelper.clipRound((float)screen.getPlatformX() * screen.getPlatformScaleX()), ScreencastHelper.clipRound((float)screen.getPlatformY() * screen.getPlatformScaleY()), ScreencastHelper.clipRound((float)screen.getPlatformWidth() * screen.getPlatformScaleX()), ScreencastHelper.clipRound((float)screen.getPlatformHeight() * screen.getPlatformScaleY()))).toList();
    }

    private static synchronized native void closeSession();

    private static void timerCloseSessionRestart() {
        if (timerTask != null) {
            timerTask.cancel();
        }
        timerTask = new TimerTask(){

            @Override
            public void run() {
                ScreencastHelper.closeSession();
            }
        };
        timerCloseSession.schedule(timerTask, 2000L);
    }

    public static synchronized void getRGBPixels(int n, int n2, int n3, int n4, int[] nArray) {
        int n5;
        if (!IS_NATIVE_LOADED) {
            return;
        }
        ScreencastHelper.timerCloseSessionRestart();
        Rectangle rectangle3 = new Rectangle(n, n2, n3, n4);
        List<Rectangle> list = ScreencastHelper.getSystemScreensBounds().stream().filter(rectangle2 -> !rectangle3.intersection((Rectangle)rectangle2).isEmpty()).toList();
        if (SCREENCAST_DEBUG) {
            System.out.printf("// getRGBPixels in %s, affectedScreenBounds %s\n", rectangle3, list);
        }
        if (list.isEmpty()) {
            if (SCREENCAST_DEBUG) {
                System.out.println("// getRGBPixels - requested area outside of any screen");
            }
            return;
        }
        Set<TokenItem> set = TokenStorage.getTokens(list);
        int[] nArray2 = list.stream().filter(rectangle2 -> !rectangle3.intersection((Rectangle)rectangle2).isEmpty()).flatMapToInt(rectangle -> IntStream.of(rectangle.x, rectangle.y, rectangle.width, rectangle.height)).toArray();
        for (TokenItem tokenItem : set) {
            n5 = ScreencastHelper.getRGBPixelsImpl(n, n2, n3, n4, nArray, nArray2, tokenItem.token);
            ScreencastHelper.debugReturnValue(n5);
            if (n5 < 0 && n5 != -1 && n5 != -11) continue;
            return;
        }
        n5 = ScreencastHelper.getRGBPixelsImpl(n, n2, n3, n4, nArray, nArray2, null);
        ScreencastHelper.debugReturnValue(n5);
    }

    private static boolean debugReturnValue(int n) {
        if (n == -11) {
            if (SCREENCAST_DEBUG) {
                System.err.println("robot action: access denied by user.");
            }
        } else if (n == -1) {
            if (SCREENCAST_DEBUG) {
                System.err.println("robot action: failed.");
            }
        } else if (n == -12) {
            if (SCREENCAST_DEBUG) {
                System.err.println("Token does not provide access to requested area.");
            }
        } else if (n == -13 && SCREENCAST_DEBUG) {
            System.err.println("robot action: no streams available");
        }
        return n != -1;
    }

    private static void performWithToken(Function<String, Integer> function) {
        if (!XdgDesktopPortal.isRemoteDesktop() || !IS_NATIVE_LOADED) {
            return;
        }
        ScreencastHelper.timerCloseSessionRestart();
        for (TokenItem tokenItem : TokenStorage.getTokens(ScreencastHelper.getSystemScreensBounds())) {
            int n = function.apply(tokenItem.token);
            if (n < 0 && ScreencastHelper.debugReturnValue(n)) continue;
            return;
        }
        ScreencastHelper.debugReturnValue(function.apply(null));
    }

    public static synchronized void remoteDesktopMouseMove(int n, int n2) {
        ScreencastHelper.performWithToken(string -> ScreencastHelper.remoteDesktopMouseMoveImpl(n, n2, string));
    }

    public static synchronized void remoteDesktopMouseButton(boolean bl, int n) {
        ScreencastHelper.performWithToken(string -> ScreencastHelper.remoteDesktopMouseButtonImpl(bl, n, string));
    }

    public static synchronized void remoteDesktopMouseWheel(int n) {
        ScreencastHelper.performWithToken(string -> ScreencastHelper.remoteDesktopMouseWheelImpl(n, string));
    }

    public static synchronized void remoteDesktopKey(boolean bl, int n) {
        ScreencastHelper.performWithToken(string -> ScreencastHelper.remoteDesktopKeyImpl(bl, n, string));
    }

    private static synchronized native int remoteDesktopMouseMoveImpl(int var0, int var1, String var2);

    private static synchronized native int remoteDesktopMouseButtonImpl(boolean var0, int var1, String var2);

    private static synchronized native int remoteDesktopMouseWheelImpl(int var0, String var1);

    private static synchronized native int remoteDesktopKeyImpl(boolean var0, int var1, String var2);

    static {
        int n;
        timerTask = null;
        timerCloseSession = new Timer("auto-close screencast session", true);
        SCREENCAST_DEBUG = Boolean.getBoolean("javafx.robot.screenshotDebug");
        boolean bl = false;
        boolean bl2 = XdgDesktopPortal.isRemoteDesktop() || XdgDesktopPortal.isScreencast();
        int n2 = n = XdgDesktopPortal.isScreencast() ? 0 : 1;
        if (!bl2 || !ScreencastHelper.loadPipewire(n, SCREENCAST_DEBUG)) {
            System.err.println("Could not load native libraries for ScreencastHelper");
            bl = true;
        }
        IS_NATIVE_LOADED = !bl;
    }
}

