/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ModuleNameSource;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.openjfx.Compile;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JavaFXRunMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private LocationManager locationManager;
    @Parameter(property="javafx.mainClass", required=true)
    private String mainClass;
    @Parameter(property="javafx.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="javafx.executable", defaultValue="java")
    private String executable;
    @Parameter(readonly=true, required=true, defaultValue="${basedir}")
    private File basedir;
    @Parameter(property="javafx.workingdir")
    private File workingDirectory;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Parameter(property="javafx.outputFile")
    private File outputFile;
    @Parameter(property="javafx.async", defaultValue="false")
    private boolean async;
    @Parameter(property="exec.asyncDestroyOnShutdown", defaultValue="true")
    private boolean asyncDestroyOnShutdown = true;
    @Parameter
    private List<?> options;
    @Parameter(property="javafx.args")
    private String commandlineArgs;
    private List<String> classpathElements;
    private List<String> modulepathElements;
    private Map<String, JavaModuleDescriptor> pathElements;
    private JavaModuleDescriptor moduleDescriptor;
    private ProcessDestroyer processDestroyer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping execute as per configuration");
            return;
        }
        if (this.executable == null) {
            throw new MojoExecutionException("The parameter 'executable' is missing or invalid");
        }
        if (this.basedir == null) {
            throw new IllegalStateException("basedir is null. Should not be possible.");
        }
        try {
            this.handleWorkingDirectory();
            ArrayList<String> commandArguments = new ArrayList<String>();
            this.handleArguments(commandArguments);
            Map<String, String> enviro = this.handleSystemEnvVariables();
            CommandLine commandLine = this.getExecutablePath(enviro, this.workingDirectory);
            String[] args = commandArguments.toArray(new String[commandArguments.size()]);
            commandLine.addArguments(args, false);
            this.getLog().debug((CharSequence)("Executing command line: " + commandLine));
            DefaultExecutor exec = new DefaultExecutor();
            exec.setWorkingDirectory(this.workingDirectory);
            try {
                int resultCode;
                block14: {
                    block13: {
                        if (this.outputFile == null) break block13;
                        if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
                            this.getLog().warn((CharSequence)("Could not create non existing parent directories for log file: " + this.outputFile));
                        }
                        FileOutputStream outputStream = null;
                        try {
                            outputStream = new FileOutputStream(this.outputFile);
                            resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, outputStream);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(outputStream);
                            throw throwable;
                        }
                        IOUtil.close((OutputStream)outputStream);
                        break block14;
                    }
                    resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, System.out, System.err);
                }
                if (resultCode != 0) {
                    String message = "Result of " + commandLine.toString() + " execution is: '" + resultCode + "'.";
                    this.getLog().error((CharSequence)message);
                    throw new MojoExecutionException(message);
                }
            }
            catch (ExecuteException e) {
                this.getLog().error((CharSequence)"Command execution failed.", (Throwable)e);
                e.printStackTrace();
                throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Command execution failed.", (Throwable)e);
                throw new MojoExecutionException("Command execution failed.", (Exception)e);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private void handleWorkingDirectory() throws MojoExecutionException {
        if (this.workingDirectory == null) {
            this.workingDirectory = this.basedir;
        }
        if (!this.workingDirectory.exists()) {
            this.getLog().debug((CharSequence)("Making working directory '" + this.workingDirectory.getAbsolutePath() + "'."));
            if (!this.workingDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not make working directory: '" + this.workingDirectory.getAbsolutePath() + "'");
            }
        }
    }

    private Map<String, String> handleSystemEnvVariables() throws MojoExecutionException {
        HashMap<String, String> enviro = new HashMap<String, String>();
        try {
            Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
            for (Map.Entry<Object, Object> entry : systemEnvVars.entrySet()) {
                enviro.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException x) {
            this.getLog().error((CharSequence)"Could not assign default system enviroment variables.", (Throwable)x);
        }
        return enviro;
    }

    private CommandLine getExecutablePath(Map<String, String> enviro, File dir) {
        CommandLine toRet;
        File execFile = new File(this.executable);
        String exec = null;
        if (execFile.isFile()) {
            this.getLog().debug((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.executable));
            exec = execFile.getAbsolutePath();
        }
        if (exec == null && OS.isFamilyWindows()) {
            List<String> paths = this.getExecutablePaths(enviro);
            paths.add(0, dir.getAbsolutePath());
            exec = JavaFXRunMojo.findExecutable(this.executable, paths);
        }
        if (exec == null) {
            exec = this.executable;
        }
        if (OS.isFamilyWindows() && !JavaFXRunMojo.hasNativeExtension(exec) && JavaFXRunMojo.hasExecutableExtension(exec)) {
            String comSpec = System.getenv("ComSpec");
            toRet = new CommandLine(comSpec == null ? "cmd" : comSpec);
            toRet.addArgument("/c");
            toRet.addArgument(exec);
        } else {
            toRet = new CommandLine(exec);
        }
        return toRet;
    }

    private void handleArguments(List<String> commandArguments) throws MojoExecutionException, MojoFailureException {
        this.preparePaths();
        if (this.options != null) {
            this.options.stream().filter(Objects::nonNull).filter(String.class::isInstance).map(String.class::cast).forEach(commandArguments::add);
        }
        if (this.modulepathElements != null && !this.modulepathElements.isEmpty()) {
            commandArguments.add(" --module-path");
            String modulePath = StringUtils.join(this.modulepathElements.iterator(), (String)File.pathSeparator);
            commandArguments.add(modulePath);
            commandArguments.add(" --add-modules");
            if (this.moduleDescriptor != null) {
                commandArguments.add(" " + this.moduleDescriptor.name());
            } else {
                String modules = this.pathElements.values().stream().filter(Objects::nonNull).map(JavaModuleDescriptor::name).filter(Objects::nonNull).filter(module -> !module.endsWith("Empty")).collect(Collectors.joining(","));
                commandArguments.add(" " + modules);
            }
        }
        if (this.classpathElements != null && !this.classpathElements.isEmpty()) {
            commandArguments.add(" -classpath");
            Object classpath = "";
            if (this.moduleDescriptor != null) {
                classpath = this.project.getBuild().getOutputDirectory() + File.pathSeparator;
            }
            classpath = (String)classpath + StringUtils.join(this.classpathElements.iterator(), (String)File.pathSeparator);
            commandArguments.add((String)classpath);
        }
        if (this.mainClass != null) {
            if (this.moduleDescriptor != null) {
                commandArguments.add(" --module");
                if (!this.mainClass.startsWith(this.moduleDescriptor.name() + "/")) {
                    commandArguments.add(" " + this.moduleDescriptor.name() + "/" + this.mainClass);
                } else {
                    commandArguments.add(" " + this.mainClass);
                }
            } else {
                commandArguments.add(" " + this.mainClass);
            }
        }
        if (this.commandlineArgs != null) {
            commandArguments.add(this.commandlineArgs);
        }
    }

    private void preparePaths() throws MojoExecutionException, MojoFailureException {
        if (this.project == null) {
            return;
        }
        String outputDirectory = this.project.getBuild().getOutputDirectory();
        if (outputDirectory == null || outputDirectory.isEmpty()) {
            throw new MojoExecutionException("Output directory doesn't exist, compile first");
        }
        File[] classes = new File(outputDirectory).listFiles();
        if (classes == null || classes.length == 0) {
            this.getLog().debug((CharSequence)"Output directory was empty, compiling...");
            this.compile();
            classes = new File(outputDirectory).listFiles();
            if (classes == null || classes.length == 0) {
                throw new MojoExecutionException("Output directory is empty, compile first");
            }
        }
        File moduleDescriptorPath = Stream.of(classes).filter(file -> "module-info.class".equals(file.getName())).findFirst().orElse(null);
        this.modulepathElements = new ArrayList<String>(this.compilePath.size());
        this.classpathElements = new ArrayList<String>(this.compilePath.size());
        this.pathElements = new LinkedHashMap<String, JavaModuleDescriptor>(this.compilePath.size());
        try {
            List<File> dependencyArtifacts = this.getCompileClasspathElements(this.project);
            this.getLog().debug((CharSequence)("Total dependencyArtifacts: " + dependencyArtifacts.size()));
            ResolvePathsRequest fileResolvePathsRequest = ResolvePathsRequest.ofFiles(dependencyArtifacts);
            if (moduleDescriptorPath != null) {
                this.getLog().debug((CharSequence)("module descriptor: " + moduleDescriptorPath));
                fileResolvePathsRequest = fileResolvePathsRequest.setMainModuleDescriptor((Object)moduleDescriptorPath);
            }
            ResolvePathsResult resolvePathsResult = this.locationManager.resolvePaths(fileResolvePathsRequest);
            for (Map.Entry pathException : resolvePathsResult.getPathExceptions().entrySet()) {
                Throwable cause = (Throwable)pathException.getValue();
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                String fileName = ((File)pathException.getKey()).getName();
                this.getLog().warn((CharSequence)("Can't extract module name from " + fileName + ": " + cause.getMessage()));
            }
            if (moduleDescriptorPath != null) {
                this.moduleDescriptor = resolvePathsResult.getMainModuleDescriptor();
            }
            for (Map.Entry entry2 : resolvePathsResult.getModulepathElements().entrySet()) {
                if (!ModuleNameSource.FILENAME.equals(entry2.getValue())) continue;
                String message = "Required filename-based automodules detected. Please don't publish this project to a public artifact repository!";
                if (this.moduleDescriptor != null && this.moduleDescriptor.exports().isEmpty()) {
                    this.getLog().info((CharSequence)"Required filename-based automodules detected. Please don't publish this project to a public artifact repository!");
                    break;
                }
                this.getLog().warn((CharSequence)"Required filename-based automodules detected. Please don't publish this project to a public artifact repository!");
                break;
            }
            this.getLog().debug((CharSequence)("pathElements: " + resolvePathsResult.getPathElements().size()));
            resolvePathsResult.getPathElements().entrySet().forEach(entry -> this.pathElements.put(((File)entry.getKey()).getPath(), (JavaModuleDescriptor)entry.getValue()));
            this.getLog().debug((CharSequence)("classpathElements: " + resolvePathsResult.getClasspathElements().size()));
            resolvePathsResult.getClasspathElements().forEach(file -> this.classpathElements.add(file.getPath()));
            this.getLog().debug((CharSequence)("modulepathElements: " + resolvePathsResult.getModulepathElements().size()));
            resolvePathsResult.getModulepathElements().keySet().forEach(file -> this.modulepathElements.add(file.getPath()));
            if (moduleDescriptorPath == null) {
                this.pathElements.forEach((k, v) -> {
                    if (v != null && v.name() != null) {
                        this.modulepathElements.add((String)k);
                    } else {
                        this.classpathElements.add((String)k);
                    }
                });
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)e.getMessage());
        }
        this.getLog().debug((CharSequence)("Classpath:" + this.classpathElements.size()));
        this.classpathElements.forEach(s -> this.getLog().debug((CharSequence)(" " + s)));
        this.getLog().debug((CharSequence)("Modulepath: " + this.modulepathElements.size()));
        this.modulepathElements.forEach(s -> this.getLog().debug((CharSequence)(" " + s)));
        this.getLog().debug((CharSequence)("pathElements: " + this.pathElements.size()));
        this.pathElements.forEach((k, v) -> this.getLog().debug((CharSequence)(" " + k + " :: " + (v != null && v.name() != null ? v.name() : v))));
    }

    private List<File> getCompileClasspathElements(MavenProject project) {
        List<File> list = project.getArtifacts().stream().sorted((a1, a2) -> {
            int compare = a1.compareTo(a2);
            if (compare == 0) {
                return a1.hasClassifier() ? 1 : (a2.hasClassifier() ? -1 : 0);
            }
            return compare;
        }).map(Artifact::getFile).collect(Collectors.toList());
        list.add(0, new File(project.getBuild().getOutputDirectory()));
        return list;
    }

    static String findExecutable(String executable, List<String> paths) {
        File f = null;
        block0: for (String path : paths) {
            f = new File(path, executable);
            if (!OS.isFamilyWindows() && f.isFile()) break;
            for (String extension : JavaFXRunMojo.getExecutableExtensions()) {
                f = new File(path, executable + extension);
                if (!f.isFile()) continue;
                break block0;
            }
        }
        if (f == null || !f.exists()) {
            return null;
        }
        return f.getAbsolutePath();
    }

    private static boolean hasNativeExtension(String exec) {
        String lowerCase = exec.toLowerCase();
        return lowerCase.endsWith(".exe") || lowerCase.endsWith(".com");
    }

    private static boolean hasExecutableExtension(String exec) {
        String lowerCase = exec.toLowerCase();
        for (String ext : JavaFXRunMojo.getExecutableExtensions()) {
            if (!lowerCase.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getExecutableExtensions() {
        String pathExt = System.getenv("PATHEXT");
        return pathExt == null ? Arrays.asList(".bat", ".cmd") : Arrays.asList(StringUtils.split((String)pathExt.toLowerCase(), (String)File.pathSeparator));
    }

    private List<String> getExecutablePaths(Map<String, String> enviro) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("");
        String path = enviro.get("PATH");
        if (path != null) {
            paths.addAll(Arrays.asList(StringUtils.split((String)path, (String)File.pathSeparator)));
        }
        return paths;
    }

    protected int executeCommandLine(Executor exec, CommandLine commandLine, Map<String, String> enviro, OutputStream out, OutputStream err) throws ExecuteException, IOException {
        PumpStreamHandler psh = new PumpStreamHandler(out, err, System.in);
        return this.executeCommandLine(exec, commandLine, enviro, psh);
    }

    private int executeCommandLine(Executor exec, CommandLine commandLine, Map<String, String> enviro, FileOutputStream outputFile) throws ExecuteException, IOException {
        BufferedOutputStream bos = new BufferedOutputStream(outputFile);
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)bos);
        return this.executeCommandLine(exec, commandLine, enviro, psh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommandLine(Executor exec, final CommandLine commandLine, Map<String, String> enviro, final PumpStreamHandler psh) throws ExecuteException, IOException {
        int result;
        exec.setStreamHandler((ExecuteStreamHandler)psh);
        try {
            psh.start();
            if (this.async) {
                if (this.asyncDestroyOnShutdown) {
                    exec.setProcessDestroyer(this.getProcessDestroyer());
                }
                exec.execute(commandLine, enviro, new ExecuteResultHandler(){

                    public void onProcessFailed(ExecuteException e) {
                        JavaFXRunMojo.this.getLog().error((CharSequence)("Async process failed for: " + commandLine), (Throwable)e);
                    }

                    public void onProcessComplete(int exitValue) {
                        JavaFXRunMojo.this.getLog().debug((CharSequence)("Async process complete, exit value = " + exitValue + " for: " + commandLine));
                        try {
                            psh.stop();
                        }
                        catch (IOException e) {
                            JavaFXRunMojo.this.getLog().error((CharSequence)("Error stopping async process stream handler for: " + commandLine), (Throwable)e);
                        }
                    }
                });
                result = 0;
            } else {
                result = exec.execute(commandLine, enviro);
            }
        }
        finally {
            if (!this.async) {
                psh.stop();
            }
        }
        return result;
    }

    private ProcessDestroyer getProcessDestroyer() {
        if (this.processDestroyer == null) {
            this.processDestroyer = new ShutdownHookProcessDestroyer();
        }
        return this.processDestroyer;
    }

    private void compile() throws MojoExecutionException {
        Compile.compile(this.project, this.session, this.pluginManager);
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    void setCommandlineArgs(String commandlineArgs) {
        this.commandlineArgs = commandlineArgs;
    }
}

