/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ModuleNameSource;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.openjfx.model.RuntimePathOption;

abstract class JavaFXBaseMojo
extends AbstractMojo {
    private static final String JAVAFX_APPLICATION_CLASS_NAME = "javafx.application.Application";
    static final String JAVAFX_PREFIX = "javafx";
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private LocationManager locationManager;
    @Parameter(property="javafx.mainClass", required=true)
    String mainClass;
    @Parameter(property="javafx.skip", defaultValue="false")
    boolean skip;
    @Parameter(readonly=true, required=true, defaultValue="${basedir}")
    File basedir;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.directory}")
    File builddir;
    @Parameter(property="javafx.runtimePathOption")
    RuntimePathOption runtimePathOption;
    @Parameter(property="javafx.workingDirectory")
    File workingDirectory;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Parameter(property="javafx.outputFile")
    File outputFile;
    @Parameter(property="javafx.async", defaultValue="false")
    private boolean async;
    @Parameter(property="javafx.asyncDestroyOnShutdown", defaultValue="true")
    private boolean asyncDestroyOnShutdown;
    @Parameter
    List<?> options;
    @Parameter(property="javafx.args")
    String commandlineArgs;
    @Parameter(property="javafx.source", defaultValue="11")
    private String source;
    @Parameter(property="javafx.target", defaultValue="11")
    private String target;
    @Parameter(property="javafx.release", defaultValue="11")
    private String release;
    @Parameter(property="javafx.includePathExceptionsInClasspath", defaultValue="false")
    private boolean includePathExceptionsInClasspath;
    List<String> classpathElements;
    List<String> modulepathElements;
    Map<String, JavaModuleDescriptor> pathElements;
    JavaModuleDescriptor moduleDescriptor;
    private ProcessDestroyer processDestroyer;

    JavaFXBaseMojo() {
    }

    static boolean isMavenUsingJava8() {
        return System.getProperty("java.version").startsWith("1.8");
    }

    static boolean isTargetUsingJava8(CommandLine commandLine) {
        String java = commandLine.getExecutable();
        return java != null && Files.exists(Paths.get(java, new String[0]).resolve("../../jre/lib/rt.jar").normalize(), new LinkOption[0]);
    }

    void preparePaths(Path jdkHome) throws MojoExecutionException {
        if (this.project == null) {
            return;
        }
        String outputDirectory = this.project.getBuild().getOutputDirectory();
        if (outputDirectory == null || outputDirectory.isEmpty()) {
            throw new MojoExecutionException("Error: Output directory doesn't exist");
        }
        File[] classes = new File(outputDirectory).listFiles();
        if (classes == null || classes.length == 0) {
            throw new MojoExecutionException("Error: Output directory is empty");
        }
        File moduleDescriptorPath = Stream.of(classes).filter(file -> "module-info.class".equals(file.getName())).findFirst().orElse(null);
        this.modulepathElements = new ArrayList<String>(this.compilePath.size());
        this.classpathElements = new ArrayList<String>(this.compilePath.size());
        this.pathElements = new LinkedHashMap<String, JavaModuleDescriptor>(this.compilePath.size());
        try {
            List<File> dependencyArtifacts = this.getCompileClasspathElements(this.project);
            this.getLog().debug((CharSequence)("Total dependencyArtifacts: " + dependencyArtifacts.size()));
            ResolvePathsRequest fileResolvePathsRequest = ResolvePathsRequest.ofFiles(dependencyArtifacts);
            this.getLog().debug((CharSequence)("module descriptor path: " + moduleDescriptorPath));
            if (moduleDescriptorPath != null) {
                fileResolvePathsRequest.setMainModuleDescriptor((Object)moduleDescriptorPath);
            }
            if (jdkHome != null) {
                fileResolvePathsRequest.setJdkHome((Object)jdkHome.toFile());
            }
            ResolvePathsResult resolvePathsResult = this.locationManager.resolvePaths(fileResolvePathsRequest);
            resolvePathsResult.getPathElements().forEach((key, value) -> this.pathElements.put(key.getPath(), (JavaModuleDescriptor)value));
            if (this.runtimePathOption == RuntimePathOption.MODULEPATH && moduleDescriptorPath == null) {
                throw new MojoExecutionException("module-info.java file is required for MODULEPATH runtimePathOption");
            }
            if (moduleDescriptorPath != null) {
                if (!resolvePathsResult.getPathExceptions().isEmpty() && !JavaFXBaseMojo.isMavenUsingJava8()) {
                    for (Map.Entry pathException : resolvePathsResult.getPathExceptions().entrySet()) {
                        Throwable cause = (Throwable)pathException.getValue();
                        while (cause.getCause() != null) {
                            cause = cause.getCause();
                        }
                        String fileName = ((File)pathException.getKey()).getName();
                        this.getLog().warn((CharSequence)("Can't extract module name from " + fileName + ": " + cause.getMessage()));
                    }
                    if (!this.includePathExceptionsInClasspath) {
                        this.getLog().warn((CharSequence)"Some dependencies encountered issues while attempting to be resolved as modules and will not be included in the classpath; you can change this behavior via the  'includePathExceptionsInClasspath' configuration parameter.");
                    }
                }
                this.moduleDescriptor = this.createModuleDescriptor((ResolvePathsResult<File>)resolvePathsResult);
                for (Map.Entry entry : resolvePathsResult.getModulepathElements().entrySet()) {
                    if (!ModuleNameSource.FILENAME.equals(entry.getValue())) continue;
                    String message = "Required filename-based automodules detected. Please don't publish this project to a public artifact repository!";
                    if (this.moduleDescriptor != null && this.moduleDescriptor.exports().isEmpty()) {
                        this.getLog().info((CharSequence)"Required filename-based automodules detected. Please don't publish this project to a public artifact repository!");
                        break;
                    }
                    this.getLog().warn((CharSequence)"Required filename-based automodules detected. Please don't publish this project to a public artifact repository!");
                    break;
                }
                resolvePathsResult.getClasspathElements().forEach(file -> this.classpathElements.add(file.getPath()));
                resolvePathsResult.getModulepathElements().keySet().forEach(file -> this.modulepathElements.add(file.getPath()));
                if (this.includePathExceptionsInClasspath) {
                    resolvePathsResult.getPathExceptions().keySet().forEach(file -> this.classpathElements.add(file.getPath()));
                }
            } else {
                this.pathElements.forEach((k, v) -> {
                    if (v != null && v.name() != null && v.name().startsWith(JAVAFX_PREFIX)) {
                        this.modulepathElements.add((String)k);
                    } else {
                        this.classpathElements.add((String)k);
                    }
                });
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)e.getMessage());
        }
        if (this.runtimePathOption == RuntimePathOption.MODULEPATH) {
            this.getLog().debug((CharSequence)((Object)((Object)this.runtimePathOption) + " runtimePathOption set by user. Moving all jars to modulepath."));
            this.modulepathElements.addAll(this.classpathElements);
            this.classpathElements.clear();
        } else if (this.runtimePathOption == RuntimePathOption.CLASSPATH) {
            this.getLog().debug((CharSequence)((Object)((Object)this.runtimePathOption) + " runtimePathOption set by user. Moving all jars to classpath."));
            this.classpathElements.addAll(this.modulepathElements);
            this.modulepathElements.clear();
            if (this.mainClass.contains("/")) {
                this.getLog().warn((CharSequence)"Module name found in <mainClass> with runtimePathOption set as CLASSPATH. Module name will be ignored.");
            }
            if (this.doesExtendFXApplication(this.createMainClassString(this.mainClass, this.moduleDescriptor, this.runtimePathOption))) {
                throw new MojoExecutionException("Launcher class is required. Main-class cannot extend Application when running JavaFX application on CLASSPATH");
            }
        }
        this.getLog().debug((CharSequence)("Classpath:" + this.classpathElements.size()));
        this.classpathElements.forEach(s -> this.getLog().debug((CharSequence)(" " + s)));
        this.getLog().debug((CharSequence)("Modulepath: " + this.modulepathElements.size()));
        this.modulepathElements.forEach(s -> this.getLog().debug((CharSequence)(" " + s)));
        this.getLog().debug((CharSequence)("pathElements: " + this.pathElements.size()));
        this.pathElements.forEach((k, v) -> this.getLog().debug((CharSequence)(" " + k + " :: " + (v != null && v.name() != null ? v.name() : v))));
    }

    private JavaModuleDescriptor createModuleDescriptor(ResolvePathsResult<File> resolvePathsResult) throws MojoExecutionException {
        if (this.runtimePathOption == RuntimePathOption.CLASSPATH) {
            this.getLog().info((CharSequence)((Object)((Object)RuntimePathOption.CLASSPATH) + " runtimePathOption set by user. module-info.java will be ignored."));
            return null;
        }
        return resolvePathsResult.getMainModuleDescriptor();
    }

    private List<File> getCompileClasspathElements(MavenProject project) {
        ArrayList<File> list = new ArrayList<File>();
        list.add(new File(project.getBuild().getOutputDirectory()));
        list.addAll(project.getDependencies().stream().filter(d -> d.getSystemPath() != null && !d.getSystemPath().isEmpty()).map(d -> new File(d.getSystemPath())).collect(Collectors.toList()));
        list.addAll(project.getArtifacts().stream().sorted((a1, a2) -> {
            int compare = a1.compareTo(a2);
            if (compare == 0) {
                return a1.hasClassifier() ? 1 : (a2.hasClassifier() ? -1 : 0);
            }
            return compare;
        }).map(Artifact::getFile).collect(Collectors.toList()));
        return list.stream().distinct().collect(Collectors.toList());
    }

    void handleWorkingDirectory() throws MojoExecutionException {
        if (this.workingDirectory == null) {
            this.workingDirectory = this.basedir;
        }
        if (!this.workingDirectory.exists()) {
            this.getLog().debug((CharSequence)("Making working directory '" + this.workingDirectory.getAbsolutePath() + "'."));
            if (!this.workingDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not make working directory: '" + this.workingDirectory.getAbsolutePath() + "'");
            }
        }
    }

    Map<String, String> handleSystemEnvVariables() {
        HashMap<String, String> enviro = new HashMap<String, String>();
        try {
            Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
            for (Map.Entry<Object, Object> entry : systemEnvVars.entrySet()) {
                enviro.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException x) {
            this.getLog().error((CharSequence)"Could not assign default system environment variables.", (Throwable)x);
        }
        return enviro;
    }

    CommandLine getExecutablePath(String executable, Map<String, String> enviro, File dir) {
        CommandLine toRet;
        String javaHomeFromEnv;
        File execFile = new File(executable);
        String exec = null;
        if (execFile.isFile()) {
            this.getLog().debug((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + executable));
            exec = execFile.getAbsolutePath();
        }
        if (exec == null && (javaHomeFromEnv = this.getJavaHomeEnv(enviro)) != null && !javaHomeFromEnv.isEmpty()) {
            exec = JavaFXBaseMojo.findExecutable(executable, Arrays.asList(javaHomeFromEnv.concat(File.separator).concat("bin")));
        }
        if (exec == null && OS.isFamilyWindows()) {
            List<String> paths = this.getExecutablePaths(enviro);
            paths.add(0, dir.getAbsolutePath());
            exec = JavaFXBaseMojo.findExecutable(executable, paths);
        }
        if (exec == null) {
            exec = executable;
        }
        if (OS.isFamilyWindows() && !JavaFXBaseMojo.hasNativeExtension(exec) && JavaFXBaseMojo.hasExecutableExtension(exec)) {
            String comSpec = System.getenv("ComSpec");
            toRet = new CommandLine(comSpec == null ? "cmd" : comSpec);
            toRet.addArgument("/c");
            toRet.addArgument(exec);
        } else {
            toRet = new CommandLine(exec);
        }
        this.getLog().debug((CharSequence)("Executable " + toRet.toString()));
        return toRet;
    }

    int executeCommandLine(Executor exec, CommandLine commandLine, Map<String, String> enviro, OutputStream out, OutputStream err) throws ExecuteException, IOException {
        PumpStreamHandler psh = new PumpStreamHandler(out, err, System.in);
        return this.executeCommandLine(exec, commandLine, enviro, psh);
    }

    int executeCommandLine(Executor exec, CommandLine commandLine, Map<String, String> enviro, FileOutputStream outputFile) throws ExecuteException, IOException {
        BufferedOutputStream bos = new BufferedOutputStream(outputFile);
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)bos);
        return this.executeCommandLine(exec, commandLine, enviro, psh);
    }

    static Path getParent(Path path, int depth) {
        if (path == null || !Files.exists(path, new LinkOption[0]) || depth > path.getNameCount()) {
            return null;
        }
        return path.getRoot().resolve(path.subpath(0, path.getNameCount() - depth));
    }

    String createMainClassString(String mainClass, JavaModuleDescriptor moduleDescriptor, RuntimePathOption runtimePathOption) {
        Objects.requireNonNull(mainClass, "Main class cannot be null");
        if (runtimePathOption == RuntimePathOption.CLASSPATH) {
            if (mainClass.contains("/")) {
                return mainClass.substring(mainClass.indexOf("/") + 1);
            }
            return mainClass;
        }
        if (moduleDescriptor != null && !mainClass.contains("/")) {
            this.getLog().warn((CharSequence)"Module name not found in <mainClass>. Module name will be assumed from module-info.java");
            return moduleDescriptor.name() + "/" + mainClass;
        }
        return mainClass;
    }

    private static String findExecutable(String executable, List<String> paths) {
        File f = null;
        block0: for (String path : paths) {
            f = new File(path, executable);
            if (!OS.isFamilyWindows() && f.isFile()) break;
            for (String extension : JavaFXBaseMojo.getExecutableExtensions()) {
                f = new File(path, executable + extension);
                if (!f.isFile()) continue;
                break block0;
            }
        }
        if (f == null || !f.exists()) {
            return null;
        }
        return f.getAbsolutePath();
    }

    private static boolean hasNativeExtension(String exec) {
        String lowerCase = exec.toLowerCase();
        return lowerCase.endsWith(".exe") || lowerCase.endsWith(".com");
    }

    private static boolean hasExecutableExtension(String exec) {
        String lowerCase = exec.toLowerCase();
        for (String ext : JavaFXBaseMojo.getExecutableExtensions()) {
            if (!lowerCase.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getExecutableExtensions() {
        String pathExt = System.getenv("PATHEXT");
        return pathExt == null ? Arrays.asList(".bat", ".cmd") : Arrays.asList(StringUtils.split((String)pathExt.toLowerCase(), (String)File.pathSeparator));
    }

    private List<String> getExecutablePaths(Map<String, String> enviro) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("");
        String path = enviro.get("PATH");
        if (path != null) {
            paths.addAll(Arrays.asList(StringUtils.split((String)path, (String)File.pathSeparator)));
        }
        return paths;
    }

    private String getJavaHomeEnv(Map<String, String> enviro) {
        String javahome = enviro.get("JAVA_HOME");
        if (javahome == null || javahome.isEmpty()) {
            return null;
        }
        int pathStartIndex = javahome.charAt(0) == '\"' ? 1 : 0;
        int pathEndIndex = javahome.charAt(javahome.length() - 1) == '\"' ? javahome.length() - 1 : javahome.length();
        return javahome.substring(pathStartIndex, pathEndIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommandLine(Executor exec, final CommandLine commandLine, Map<String, String> enviro, final PumpStreamHandler psh) throws ExecuteException, IOException {
        int result;
        exec.setStreamHandler((ExecuteStreamHandler)psh);
        try {
            psh.start();
            if (this.async) {
                if (this.asyncDestroyOnShutdown) {
                    exec.setProcessDestroyer(this.getProcessDestroyer());
                }
                exec.execute(commandLine, enviro, new ExecuteResultHandler(){

                    public void onProcessFailed(ExecuteException e) {
                        JavaFXBaseMojo.this.getLog().error((CharSequence)("Async process failed for: " + commandLine), (Throwable)e);
                    }

                    public void onProcessComplete(int exitValue) {
                        JavaFXBaseMojo.this.getLog().debug((CharSequence)("Async process complete, exit value = " + exitValue + " for: " + commandLine));
                        try {
                            psh.stop();
                        }
                        catch (IOException e) {
                            JavaFXBaseMojo.this.getLog().error((CharSequence)("Error stopping async process stream handler for: " + commandLine), (Throwable)e);
                        }
                    }
                });
                result = 0;
            } else {
                result = exec.execute(commandLine, enviro);
            }
        }
        finally {
            if (!this.async) {
                psh.stop();
            }
        }
        return result;
    }

    private ProcessDestroyer getProcessDestroyer() {
        if (this.processDestroyer == null) {
            this.processDestroyer = new ShutdownHookProcessDestroyer();
        }
        return this.processDestroyer;
    }

    private boolean doesExtendFXApplication(String mainClass) {
        boolean fxApplication = false;
        try {
            ArrayList<URL> pathUrls = new ArrayList<URL>();
            for (String path : this.project.getCompileClasspathElements()) {
                pathUrls.add(new File(path).toURI().toURL());
            }
            URL[] urls = pathUrls.toArray(new URL[0]);
            URLClassLoader classLoader = new URLClassLoader(urls, JavaFXBaseMojo.class.getClassLoader());
            Class<?> clazz = Class.forName(mainClass, false, classLoader);
            fxApplication = JavaFXBaseMojo.doesExtendFXApplication(clazz);
            this.getLog().debug((CharSequence)("Main Class " + clazz.toString() + " extends Application: " + fxApplication));
        }
        catch (ClassNotFoundException | NoClassDefFoundError | MalformedURLException | DependencyResolutionRequiredException e) {
            this.getLog().debug(e);
        }
        return fxApplication;
    }

    private static boolean doesExtendFXApplication(Class<?> mainClass) {
        for (Class<?> sc = mainClass.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            if (!sc.getName().equals(JAVAFX_APPLICATION_CLASS_NAME)) continue;
            return true;
        }
        return false;
    }
}

