/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.webkit.InputMethodClient;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCInputMethodEvent;
import com.sun.webkit.graphics.WCPoint;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.geometry.Point2D;
import javafx.scene.Scene;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.web.WebView;

public final class InputMethodClientImpl
implements InputMethodClient,
ExtendedInputMethodRequests {
    private static final Logger log = Logger.getLogger(InputMethodClientImpl.class.getName());
    private final WeakReference<WebView> wvRef;
    private final WebPage webPage;
    private boolean state;

    public InputMethodClientImpl(WebView webView, WebPage webPage) {
        this.wvRef = new WeakReference<WebView>(webView);
        this.webPage = webPage;
        if (webPage != null) {
            webPage.setInputMethodClient(this);
        }
    }

    @Override
    public void activateInputMethods(boolean bl) {
        WebView webView = (WebView)((Object)this.wvRef.get());
        if (webView != null && webView.getScene() != null) {
            SceneHelper.enableInputMethodEvents((Scene)webView.getScene(), (boolean)bl);
        }
        this.state = bl;
    }

    public boolean getInputMethodState() {
        return this.state;
    }

    public static WCInputMethodEvent convertToWCInputMethodEvent(InputMethodEvent inputMethodEvent) {
        Object object2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Object object2 : inputMethodEvent.getComposed()) {
            String string = object2.getText();
            InputMethodHighlight inputMethodHighlight = object2.getHighlight();
            arrayList.add(n);
            arrayList.add(n + string.length());
            arrayList.add(inputMethodHighlight == InputMethodHighlight.SELECTED_CONVERTED || inputMethodHighlight == InputMethodHighlight.SELECTED_RAW ? 1 : 0);
            n += string.length();
            stringBuilder.append(string);
        }
        int n2 = arrayList.size();
        if (n2 == 0) {
            arrayList.add(0);
            arrayList.add(n);
            arrayList.add(0);
            n2 = arrayList.size();
        }
        object2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            object2[i] = (InputMethodTextRun)((Integer)arrayList.get(i));
        }
        return new WCInputMethodEvent(inputMethodEvent.getCommitted(), stringBuilder.toString(), (int[])object2, inputMethodEvent.getCaretPosition());
    }

    public Point2D getTextLocation(int n) {
        FutureTask<Point2D> futureTask = new FutureTask<Point2D>(() -> {
            int[] nArray = this.webPage.getClientTextLocation(n);
            WCPoint wCPoint = this.webPage.getPageClient().windowToScreen(new WCPoint(nArray[0], nArray[1] + nArray[3]));
            return new Point2D((double)wCPoint.getIntX(), (double)wCPoint.getIntY());
        });
        Invoker.getInvoker().invokeOnEventThread(futureTask);
        Point2D point2D = null;
        try {
            point2D = futureTask.get();
        }
        catch (ExecutionException executionException) {
            log.log(Level.SEVERE, "InputMethodClientImpl.getTextLocation " + executionException);
        }
        catch (InterruptedException interruptedException) {
            log.log(Level.SEVERE, "InputMethodClientImpl.getTextLocation InterruptedException" + interruptedException);
        }
        return point2D;
    }

    public int getLocationOffset(int n, int n2) {
        FutureTask<Integer> futureTask = new FutureTask<Integer>(() -> {
            WCPoint wCPoint = this.webPage.getPageClient().windowToScreen(new WCPoint(0.0f, 0.0f));
            return this.webPage.getClientLocationOffset(n - wCPoint.getIntX(), n2 - wCPoint.getIntY());
        });
        Invoker.getInvoker().invokeOnEventThread(futureTask);
        int n3 = 0;
        try {
            n3 = futureTask.get();
        }
        catch (ExecutionException executionException) {
            log.log(Level.SEVERE, "InputMethodClientImpl.getLocationOffset " + executionException);
        }
        catch (InterruptedException interruptedException) {
            log.log(Level.SEVERE, "InputMethodClientImpl.getTextLocation InterruptedException" + interruptedException);
        }
        return n3;
    }

    public void cancelLatestCommittedText() {
    }

    public String getSelectedText() {
        return this.webPage.getClientSelectedText();
    }

    public int getInsertPositionOffset() {
        return this.webPage.getClientInsertPositionOffset();
    }

    public String getCommittedText(int n, int n2) {
        try {
            return this.webPage.getClientCommittedText().substring(n, n2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException(stringIndexOutOfBoundsException);
        }
    }

    public int getCommittedTextLength() {
        return this.webPage.getClientCommittedTextLength();
    }
}

