/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.sg.prism.NGImageView;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPath;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NGText;
import com.sun.javafx.text.TextRun;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.javafx.webkit.prism.TextUtilities;
import com.sun.javafx.webkit.prism.WCLinearGradient;
import com.sun.javafx.webkit.prism.WCPathImpl;
import com.sun.javafx.webkit.prism.WCRadialGradient;
import com.sun.javafx.webkit.prism.WCStrokeImpl;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.MaskTextureGraphics;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.Paint;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.DropShadow;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrEffectHelper;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrRenderer;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.RenderTheme;
import com.sun.webkit.graphics.ScrollBarTheme;
import com.sun.webkit.graphics.WCFont;
import com.sun.webkit.graphics.WCGradient;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCIcon;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCPath;
import com.sun.webkit.graphics.WCPoint;
import com.sun.webkit.graphics.WCRectangle;
import com.sun.webkit.graphics.WCSize;
import com.sun.webkit.graphics.WCTransform;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;

class WCGraphicsPrismContext
extends WCGraphicsContext {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)WCGraphicsPrismContext.class.getName());
    private static final boolean DEBUG_DRAW_CLIP_SHAPE = Boolean.valueOf(AccessController.doPrivileged(() -> System.getProperty("com.sun.webkit.debugDrawClipShape", "false")));
    Graphics baseGraphics;
    private BaseTransform baseTransform;
    private final List<ContextState> states = new ArrayList<ContextState>();
    private ContextState state = new ContextState();
    private Graphics cachedGraphics = null;
    private int fontSmoothingType;
    private boolean isRootLayerValid = false;
    private static final BasicStroke focusRingStroke = new BasicStroke(1.1f, 0, 1, 0.0f, new float[]{1.0f}, 0.0f);

    WCGraphicsPrismContext(Graphics graphics) {
        this.state.setClip(graphics.getClipRect());
        this.state.setAlpha(graphics.getExtraAlpha());
        this.baseGraphics = graphics;
        this.initBaseTransform(graphics.getTransformNoClone());
    }

    WCGraphicsPrismContext() {
    }

    public Type type() {
        return Type.PRIMARY;
    }

    final void initBaseTransform(BaseTransform baseTransform) {
        this.baseTransform = new Affine3D(baseTransform);
        this.state.setTransform((Affine3D)this.baseTransform);
    }

    private void resetCachedGraphics() {
        this.cachedGraphics = null;
    }

    @Override
    public Object getPlatformGraphics() {
        return this.getGraphics(false);
    }

    @Override
    public boolean isValid() {
        Object object = this.getPlatformGraphics();
        if (!(object instanceof Graphics)) {
            return false;
        }
        Graphics graphics = (Graphics)object;
        return !graphics.getResourceFactory().isDisposed();
    }

    Graphics getGraphics(boolean bl) {
        Layer layer;
        if (this.cachedGraphics == null) {
            layer = this.state.getLayerNoClone();
            this.cachedGraphics = layer != null ? layer.getGraphics() : this.baseGraphics;
            ResourceFactory resourceFactory = this.cachedGraphics.getResourceFactory();
            if (!resourceFactory.isDisposed()) {
                this.state.apply(this.cachedGraphics);
            }
            if (log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine("getPlatformGraphics for " + this + " : " + this.cachedGraphics);
            }
        }
        layer = this.cachedGraphics.getClipRectNoClone();
        return bl && layer != null && layer.isEmpty() ? null : this.cachedGraphics;
    }

    @Override
    public void saveState() {
        this.state.markAsRestorePoint();
        this.saveStateInternal();
    }

    private void saveStateInternal() {
        this.states.add(this.state);
        this.state = this.state.clone();
    }

    private void startNewLayer(Layer layer) {
        this.saveStateInternal();
        Rectangle rectangle = this.state.getClipNoClone();
        Affine3D affine3D = new Affine3D(BaseTransform.getTranslateInstance((double)(-rectangle.x), (double)(-rectangle.y)));
        affine3D.concatenate((BaseTransform)this.state.getTransformNoClone());
        rectangle.x = 0;
        rectangle.y = 0;
        Graphics graphics = this.getGraphics(true);
        if (graphics != null && graphics != this.baseGraphics) {
            layer.init(graphics);
        }
        this.state.setTransform(affine3D);
        this.state.setLayer(layer);
        this.resetCachedGraphics();
    }

    private void renderLayer(Layer layer) {
        WCTransform wCTransform = this.getTransform();
        this.setTransform(new WCTransform(1.0, 0.0, 0.0, 1.0, layer.getX(), layer.getY()));
        Graphics graphics = this.getGraphics(true);
        if (graphics != null) {
            layer.render(graphics);
        }
        this.setTransform(wCTransform);
    }

    private void restoreStateInternal() {
        int n = this.states.size();
        if (n == 0) {
            assert (false) : "Unbalanced restoreState";
            return;
        }
        Layer layer = this.state.getLayerNoClone();
        this.state = this.states.remove(n - 1);
        if (layer != this.state.getLayerNoClone()) {
            this.renderLayer(layer);
            layer.dispose();
            if (log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine("Popped layer " + layer);
            }
        } else {
            this.resetCachedGraphics();
        }
    }

    @Override
    public void restoreState() {
        log.fine("restoring state");
        do {
            this.restoreStateInternal();
        } while (!this.state.isRestorePoint());
    }

    private void flushAllLayers() {
        if (this.state == null) {
            return;
        }
        if (this.isRootLayerValid) {
            log.fine("FlushAllLayers: root layer is valid, skipping");
            return;
        }
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("FlushAllLayers");
        }
        ContextState contextState = this.state;
        for (int i = this.states.size() - 1; i >= 0; --i) {
            Layer layer = this.state.getLayerNoClone();
            this.state = this.states.get(i);
            if (layer != this.state.getLayerNoClone()) {
                this.renderLayer(layer);
                continue;
            }
            this.resetCachedGraphics();
        }
        Layer layer = this.state.getLayerNoClone();
        if (layer != null) {
            this.renderLayer(layer);
        }
        this.state = contextState;
        this.isRootLayerValid = true;
    }

    @Override
    public void dispose() {
        if (!this.states.isEmpty()) {
            log.fine("Unbalanced saveState/restoreState");
        }
        for (ContextState contextState : this.states) {
            if (contextState.getLayerNoClone() == null) continue;
            contextState.getLayerNoClone().dispose();
        }
        this.states.clear();
        if (this.state != null && this.state.getLayerNoClone() != null) {
            this.state.getLayerNoClone().dispose();
        }
        this.state = null;
    }

    @Override
    public void setClip(WCPath wCPath, boolean bl) {
        WCRectangle wCRectangle;
        Affine3D affine3D = new Affine3D(this.state.getTransformNoClone());
        wCPath.transform(affine3D.getMxx(), affine3D.getMyx(), affine3D.getMxy(), affine3D.getMyy(), affine3D.getMxt(), affine3D.getMyt());
        if (!bl) {
            wCRectangle = wCPath.getBounds();
            int n = (int)Math.floor(wCRectangle.getX());
            int n2 = (int)Math.floor(wCRectangle.getY());
            int n3 = (int)Math.ceil(wCRectangle.getMaxX()) - n;
            int n4 = (int)Math.ceil(wCRectangle.getMaxY()) - n2;
            this.state.clip(new Rectangle(n, n2, n3, n4));
        }
        wCRectangle = this.state.getClipNoClone();
        if (bl) {
            wCPath.addRect(((Rectangle)wCRectangle).x, ((Rectangle)wCRectangle).y, ((Rectangle)wCRectangle).width, ((Rectangle)wCRectangle).height);
        }
        wCPath.translate(-((Rectangle)wCRectangle).x, -((Rectangle)wCRectangle).y);
        ClipLayer clipLayer = new ClipLayer(this.getGraphics(false), (Rectangle)wCRectangle, wCPath, this.type() == Type.DEDICATED);
        this.startNewLayer(clipLayer);
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setClip(WCPath " + wCPath.getID() + ")");
            log.fine("Pushed layer " + clipLayer);
        }
    }

    private Rectangle transformClip(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        float[] fArray = new float[]{rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height};
        this.state.getTransformNoClone().transform(fArray, 0, fArray, 0, 4);
        float f = Math.min(fArray[0], Math.min(fArray[2], Math.min(fArray[4], fArray[6])));
        float f2 = Math.max(fArray[0], Math.max(fArray[2], Math.max(fArray[4], fArray[6])));
        float f3 = Math.min(fArray[1], Math.min(fArray[3], Math.min(fArray[5], fArray[7])));
        float f4 = Math.max(fArray[1], Math.max(fArray[3], Math.max(fArray[5], fArray[7])));
        return new Rectangle((BaseBounds)new RectBounds(f, f3, f2, f4));
    }

    private void setClip(Rectangle rectangle) {
        Affine3D affine3D = this.state.getTransformNoClone();
        if (affine3D.getMxy() == 0.0 && affine3D.getMxz() == 0.0 && affine3D.getMyx() == 0.0 && affine3D.getMyz() == 0.0 && affine3D.getMzx() == 0.0 && affine3D.getMzy() == 0.0) {
            Rectangle rectangle2;
            this.state.clip(this.transformClip(rectangle));
            if (log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine("setClip({0})", new Object[]{rectangle});
            }
            if (DEBUG_DRAW_CLIP_SHAPE && (rectangle2 = this.state.getClipNoClone()) != null && rectangle2.width >= 2 && rectangle2.height >= 2) {
                WCTransform wCTransform = this.getTransform();
                this.setTransform(new WCTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0));
                Graphics graphics = this.getGraphics(true);
                if (graphics != null) {
                    float f = (float)Math.random();
                    graphics.setPaint((Paint)new Color(f, 1.0f - f, 0.5f, 0.1f));
                    graphics.setStroke(new BasicStroke());
                    graphics.fillRect((float)rectangle2.x, (float)rectangle2.y, (float)rectangle2.width, (float)rectangle2.height);
                    graphics.setPaint((Paint)new Color(1.0f - f, f, 0.5f, 1.0f));
                    graphics.drawRect((float)rectangle2.x, (float)rectangle2.y, (float)rectangle2.width, (float)rectangle2.height);
                }
                this.setTransform(wCTransform);
                this.state.clip(new Rectangle(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2));
            }
            if (this.cachedGraphics != null) {
                this.cachedGraphics.setClipRect(this.state.getClipNoClone());
            }
        } else {
            WCPathImpl wCPathImpl = new WCPathImpl();
            ((WCPath)wCPathImpl).addRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.setClip(wCPathImpl, false);
        }
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void setClip(WCRectangle wCRectangle) {
        this.setClip(new Rectangle((int)wCRectangle.getX(), (int)wCRectangle.getY(), (int)wCRectangle.getWidth(), (int)wCRectangle.getHeight()));
    }

    @Override
    public WCRectangle getClip() {
        Rectangle rectangle = this.state.getClipNoClone();
        return rectangle == null ? null : new WCRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Rectangle getClipRectNoClone() {
        return this.state.getClipNoClone();
    }

    protected Affine3D getTransformNoClone() {
        return this.state.getTransformNoClone();
    }

    @Override
    public void translate(float f, float f2) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("translate({0},{1})", new Object[]{Float.valueOf(f), Float.valueOf(f2)});
        }
        this.state.translate(f, f2);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.translate(f, f2);
        }
    }

    @Override
    public void scale(float f, float f2) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("scale(" + f + " " + f2 + ")");
        }
        this.state.scale(f, f2);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.scale(f, f2);
        }
    }

    @Override
    public void rotate(float f) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("rotate(" + f + ")");
        }
        this.state.rotate(f);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.setTransform((BaseTransform)this.state.getTransformNoClone());
        }
    }

    protected boolean shouldRenderRect(float f, float f2, float f3, float f4, DropShadow dropShadow, BasicStroke basicStroke) {
        return true;
    }

    protected boolean shouldRenderShape(Shape shape, DropShadow dropShadow, BasicStroke basicStroke) {
        return true;
    }

    protected boolean shouldCalculateIntersection() {
        return false;
    }

    @Override
    public void fillRect(final float f, final float f2, final float f3, final float f4, final Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            String string = "fillRect(%f, %f, %f, %f, %s)";
            log.fine(String.format(string, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), color));
        }
        if (!this.shouldRenderRect(f, f2, f3, f4, this.state.getShadowNoClone(), null)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                Color color2 = color != null ? color : WCGraphicsPrismContext.this.state.getPaintNoClone();
                DropShadow dropShadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                if (dropShadow != null || !WCGraphicsPrismContext.this.state.getPerspectiveTransformNoClone().isIdentity()) {
                    NGRectangle nGRectangle = new NGRectangle();
                    nGRectangle.updateRectangle(f, f2, f3, f4, 0.0f, 0.0f);
                    WCGraphicsPrismContext.this.render(graphics, (Effect)dropShadow, (Paint)color2, null, (NGNode)nGRectangle);
                } else {
                    graphics.setPaint((Paint)color2);
                    graphics.fillRect(f, f2, f3, f4);
                }
            }
        }.paint();
    }

    @Override
    public void fillRoundedRect(final float f, final float f2, final float f3, final float f4, final float f5, final float f6, final float f7, final float f8, final float f9, final float f10, final float f11, final float f12, final Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("fillRoundedRect(%f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %s)", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8), Float.valueOf(f9), Float.valueOf(f10), Float.valueOf(f11), Float.valueOf(f12), color));
        }
        if (!this.shouldRenderRect(f, f2, f3, f4, this.state.getShadowNoClone(), null)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                float f13 = (f5 + f7 + f9 + f11) / 2.0f;
                float f22 = (f6 + f8 + f10 + f12) / 2.0f;
                DropShadow dropShadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                if (dropShadow != null) {
                    NGRectangle nGRectangle = new NGRectangle();
                    nGRectangle.updateRectangle(f, f2, f3, f4, f13, f22);
                    WCGraphicsPrismContext.this.render(graphics, (Effect)dropShadow, (Paint)color, null, (NGNode)nGRectangle);
                } else {
                    graphics.setPaint((Paint)color);
                    graphics.fillRoundRect(f, f2, f3, f4, f13, f22);
                }
            }
        }.paint();
    }

    @Override
    public void clearRect(final float f, final float f2, final float f3, final float f4) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("clearRect(%f, %f, %f, %f)", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4)));
        }
        if (this.shouldCalculateIntersection()) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                graphics.clearQuad(f, f2, f + f3, f2 + f4);
            }
        }.paint();
    }

    @Override
    public void setFillColor(Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("setFillColor(%s)", color));
        }
        this.state.setPaint((Paint)color);
    }

    @Override
    public void setFillGradient(WCGradient wCGradient) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setFillGradient(" + wCGradient + ")");
        }
        this.state.setPaint((Paint)((Gradient)wCGradient.getPlatformGradient()));
    }

    @Override
    public void setTextMode(boolean bl, boolean bl2, boolean bl3) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setTextMode(fill:" + bl + ",stroke:" + bl2 + ",clip:" + bl3 + ")");
        }
        this.state.setTextMode(bl, bl2, bl3);
    }

    @Override
    public void setFontSmoothingType(int n) {
        this.fontSmoothingType = n;
    }

    @Override
    public int getFontSmoothingType() {
        return this.fontSmoothingType;
    }

    @Override
    public void setStrokeStyle(int n) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setStrokeStyle({0})", new Object[]{n});
        }
        this.state.getStrokeNoClone().setStyle(n);
    }

    @Override
    public void setStrokeColor(Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("setStrokeColor(%s)", color));
        }
        this.state.getStrokeNoClone().setPaint(color);
    }

    @Override
    public void setStrokeWidth(float f) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setStrokeWidth({0})", new Object[]{Float.valueOf(f)});
        }
        this.state.getStrokeNoClone().setThickness(f);
    }

    @Override
    public void setStrokeGradient(WCGradient wCGradient) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setStrokeGradient(" + wCGradient + ")");
        }
        this.state.getStrokeNoClone().setPaint((Gradient)wCGradient.getPlatformGradient());
    }

    @Override
    public void setLineDash(float f, float ... fArray) {
        int n;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder("[");
            for (n = 0; n < fArray.length; ++n) {
                stringBuilder.append(fArray[n]).append(',');
            }
            stringBuilder.append(']');
            log.fine("setLineDash({0},{1}", new Object[]{Float.valueOf(f), stringBuilder});
        }
        this.state.getStrokeNoClone().setDashOffset(f);
        if (fArray != null) {
            boolean bl = true;
            for (n = 0; n < fArray.length; ++n) {
                if (fArray[n] == 0.0f) continue;
                bl = false;
                break;
            }
            if (bl) {
                fArray = null;
            }
        }
        this.state.getStrokeNoClone().setDashSizes(fArray);
    }

    @Override
    public void setLineCap(int n) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setLineCap(" + n + ")");
        }
        this.state.getStrokeNoClone().setLineCap(n);
    }

    @Override
    public void setLineJoin(int n) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setLineJoin(" + n + ")");
        }
        this.state.getStrokeNoClone().setLineJoin(n);
    }

    @Override
    public void setMiterLimit(float f) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("setMiterLimit(" + f + ")");
        }
        this.state.getStrokeNoClone().setMiterLimit(f);
    }

    @Override
    public void setShadow(float f, float f2, float f3, Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            String string = "setShadow(%f, %f, %f, %s)";
            log.fine(String.format(string, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), color));
        }
        this.state.setShadow(this.createShadow(f, f2, f3, color));
    }

    @Override
    public void drawPolygon(final WCPath wCPath, boolean bl) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawPolygon({0})", new Object[]{bl});
        }
        if (!this.shouldRenderShape((Shape)((WCPathImpl)wCPath).getPlatformPath(), null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                Path2D path2D = (Path2D)wCPath.getPlatformPath();
                graphics.setPaint(WCGraphicsPrismContext.this.state.getPaintNoClone());
                graphics.fill((Shape)path2D);
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(graphics)) {
                    graphics.draw((Shape)path2D);
                }
            }
        }.paint();
    }

    @Override
    public void drawLine(final int n, final int n2, final int n3, final int n4) {
        Line2D line2D;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawLine({0}, {1}, {2}, {3})", new Object[]{n, n2, n3, n4});
        }
        if (!this.shouldRenderShape((Shape)(line2D = new Line2D((float)n, (float)n2, (float)n3, (float)n4)), null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(graphics)) {
                    graphics.drawLine((float)n, (float)n2, (float)n3, (float)n4);
                }
            }
        }.paint();
    }

    @Override
    public void drawPattern(final WCImage wCImage, final WCRectangle wCRectangle, final WCTransform wCTransform, final WCPoint wCPoint, final WCRectangle wCRectangle2) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawPattern({0}, {1}, {2}, {3})", new Object[]{wCRectangle2.getIntX(), wCRectangle2.getIntY(), wCRectangle2.getIntWidth(), wCRectangle2.getIntHeight()});
        }
        if (!this.shouldRenderRect(wCRectangle2.getX(), wCRectangle2.getY(), wCRectangle2.getWidth(), wCRectangle2.getHeight(), null, null)) {
            return;
        }
        if (wCImage != null) {
            new Composite(){

                @Override
                void doPaint(Graphics graphics) {
                    Image image = ((PrismImage)wCImage).getImage();
                    if (!wCRectangle.contains(new WCRectangle(0.0f, 0.0f, wCImage.getWidth(), wCImage.getHeight()))) {
                        image = image.createSubImage(wCRectangle.getIntX(), wCRectangle.getIntY(), (int)Math.ceil(wCRectangle.getWidth()), (int)Math.ceil(wCRectangle.getHeight()));
                    }
                    double[] dArray = wCTransform.getMatrix();
                    Affine3D affine3D = new Affine3D();
                    affine3D.translate((double)wCPoint.getX(), (double)wCPoint.getY());
                    affine3D.concatenate(dArray[0], dArray[2], dArray[4], dArray[1], dArray[3], dArray[5]);
                    graphics.setPaint((Paint)new ImagePattern(image, wCRectangle.getX(), wCRectangle.getY(), wCRectangle.getWidth(), wCRectangle.getHeight(), (BaseTransform)affine3D, false, false));
                    graphics.fillRect(wCRectangle2.getX(), wCRectangle2.getY(), wCRectangle2.getWidth(), wCRectangle2.getHeight());
                }
            }.paint();
        }
    }

    @Override
    public void drawImage(final WCImage wCImage, final float f, final float f2, final float f3, final float f4, final float f5, final float f6, final float f7, final float f8) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawImage(img, dst({0},{1},{2},{3}), src({4},{5},{6},{7}))", new Object[]{Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8)});
        }
        if (!this.shouldRenderRect(f, f2, f3, f4, this.state.getShadowNoClone(), null)) {
            return;
        }
        if (wCImage instanceof PrismImage) {
            new Composite(){

                @Override
                void doPaint(Graphics graphics) {
                    PrismImage prismImage = (PrismImage)wCImage;
                    DropShadow dropShadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                    if (dropShadow != null) {
                        NGImageView nGImageView = new NGImageView();
                        nGImageView.setImage((Object)prismImage.getImage());
                        nGImageView.setX(f);
                        nGImageView.setY(f2);
                        nGImageView.setViewport(f5, f6, f7, f8, f3, f4);
                        nGImageView.setContentBounds((BaseBounds)new RectBounds(f, f2, f + f3, f2 + f4));
                        WCGraphicsPrismContext.this.render(graphics, (Effect)dropShadow, null, null, (NGNode)nGImageView);
                    } else {
                        prismImage.draw(graphics, (int)f, (int)f2, (int)(f + f3), (int)(f2 + f4), (int)f5, (int)f6, (int)(f5 + f7), (int)(f6 + f8));
                    }
                }
            }.paint();
        }
    }

    @Override
    public void drawBitmapImage(final ByteBuffer byteBuffer, final int n, final int n2, final int n3, final int n4) {
        if (!this.shouldRenderRect(n, n2, n3, n4, null, null)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                ResourceFactory resourceFactory = graphics.getResourceFactory();
                if (resourceFactory.isDisposed()) {
                    log.fine("WCGraphicsPrismContext::doPaint skip because device has been disposed");
                    return;
                }
                byteBuffer.order(ByteOrder.nativeOrder());
                Image image = Image.fromByteBgraPreData((ByteBuffer)byteBuffer, (int)n3, (int)n4);
                Texture texture = resourceFactory.createTexture(image, Texture.Usage.STATIC, Texture.WrapMode.REPEAT);
                graphics.drawTexture(texture, (float)n, (float)n2, (float)(n + n3), (float)(n2 + n4), 0.0f, 0.0f, (float)n3, (float)n4);
                texture.dispose();
            }
        }.paint();
    }

    @Override
    public void drawIcon(WCIcon wCIcon, int n, int n2) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("UNIMPLEMENTED drawIcon ({0}, {1})", new Object[]{n, n2});
        }
    }

    @Override
    public void drawRect(final int n, final int n2, final int n3, final int n4) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawRect({0}, {1}, {2}, {3})", new Object[]{n, n2, n3, n4});
        }
        if (!this.shouldRenderRect(n, n2, n3, n4, null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                Paint paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                if (paint != null && paint.isOpaque()) {
                    graphics.setPaint(paint);
                    graphics.fillRect((float)n, (float)n2, (float)n3, (float)n4);
                }
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(graphics)) {
                    graphics.drawRect((float)n, (float)n2, (float)n3, (float)n4);
                }
            }
        }.paint();
    }

    @Override
    public void drawString(WCFont wCFont, int[] nArray, float[] fArray, final float f, final float f2) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("Drawing %d glyphs @(%.1f, %.1f)", nArray.length, Float.valueOf(f), Float.valueOf(f2)));
        }
        final PGFont pGFont = (PGFont)wCFont.getPlatformFont();
        final TextRun textRun = TextUtilities.createGlyphList(nArray, fArray, f, f2);
        final DropShadow dropShadow = this.state.getShadowNoClone();
        final BasicStroke basicStroke = this.state.isTextStroke() ? this.state.getStrokeNoClone().getPlatformStroke() : null;
        final FontStrike fontStrike = pGFont.getStrike((BaseTransform)this.getTransformNoClone(), this.getFontSmoothingType());
        if (this.shouldCalculateIntersection()) {
            Metrics metrics = fontStrike.getMetrics();
            textRun.setMetrics(metrics.getAscent(), metrics.getDescent(), metrics.getLineGap());
            if (!this.shouldRenderRect(f, f2, textRun.getWidth(), textRun.getHeight(), dropShadow, basicStroke)) {
                return;
            }
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                Paint paint;
                Paint paint2 = paint = WCGraphicsPrismContext.this.state.isTextFill() ? WCGraphicsPrismContext.this.state.getPaintNoClone() : null;
                if (dropShadow != null) {
                    NGText nGText = new NGText();
                    nGText.setGlyphs((Object[])new GlyphList[]{textRun});
                    nGText.setFont((Object)pGFont);
                    nGText.setFontSmoothingType(WCGraphicsPrismContext.this.fontSmoothingType);
                    WCGraphicsPrismContext.this.render(graphics, (Effect)dropShadow, paint, basicStroke, (NGNode)nGText);
                } else {
                    if (paint != null) {
                        graphics.setPaint(paint);
                        graphics.drawString((GlyphList)textRun, fontStrike, f, f2, null, 0, 0);
                    }
                    if (basicStroke != null && (paint = (Paint)WCGraphicsPrismContext.this.state.getStrokeNoClone().getPaint()) != null) {
                        graphics.setPaint(paint);
                        graphics.setStroke(basicStroke);
                        graphics.draw(fontStrike.getOutline((GlyphList)textRun, BaseTransform.getTranslateInstance((double)f, (double)f2)));
                    }
                }
            }
        }.paint();
    }

    @Override
    public void drawString(WCFont wCFont, String string, boolean bl, int n, int n2, float f, float f2) {
        GlyphList[] glyphListArray;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("str='%s' (length=%d), from=%d, to=%d, rtl=%b, @(%.1f, %.1f)", string, string.length(), n, n2, bl, Float.valueOf(f), Float.valueOf(f2)));
        }
        TextLayout textLayout = TextUtilities.createLayout(string.substring(n, n2), wCFont.getPlatformFont());
        int n3 = 0;
        for (GlyphList glyphList : glyphListArray = textLayout.getRuns()) {
            n3 += glyphList.getGlyphCount();
        }
        int[] nArray = new int[n3];
        float[] fArray = new float[n3];
        n3 = 0;
        for (GlyphList glyphList : textLayout.getRuns()) {
            int n4 = glyphList.getGlyphCount();
            for (int i = 0; i < n4; ++i) {
                nArray[n3] = glyphList.getGlyphCode(i);
                fArray[n3] = glyphList.getPosX(i + 1) - glyphList.getPosX(i);
                ++n3;
            }
        }
        f = bl ? (f += TextUtilities.getLayoutWidth(string.substring(n), wCFont.getPlatformFont()) - textLayout.getBounds().getWidth()) : (f += TextUtilities.getLayoutWidth(string.substring(0, n), wCFont.getPlatformFont()));
        this.drawString(wCFont, nArray, fArray, f, f2);
    }

    @Override
    public void setComposite(int n) {
        log.fine("setComposite({0})", new Object[]{n});
        this.state.setCompositeOperation(n);
    }

    @Override
    public void drawEllipse(final int n, final int n2, final int n3, final int n4) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("drawEllipse({0}, {1}, {2}, {3})", new Object[]{n, n2, n3, n4});
        }
        if (!this.shouldRenderRect(n, n2, n3, n4, null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                graphics.setPaint(WCGraphicsPrismContext.this.state.getPaintNoClone());
                graphics.fillEllipse((float)n, (float)n2, (float)n3, (float)n4);
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(graphics)) {
                    graphics.drawEllipse((float)n, (float)n2, (float)n3, (float)n4);
                }
            }
        }.paint();
    }

    @Override
    public void drawFocusRing(final int n, final int n2, final int n3, final int n4, final Color color) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("drawFocusRing: %d, %d, %d, %d, %s", n, n2, n3, n4, color));
        }
        if (!this.shouldRenderRect(n, n2, n3, n4, null, focusRingStroke)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                graphics.setPaint((Paint)color);
                BasicStroke basicStroke = graphics.getStroke();
                graphics.setStroke(focusRingStroke);
                graphics.drawRoundRect((float)n, (float)n2, (float)n3, (float)n4, 4.0f, 4.0f);
                graphics.setStroke(basicStroke);
            }
        }.paint();
    }

    @Override
    public void setAlpha(float f) {
        log.fine("setAlpha({0})", new Object[]{Float.valueOf(f)});
        this.state.setAlpha(f);
        if (null != this.cachedGraphics) {
            this.cachedGraphics.setExtraAlpha(this.state.getAlpha());
        }
    }

    @Override
    public float getAlpha() {
        return this.state.getAlpha();
    }

    @Override
    public void beginTransparencyLayer(float f) {
        TransparencyLayer transparencyLayer = new TransparencyLayer(this.getGraphics(false), this.state.getClipNoClone(), f);
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("beginTransparencyLayer(%s)", transparencyLayer));
        }
        this.state.markAsRestorePoint();
        this.startNewLayer(transparencyLayer);
    }

    @Override
    public void endTransparencyLayer() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("endTransparencyLayer(%s)", this.state.getLayerNoClone()));
        }
        this.restoreState();
    }

    @Override
    public void drawWidget(final RenderTheme renderTheme, final Ref ref, final int n, final int n2) {
        WCSize wCSize = renderTheme.getWidgetSize(ref);
        if (!this.shouldRenderRect(n, n2, wCSize.getWidth(), wCSize.getHeight(), null, null)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                renderTheme.drawWidget(WCGraphicsPrismContext.this, ref, n, n2);
            }
        }.paint();
    }

    @Override
    public void drawScrollbar(final ScrollBarTheme scrollBarTheme, final Ref ref, final int n, final int n2, final int n3, final int n4) {
        WCSize wCSize;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("drawScrollbar(%s, %s, x = %d, y = %d)", scrollBarTheme, ref, n, n2));
        }
        if (!this.shouldRenderRect(n, n2, (wCSize = scrollBarTheme.getWidgetSize(ref)).getWidth(), wCSize.getHeight(), null, null)) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                scrollBarTheme.paint(WCGraphicsPrismContext.this, ref, n, n2, n3, n4);
            }
        }.paint();
    }

    private static Rectangle intersect(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            return rectangle2;
        }
        RectBounds rectBounds = rectangle.toRectBounds();
        rectBounds.intersectWith(rectangle2);
        rectangle.setBounds((BaseBounds)rectBounds);
        return rectangle;
    }

    private static Color4f createColor4f(Color color) {
        return new Color4f(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private DropShadow createShadow(float f, float f2, float f3, Color color) {
        if (f == 0.0f && f2 == 0.0f && f3 == 0.0f) {
            return null;
        }
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX((int)f);
        dropShadow.setOffsetY((int)f2);
        dropShadow.setRadius(f3 < 0.0f ? 0.0f : (f3 > 127.0f ? 127.0f : f3));
        dropShadow.setColor(WCGraphicsPrismContext.createColor4f(color));
        return dropShadow;
    }

    private void render(Graphics graphics, Effect effect, Paint paint, BasicStroke basicStroke, NGNode nGNode) {
        if (nGNode instanceof NGShape) {
            NGShape nGShape = (NGShape)nGNode;
            Shape shape = nGShape.getShape();
            Paint paint2 = (Paint)this.state.getStrokeNoClone().getPaint();
            if (basicStroke != null && paint2 != null) {
                shape = basicStroke.createStrokedShape(shape);
                nGShape.setDrawStroke(basicStroke);
                nGShape.setDrawPaint((Object)paint2);
                nGShape.setMode(paint == null ? NGShape.Mode.STROKE : NGShape.Mode.STROKE_FILL);
            } else {
                nGShape.setMode(paint == null ? NGShape.Mode.EMPTY : NGShape.Mode.FILL);
            }
            nGShape.setFillPaint((Object)paint);
            nGShape.setContentBounds((BaseBounds)shape.getBounds());
        }
        boolean bl = graphics.hasPreCullingBits();
        graphics.setHasPreCullingBits(false);
        nGNode.setEffect(effect);
        nGNode.render(graphics);
        graphics.setHasPreCullingBits(bl);
    }

    private static FilterContext getFilterContext(Graphics graphics) {
        Screen screen = graphics.getAssociatedScreen();
        if (screen == null) {
            ResourceFactory resourceFactory = graphics.getResourceFactory();
            return PrFilterContext.getPrinterContext((Object)resourceFactory);
        }
        return PrFilterContext.getInstance((Screen)screen);
    }

    @Override
    public void strokeArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("strokeArc(%d, %d, %d, %d, %d, %d)", n, n2, n3, n4, n5, n6));
        }
        final Arc2D arc2D = new Arc2D((float)n, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6, 0);
        if (this.state.getStrokeNoClone().isApplicable() && !this.shouldRenderShape((Shape)arc2D, null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(graphics)) {
                    graphics.draw((Shape)arc2D);
                }
            }
        }.paint();
    }

    @Override
    public WCImage getImage() {
        return null;
    }

    @Override
    public void strokeRect(final float f, final float f2, final float f3, final float f4, float f5) {
        BasicStroke basicStroke;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(String.format("strokeRect_FFFFF(%f, %f, %f, %f, %f)", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5)));
        }
        if (!this.shouldRenderRect(f, f2, f3, f4, null, basicStroke = new BasicStroke(f5, 0, 0, Math.max(1.0f, f5), this.state.getStrokeNoClone().getDashSizes(), this.state.getStrokeNoClone().getDashOffset()))) {
            return;
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                graphics.setStroke(basicStroke);
                Paint paint = (Paint)WCGraphicsPrismContext.this.state.getStrokeNoClone().getPaint();
                if (paint == null) {
                    paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                }
                graphics.setPaint(paint);
                graphics.drawRect(f, f2, f3, f4);
            }
        }.paint();
    }

    @Override
    public void strokePath(WCPath wCPath) {
        log.fine("strokePath");
        if (wCPath != null) {
            final BasicStroke basicStroke = this.state.getStrokeNoClone().getPlatformStroke();
            final DropShadow dropShadow = this.state.getShadowNoClone();
            final Path2D path2D = (Path2D)wCPath.getPlatformPath();
            if (basicStroke == null && dropShadow == null || !this.shouldRenderShape((Shape)path2D, dropShadow, basicStroke)) {
                return;
            }
            new Composite(){

                @Override
                void doPaint(Graphics graphics) {
                    if (dropShadow != null) {
                        NGPath nGPath = new NGPath();
                        nGPath.updateWithPath2d(path2D);
                        WCGraphicsPrismContext.this.render(graphics, (Effect)dropShadow, null, basicStroke, (NGNode)nGPath);
                    } else if (basicStroke != null) {
                        Paint paint = (Paint)WCGraphicsPrismContext.this.state.getStrokeNoClone().getPaint();
                        if (paint == null) {
                            paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                        }
                        graphics.setPaint(paint);
                        graphics.setStroke(basicStroke);
                        graphics.draw((Shape)path2D);
                    }
                }
            }.paint();
        }
    }

    @Override
    public void fillPath(final WCPath wCPath) {
        log.fine("fillPath");
        if (wCPath != null) {
            if (!this.shouldRenderShape((Shape)((WCPathImpl)wCPath).getPlatformPath(), this.state.getShadowNoClone(), null)) {
                return;
            }
            new Composite(){

                @Override
                void doPaint(Graphics graphics) {
                    Path2D path2D = (Path2D)wCPath.getPlatformPath();
                    Paint paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                    DropShadow dropShadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                    if (dropShadow != null) {
                        NGPath nGPath = new NGPath();
                        nGPath.updateWithPath2d(path2D);
                        WCGraphicsPrismContext.this.render(graphics, (Effect)dropShadow, paint, null, (NGNode)nGPath);
                    } else {
                        graphics.setPaint(paint);
                        graphics.fill((Shape)path2D);
                    }
                }
            }.paint();
        }
    }

    @Override
    public void setPerspectiveTransform(WCTransform wCTransform) {
        GeneralTransform3D generalTransform3D = new GeneralTransform3D().set(wCTransform.getMatrix());
        this.state.setPerspectiveTransform(generalTransform3D);
        this.resetCachedGraphics();
    }

    @Override
    public void setTransform(WCTransform wCTransform) {
        double[] dArray = wCTransform.getMatrix();
        Affine3D affine3D = new Affine3D((BaseTransform)new Affine2D(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]));
        if (this.state.getLayerNoClone() == null) {
            affine3D.preConcatenate(this.baseTransform);
        }
        this.state.setTransform(affine3D);
        this.resetCachedGraphics();
    }

    @Override
    public WCTransform getTransform() {
        Affine3D affine3D = this.state.getTransformNoClone();
        return new WCTransform(affine3D.getMxx(), affine3D.getMyx(), affine3D.getMxy(), affine3D.getMyy(), affine3D.getMxt(), affine3D.getMyt());
    }

    @Override
    public void concatTransform(WCTransform wCTransform) {
        double[] dArray = wCTransform.getMatrix();
        Affine3D affine3D = new Affine3D((BaseTransform)new Affine2D(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]));
        this.state.concatTransform(affine3D);
        this.resetCachedGraphics();
    }

    @Override
    public void flush() {
        if (!this.isValid()) {
            log.fine("WCGraphicsPrismContext::flush : GC is invalid");
            return;
        }
        this.flushAllLayers();
    }

    @Override
    public WCGradient createLinearGradient(WCPoint wCPoint, WCPoint wCPoint2) {
        return new WCLinearGradient(wCPoint, wCPoint2);
    }

    @Override
    public WCGradient createRadialGradient(WCPoint wCPoint, float f, WCPoint wCPoint2, float f2) {
        return new WCRadialGradient(wCPoint, f, wCPoint2, f2);
    }

    private static final class ContextState {
        private final WCStrokeImpl stroke = new WCStrokeImpl();
        private Rectangle clip;
        private Paint paint;
        private float alpha;
        private boolean textFill = true;
        private boolean textStroke = false;
        private boolean textClip = false;
        private boolean restorePoint = false;
        private DropShadow shadow;
        private Affine3D xform;
        private GeneralTransform3D perspectiveTransform;
        private Layer layer;
        private int compositeOperation;

        private ContextState() {
            this.clip = null;
            this.paint = Color.BLACK;
            this.stroke.setPaint(Color.BLACK);
            this.alpha = 1.0f;
            this.xform = new Affine3D();
            this.perspectiveTransform = new GeneralTransform3D();
            this.compositeOperation = 2;
        }

        private ContextState(ContextState contextState) {
            this.stroke.copyFrom(contextState.getStrokeNoClone());
            this.setPaint(contextState.getPaintNoClone());
            this.clip = contextState.getClipNoClone();
            if (this.clip != null) {
                this.clip = new Rectangle(this.clip);
            }
            this.xform = new Affine3D(contextState.getTransformNoClone());
            this.perspectiveTransform = new GeneralTransform3D().set(contextState.getPerspectiveTransformNoClone());
            this.setShadow(contextState.getShadowNoClone());
            this.setLayer(contextState.getLayerNoClone());
            this.setAlpha(contextState.getAlpha());
            this.setTextMode(contextState.isTextFill(), contextState.isTextStroke(), contextState.isTextClip());
            this.setCompositeOperation(contextState.getCompositeOperation());
        }

        protected ContextState clone() {
            return new ContextState(this);
        }

        private void apply(Graphics graphics) {
            graphics.setTransform((BaseTransform)this.getTransformNoClone());
            graphics.setPerspectiveTransform(this.getPerspectiveTransformNoClone());
            graphics.setClipRect(this.getClipNoClone());
            graphics.setExtraAlpha(this.getAlpha());
        }

        private int getCompositeOperation() {
            return this.compositeOperation;
        }

        private void setCompositeOperation(int n) {
            this.compositeOperation = n;
        }

        private WCStrokeImpl getStrokeNoClone() {
            return this.stroke;
        }

        private Paint getPaintNoClone() {
            return this.paint;
        }

        private void setPaint(Paint paint) {
            this.paint = paint;
        }

        private Rectangle getClipNoClone() {
            return this.clip;
        }

        private Layer getLayerNoClone() {
            return this.layer;
        }

        private void setLayer(Layer layer) {
            this.layer = layer;
        }

        private void setClip(Rectangle rectangle) {
            this.clip = rectangle;
        }

        private void clip(Rectangle rectangle) {
            if (null == this.clip) {
                this.clip = rectangle;
            } else {
                this.clip.intersectWith(rectangle);
            }
        }

        private void setAlpha(float f) {
            this.alpha = f;
        }

        private float getAlpha() {
            return this.alpha;
        }

        private void setTextMode(boolean bl, boolean bl2, boolean bl3) {
            this.textFill = bl;
            this.textStroke = bl2;
            this.textClip = bl3;
        }

        private boolean isTextFill() {
            return this.textFill;
        }

        private boolean isTextStroke() {
            return this.textStroke;
        }

        private boolean isTextClip() {
            return this.textClip;
        }

        private void markAsRestorePoint() {
            this.restorePoint = true;
        }

        private boolean isRestorePoint() {
            return this.restorePoint;
        }

        private void setShadow(DropShadow dropShadow) {
            this.shadow = dropShadow;
        }

        private DropShadow getShadowNoClone() {
            return this.shadow;
        }

        private Affine3D getTransformNoClone() {
            return this.xform;
        }

        private GeneralTransform3D getPerspectiveTransformNoClone() {
            return this.perspectiveTransform;
        }

        private void setTransform(Affine3D affine3D) {
            this.xform.setTransform((BaseTransform)affine3D);
        }

        private void setPerspectiveTransform(GeneralTransform3D generalTransform3D) {
            this.perspectiveTransform.set(generalTransform3D);
        }

        private void concatTransform(Affine3D affine3D) {
            this.xform.concatenate((BaseTransform)affine3D);
        }

        private void translate(double d, double d2) {
            this.xform.translate(d, d2);
        }

        private void scale(double d, double d2) {
            this.xform.scale(d, d2);
        }

        private void rotate(double d) {
            this.xform.rotate(d);
        }
    }

    public static enum Type {
        PRIMARY,
        DEDICATED;

    }

    private static abstract class Layer {
        FilterContext fctx;
        PrDrawable buffer;
        Graphics graphics;
        final Rectangle bounds;
        boolean permanent;

        Layer(Graphics graphics, Rectangle rectangle, boolean bl) {
            this.bounds = new Rectangle(rectangle);
            this.permanent = bl;
            int n = Math.max(rectangle.width, 1);
            int n2 = Math.max(rectangle.height, 1);
            this.fctx = WCGraphicsPrismContext.getFilterContext(graphics);
            if (bl) {
                ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
                if (resourceFactory != null && !resourceFactory.isDisposed()) {
                    RTTexture rTTexture = resourceFactory.createRTTexture(n, n2, Texture.WrapMode.CLAMP_NOT_NEEDED);
                    rTTexture.makePermanent();
                    this.buffer = ((PrRenderer)Renderer.getRenderer((FilterContext)this.fctx)).createDrawable(rTTexture);
                } else {
                    log.fine("Layer :: cannot construct RTT because device disposed or not ready");
                    this.fctx = null;
                    this.buffer = null;
                }
            } else {
                this.buffer = (PrDrawable)Effect.getCompatibleImage((FilterContext)this.fctx, (int)n, (int)n2);
            }
        }

        Graphics getGraphics() {
            if (this.graphics == null && this.buffer != null) {
                this.graphics = this.buffer.createGraphics();
            }
            return this.graphics;
        }

        abstract void init(Graphics var1);

        abstract void render(Graphics var1);

        private void dispose() {
            if (this.buffer != null) {
                if (this.permanent) {
                    this.buffer.flush();
                } else {
                    Effect.releaseCompatibleImage((FilterContext)this.fctx, (Filterable)this.buffer);
                }
                this.fctx = null;
                this.buffer = null;
            }
        }

        private double getX() {
            return this.bounds.x;
        }

        private double getY() {
            return this.bounds.y;
        }
    }

    private static final class ClipLayer
    extends Layer {
        private final WCPath normalizedToClipPath;
        private boolean srcover;

        private ClipLayer(Graphics graphics, Rectangle rectangle, WCPath wCPath, boolean bl) {
            super(graphics, rectangle, bl);
            this.normalizedToClipPath = wCPath;
            this.srcover = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void init(Graphics graphics) {
            RTTexture rTTexture = null;
            ReadbackGraphics readbackGraphics = null;
            try {
                readbackGraphics = (ReadbackGraphics)graphics;
                rTTexture = readbackGraphics.readBack(this.bounds);
                this.getGraphics().drawTexture((Texture)rTTexture, 0.0f, 0.0f, (float)this.bounds.width, (float)this.bounds.height);
            }
            finally {
                if (readbackGraphics != null && rTTexture != null) {
                    readbackGraphics.releaseReadBackBuffer(rTTexture);
                }
            }
            this.srcover = false;
        }

        @Override
        void render(Graphics graphics) {
            Path2D path2D = ((WCPathImpl)this.normalizedToClipPath).getPlatformPath();
            PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage((FilterContext)this.fctx, (int)this.bounds.width, (int)this.bounds.height);
            Graphics graphics2 = prDrawable.createGraphics();
            graphics2.setPaint((Paint)Color.BLACK);
            graphics2.fill((Shape)path2D);
            if (graphics instanceof MaskTextureGraphics && !(graphics instanceof PrinterGraphics)) {
                MaskTextureGraphics maskTextureGraphics = (MaskTextureGraphics)graphics;
                if (this.srcover) {
                    maskTextureGraphics.drawPixelsMasked((RTTexture)this.buffer.getTextureObject(), (RTTexture)prDrawable.getTextureObject(), this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, 0, 0, 0, 0);
                } else {
                    maskTextureGraphics.maskInterpolatePixels((RTTexture)this.buffer.getTextureObject(), (RTTexture)prDrawable.getTextureObject(), this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, 0, 0, 0, 0);
                }
            } else {
                Blend blend = new Blend(Blend.Mode.SRC_IN, (Effect)new PassThrough(prDrawable, this.bounds.width, this.bounds.height), (Effect)new PassThrough(this.buffer, this.bounds.width, this.bounds.height));
                Affine3D affine3D = new Affine3D(graphics.getTransformNoClone());
                graphics.setTransform(BaseTransform.IDENTITY_TRANSFORM);
                PrEffectHelper.render((Effect)blend, (Graphics)graphics, (float)this.bounds.x, (float)this.bounds.y, null);
                graphics.setTransform((BaseTransform)affine3D);
            }
            Effect.releaseCompatibleImage((FilterContext)this.fctx, (Filterable)prDrawable);
        }

        public String toString() {
            return String.format("ClipLayer[%d,%d + %dx%d, path %s]", this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, this.normalizedToClipPath);
        }
    }

    private final class TransparencyLayer
    extends Layer {
        private final float opacity;

        private TransparencyLayer(Graphics graphics, Rectangle rectangle, float f) {
            super(graphics, rectangle, false);
            this.opacity = f;
        }

        @Override
        void init(Graphics graphics) {
            WCGraphicsPrismContext.this.state.setCompositeOperation(2);
        }

        @Override
        void render(Graphics graphics) {
            new Composite(){

                @Override
                void doPaint(Graphics graphics) {
                    float f = graphics.getExtraAlpha();
                    graphics.setExtraAlpha(TransparencyLayer.this.opacity);
                    Affine3D affine3D = new Affine3D(graphics.getTransformNoClone());
                    graphics.setTransform(BaseTransform.IDENTITY_TRANSFORM);
                    graphics.drawTexture(TransparencyLayer.this.buffer.getTextureObject(), (float)TransparencyLayer.this.bounds.x, (float)TransparencyLayer.this.bounds.y, (float)TransparencyLayer.this.bounds.width, (float)TransparencyLayer.this.bounds.height);
                    graphics.setTransform((BaseTransform)affine3D);
                    graphics.setExtraAlpha(f);
                }
            }.paint(graphics);
        }

        public String toString() {
            return String.format("TransparencyLayer[%d,%d + %dx%d, opacity %.2f]", this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, Float.valueOf(this.opacity));
        }
    }

    private static final class PassThrough
    extends Effect {
        private final PrDrawable img;
        private final int width;
        private final int height;

        private PassThrough(PrDrawable prDrawable, int n, int n2) {
            this.img = prDrawable;
            this.width = n;
            this.height = n2;
        }

        public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
            this.img.lock();
            ImageData imageData = new ImageData(filterContext, (Filterable)this.img, new Rectangle((int)baseTransform.getMxt(), (int)baseTransform.getMyt(), this.width, this.height));
            imageData.setReusable(true);
            return imageData;
        }

        public RectBounds getBounds(BaseTransform baseTransform, Effect effect) {
            return null;
        }

        public Effect.AccelType getAccelType(FilterContext filterContext) {
            return Effect.AccelType.INTRINSIC;
        }

        public boolean reducesOpaquePixels() {
            return false;
        }

        public DirtyRegionContainer getDirtyRegions(Effect effect, DirtyRegionPool dirtyRegionPool) {
            return null;
        }
    }

    private abstract class Composite {
        private Composite() {
        }

        abstract void doPaint(Graphics var1);

        void paint() {
            this.paint(WCGraphicsPrismContext.this.getGraphics(true));
        }

        void paint(Graphics graphics) {
            if (graphics != null) {
                CompositeMode compositeMode = graphics.getCompositeMode();
                switch (WCGraphicsPrismContext.this.state.getCompositeOperation()) {
                    case 1: {
                        graphics.setCompositeMode(CompositeMode.SRC);
                        this.doPaint(graphics);
                        graphics.setCompositeMode(compositeMode);
                        break;
                    }
                    case 2: {
                        graphics.setCompositeMode(CompositeMode.SRC_OVER);
                        this.doPaint(graphics);
                        graphics.setCompositeMode(compositeMode);
                        break;
                    }
                    default: {
                        this.blend(graphics);
                    }
                }
                WCGraphicsPrismContext.this.isRootLayerValid = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void blend(Graphics graphics) {
            RTTexture rTTexture;
            ReadbackGraphics readbackGraphics;
            PrDrawable prDrawable;
            FilterContext filterContext;
            block11: {
                filterContext = WCGraphicsPrismContext.getFilterContext(graphics);
                prDrawable = null;
                PrDrawable prDrawable2 = null;
                readbackGraphics = null;
                rTTexture = null;
                Rectangle rectangle = WCGraphicsPrismContext.this.state.getClipNoClone();
                WCImage wCImage = WCGraphicsPrismContext.this.getImage();
                try {
                    Graphics graphics2;
                    if (wCImage != null && wCImage instanceof PrismImage) {
                        prDrawable = (PrDrawable)Effect.getCompatibleImage((FilterContext)filterContext, (int)rectangle.width, (int)rectangle.height);
                        graphics2 = prDrawable.createGraphics();
                        WCGraphicsPrismContext.this.state.apply(graphics2);
                        ((PrismImage)wCImage).draw(graphics2, 0, 0, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    } else {
                        readbackGraphics = (ReadbackGraphics)graphics;
                        rTTexture = readbackGraphics.readBack(rectangle);
                        prDrawable = PrDrawable.create((FilterContext)filterContext, (RTTexture)rTTexture);
                    }
                    prDrawable2 = (PrDrawable)Effect.getCompatibleImage((FilterContext)filterContext, (int)rectangle.width, (int)rectangle.height);
                    graphics2 = prDrawable2.createGraphics();
                    WCGraphicsPrismContext.this.state.apply(graphics2);
                    this.doPaint(graphics2);
                    graphics.clear();
                    PrEffectHelper.render((Effect)this.createEffect(prDrawable, prDrawable2, rectangle.width, rectangle.height), (Graphics)graphics, (float)0.0f, (float)0.0f, null);
                    if (prDrawable2 == null) break block11;
                }
                catch (Throwable throwable) {
                    if (prDrawable2 != null) {
                        Effect.releaseCompatibleImage((FilterContext)filterContext, prDrawable2);
                    }
                    if (prDrawable != null) {
                        if (readbackGraphics != null && rTTexture != null) {
                            readbackGraphics.releaseReadBackBuffer(rTTexture);
                        } else {
                            Effect.releaseCompatibleImage((FilterContext)filterContext, prDrawable);
                        }
                    }
                    throw throwable;
                }
                Effect.releaseCompatibleImage((FilterContext)filterContext, (Filterable)prDrawable2);
            }
            if (prDrawable != null) {
                if (readbackGraphics != null && rTTexture != null) {
                    readbackGraphics.releaseReadBackBuffer(rTTexture);
                } else {
                    Effect.releaseCompatibleImage((FilterContext)filterContext, (Filterable)prDrawable);
                }
            }
        }

        private Effect createBlend(Blend.Mode mode, PrDrawable prDrawable, PrDrawable prDrawable2, int n, int n2) {
            return new Blend(mode, (Effect)new PassThrough(prDrawable, n, n2), (Effect)new PassThrough(prDrawable2, n, n2));
        }

        private Effect createEffect(PrDrawable prDrawable, PrDrawable prDrawable2, int n, int n2) {
            switch (WCGraphicsPrismContext.this.state.getCompositeOperation()) {
                case 0: 
                case 10: {
                    return new Blend(Blend.Mode.SRC_OVER, this.createBlend(Blend.Mode.SRC_OUT, prDrawable, prDrawable2, n, n2), this.createBlend(Blend.Mode.SRC_OUT, prDrawable2, prDrawable, n, n2));
                }
                case 3: {
                    return this.createBlend(Blend.Mode.SRC_IN, prDrawable, prDrawable2, n, n2);
                }
                case 4: {
                    return this.createBlend(Blend.Mode.SRC_OUT, prDrawable, prDrawable2, n, n2);
                }
                case 5: {
                    return this.createBlend(Blend.Mode.SRC_ATOP, prDrawable, prDrawable2, n, n2);
                }
                case 6: {
                    return this.createBlend(Blend.Mode.SRC_OVER, prDrawable2, prDrawable, n, n2);
                }
                case 7: {
                    return this.createBlend(Blend.Mode.SRC_IN, prDrawable2, prDrawable, n, n2);
                }
                case 8: {
                    return this.createBlend(Blend.Mode.SRC_OUT, prDrawable2, prDrawable, n, n2);
                }
                case 9: {
                    return this.createBlend(Blend.Mode.SRC_ATOP, prDrawable2, prDrawable, n, n2);
                }
                case 12: {
                    return this.createBlend(Blend.Mode.ADD, prDrawable, prDrawable2, n, n2);
                }
            }
            return this.createBlend(Blend.Mode.SRC_OVER, prDrawable, prDrawable2, n, n2);
        }
    }
}

