/*
 * Decompiled with CFR 0.152.
 */
package org.openkoreantext.processor.qa;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openkoreantext.processor.OpenKoreanTextProcessor$;
import org.openkoreantext.processor.qa.BatchTokenizeTweets;
import org.openkoreantext.processor.tokenizer.KoreanTokenizer;
import org.openkoreantext.processor.util.KoreanPos$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class BatchTokenizeTweets$ {
    public static BatchTokenizeTweets$ MODULE$;
    private final Logger LOG;
    private final boolean VERBOSE;
    private final Set<Enumeration.Value> NON_NOUNS;

    static {
        new BatchTokenizeTweets$();
    }

    private Logger LOG() {
        return this.LOG;
    }

    private boolean VERBOSE() {
        return this.VERBOSE;
    }

    private Set<Enumeration.Value> NON_NOUNS() {
        return this.NON_NOUNS;
    }

    public void main(String[] args) {
        if (args.length != 1) {
            Predef$.MODULE$.println((Object)"The first arg should be an input file of Korean tweets.");
            return;
        }
        List parseTimesAll = (List)Source$.MODULE$.fromFile(args[0], Codec$.MODULE$.fallbackSystemCodec()).getLines().foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            List l = (List)tuple2._1();
            String line = (String)tuple2._2();
            if (l == null) throw new MatchError((Object)tuple2);
            List list = l;
            if (line == null) throw new MatchError((Object)tuple2);
            String string = line;
            long t0 = System.currentTimeMillis();
            Seq<KoreanTokenizer.KoreanToken> parsed = OpenKoreanTextProcessor$.MODULE$.tokenize(string);
            long t1 = System.currentTimeMillis();
            if (this.VERBOSE()) {
                Predef$.MODULE$.println((Object)((TraversableOnce)parsed.map((Function1 & Serializable & scala.Serializable)t -> t.text() + "/" + t.pos(), Seq$.MODULE$.canBuildFrom())).mkString(" "));
            }
            BatchTokenizeTweets.ParseTime parseTime = new BatchTokenizeTweets.ParseTime(t1 - t0, string.trim());
            return list.$colon$colon((Object)parseTime);
        });
        BatchTokenizeTweets.ParseTime loadingTime = (BatchTokenizeTweets.ParseTime)parseTimesAll.last();
        this.LOG().log(Level.INFO, new StringOps(Predef$.MODULE$.augmentString("The first one \"%s\" took %d ms including the loading time.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{loadingTime.chunk(), BoxesRunTime.boxToLong((long)loadingTime.time())})));
        List parseTimes = (List)parseTimesAll.init();
        double averageTweetLength = (double)BoxesRunTime.unboxToInt((Object)((TraversableOnce)parseTimes.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)BatchTokenizeTweets$.$anonfun$main$3(x$2)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (double)parseTimes.size();
        double averageTime = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)parseTimes.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.time()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)parseTimes.size();
        BatchTokenizeTweets.ParseTime maxItem = (BatchTokenizeTweets.ParseTime)parseTimes.maxBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.time()), (Ordering)Ordering.Long$.MODULE$);
        this.LOG().log(Level.INFO, new StringOps(Predef$.MODULE$.augmentString("Parsed %d items. \n       Total time: %d s \n       Average tweet length: %.2f chars \n       Average time per tweet: %.2f ms \n       Max time: %d ms, %s\n       Parsed: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)parseTimes.size()), BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)((TraversableOnce)parseTimes.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.time()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / 1000L)), BoxesRunTime.boxToDouble((double)averageTweetLength), BoxesRunTime.boxToDouble((double)averageTime), BoxesRunTime.boxToLong((long)maxItem.time()), maxItem.chunk(), ((TraversableOnce)OpenKoreanTextProcessor$.MODULE$.tokenize(maxItem.chunk()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            KoreanTokenizer.KoreanToken koreanToken = x0$2;
            String string = koreanToken.unknown() ? koreanToken.text().toString() + koreanToken.pos() + "*" : koreanToken.text() + koreanToken.pos().toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(" ")})));
    }

    private String parseToString(Seq<KoreanTokenizer.KoreanToken> parsed) {
        return ((TraversableOnce)parsed.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            KoreanTokenizer.KoreanToken koreanToken = x0$3;
            String string = koreanToken.unknown() ? koreanToken.text().toString() + koreanToken.pos() + "*" : koreanToken.text() + koreanToken.pos().toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(" ");
    }

    public static final /* synthetic */ int $anonfun$main$3(BatchTokenizeTweets.ParseTime x$2) {
        return x$2.chunk().length();
    }

    private BatchTokenizeTweets$() {
        MODULE$ = this;
        this.LOG = Logger.getLogger(this.getClass().getSimpleName());
        this.VERBOSE = true;
        this.NON_NOUNS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{KoreanPos$.MODULE$.Adjective(), KoreanPos$.MODULE$.Adverb(), KoreanPos$.MODULE$.Verb()}));
    }
}

