/*
 * Decompiled with CFR 0.152.
 */
package org.openl.info;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.openl.info.OpenLLogger;

final class JndiLogger
extends OpenLLogger {
    JndiLogger() {
    }

    @Override
    protected String getName() {
        return "jndi";
    }

    @Override
    protected void discover() throws Exception {
        this.log("JNDI Context:");
        try {
            InitialContext ctx = new InitialContext();
            String path = ctx.getNameInNamespace();
            this.toMap(ctx, path);
        }
        catch (NoInitialContextException ex) {
            this.log("  ##### No initial JNDI context found.");
        }
    }

    private void toMap(Context ctx, String path) throws NamingException {
        NamingEnumeration<NameClassPair> list = ctx.list(path);
        if (!list.hasMoreElements()) {
            this.log("  {} = [Empty] {}", (Object)path, ctx.lookup(path));
            return;
        }
        while (list.hasMoreElements()) {
            NameClassPair next = list.next();
            String name = next.getName();
            String jndiPath = path + name;
            try {
                Object value = ctx.lookup(jndiPath);
                if (value instanceof Context) {
                    this.toMap(ctx, jndiPath + "/");
                    continue;
                }
                this.log("  {} = {}", (Object)jndiPath, value);
            }
            catch (Exception t) {
                this.log("  {} ! {}", jndiPath, t.toString());
            }
        }
    }
}

