/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.openl.rules.util.dates.DateInterval;

public class DateTool {
    public static final int MONTHS_IN_YEAR = 12;
    public static final int QUARTERS_IN_YEAR = 4;
    public static final int MONTHS_IN_QUARTER = 3;
    public static final int SECONDS_IN_DAY = 86400;
    public static final int MILLISECONDS_IN_DAY = 86400000;

    public static Integer absMonth(Date d) {
        if (d == null) {
            return null;
        }
        return DateTool.getYear(d) * 12 + DateTool.getMonth(d);
    }

    public static Integer absQuarter(Date d) {
        if (d == null) {
            return null;
        }
        return DateTool.getYear(d) * 4 + DateTool.getQuarter(d);
    }

    public static Integer dayDiff(Date endDate, Date startDate) {
        return DateTool.castToInteger(DateInterval.between((Date)startDate, (Date)endDate).toDays());
    }

    public static Integer dayOfWeek(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(7);
    }

    public static Integer dayOfMonth(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(5);
    }

    public static Integer dayOfYear(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(6);
    }

    public static Integer weekOfMonth(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(4);
    }

    public static Integer weekOfYear(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(3);
    }

    public static Date firstDateOfQuarter(int absQuarter) {
        Calendar c = Calendar.getInstance();
        c.set(14, 0);
        c.set(absQuarter / 4, absQuarter % 4 * 3, 1, 0, 0, 0);
        return c.getTime();
    }

    public static Date lastDateOfQuarter(int absQuarter) {
        Calendar c = Calendar.getInstance();
        c.set(14, 0);
        c.set(absQuarter / 4, absQuarter % 4 * 3 + 2, 1, 0, 0, 0);
        int lastDay = DateTool.getLastDayOfMonth(c.getTime());
        c.set(5, lastDay);
        return c.getTime();
    }

    public static Integer lastDayOfMonth(Date d) {
        if (d == null) {
            return null;
        }
        return DateTool.getLastDayOfMonth(d);
    }

    private static int getLastDayOfMonth(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.getActualMaximum(5);
    }

    public static Integer monthDiff(Date endDate, Date startDate) {
        return DateTool.castToInteger(DateInterval.between((Date)startDate, (Date)endDate).toMonths(DateInterval.Scale.INT));
    }

    public static Integer yearDiff(Date endDate, Date startDate) {
        return DateTool.castToInteger(DateInterval.between((Date)startDate, (Date)endDate).toYears(DateInterval.Scale.INT));
    }

    public static Integer weekDiff(Date endDate, Date startDate) {
        return DateTool.castToInteger(DateInterval.between((Date)startDate, (Date)endDate).toWeeks(DateInterval.Scale.FRAC));
    }

    public static Integer quarter(Date d) {
        if (d == null) {
            return null;
        }
        return DateTool.getQuarter(d);
    }

    private static int getQuarter(Date d) {
        return DateTool.getMonth(d) / 3;
    }

    public static Integer second(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(13);
    }

    public static Integer minute(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(12);
    }

    public static Integer hour(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(10);
    }

    public static Integer hourOfDay(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(11);
    }

    public static Integer month(Date d) {
        if (d == null) {
            return null;
        }
        return DateTool.getMonth(d) + 1;
    }

    private static int getMonth(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(2);
    }

    public static Integer year(Date d) {
        if (d == null) {
            return null;
        }
        return DateTool.getYear(d);
    }

    private static int getYear(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(1);
    }

    public static String amPm(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        if (c.get(9) == 0) {
            return "AM";
        }
        return "PM";
    }

    public static String dateToString(Date date, String dateFormat) {
        if (date == null) {
            return null;
        }
        DateFormat df = dateFormat == null ? DateFormat.getDateInstance(3) : new SimpleDateFormat(dateFormat);
        return df.format(date);
    }

    public static String dateToString(Date date) {
        return DateTool.dateToString(date, null);
    }

    private static Integer castToInteger(Double d) {
        return d == null ? null : Integer.valueOf(d.intValue());
    }
}

