/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class PropertiesUtils {
    private PropertiesUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void load(Reader input, BiConsumer<? super String, ? super String> result) throws IOException {
        StringBuilder str = new StringBuilder();
        String key = null;
        boolean newLine = true;
        boolean skipWhitespaces = true;
        boolean skipLine = false;
        boolean backSlash = false;
        boolean ignoreLF = false;
        int lastNonWhitespace = 0;
        block8: while (true) {
            int ch = input.read();
            if (ignoreLF && ch == 10) {
                ignoreLF = false;
                continue;
            }
            boolean bl = ignoreLF = ch == 13;
            if (!backSlash && (ch == 13 || ch == 10) || ch == -1) {
                String value = str.substring(0, lastNonWhitespace);
                if (key != null) {
                    result.accept(key, value);
                    key = null;
                } else if (lastNonWhitespace > 0) {
                    result.accept(value, null);
                }
                newLine = true;
                skipWhitespaces = true;
                lastNonWhitespace = 0;
                str.setLength(0);
                if (ch != -1) continue;
                return;
            }
            if (newLine && (ch == 35 || ch == 33)) {
                skipLine = true;
                newLine = false;
                continue;
            }
            if (skipWhitespaces && Character.isWhitespace(ch)) continue;
            skipWhitespaces = false;
            if (skipLine && !newLine) continue;
            skipLine = false;
            newLine = false;
            if (backSlash) {
                backSlash = false;
                switch (ch) {
                    case 10: 
                    case 13: {
                        skipWhitespaces = true;
                        continue block8;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        break;
                    }
                    case 117: {
                        char[] hex = new char[4];
                        ch = input.read(hex);
                        if (ch < 4) {
                            throw new EOFException("End of the data is reached unexpectedly");
                        }
                        ch = Integer.parseInt(String.valueOf(hex), 16);
                        break;
                    }
                }
                str.append((char)ch);
                lastNonWhitespace = str.length();
                continue;
            }
            if (ch == 92) {
                backSlash = true;
                continue;
            }
            if (key == null && (ch == 58 || ch == 61)) {
                skipWhitespaces = true;
                key = str.substring(0, lastNonWhitespace);
                lastNonWhitespace = 0;
                str.setLength(0);
                continue;
            }
            str.append((char)ch);
            if (Character.isWhitespace(ch)) continue;
            lastNonWhitespace = str.length();
        }
    }

    public static void load(InputStream input, BiConsumer<? super String, ? super String> result) throws IOException {
        PropertiesUtils.load(new InputStreamReader(input, StandardCharsets.UTF_8), result);
    }

    public static void load(Path path, BiConsumer<? super String, ? super String> result) throws IOException {
        Objects.requireNonNull(path);
        try (BufferedReader reader = Files.newBufferedReader(path);){
            PropertiesUtils.load(reader, result);
        }
    }

    public static void load(URL url, BiConsumer<? super String, ? super String> result) throws IOException {
        Objects.requireNonNull(url);
        try (InputStream reader = url.openStream();){
            PropertiesUtils.load(reader, result);
        }
    }

    public static <T extends Map.Entry<?, ?>> void store(Writer output, Iterable<T> props) throws IOException {
        for (Map.Entry entry : props) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k == null) {
                if (v != null) {
                    output.append('#').write(v.toString());
                }
            } else {
                String key = PropertiesUtils.escape(k.toString()).replace(":", "\\:").replace("=", "\\=").replaceFirst("^#", "\\\\#");
                String value = PropertiesUtils.escape(v.toString());
                output.append(key).append('=').write(value);
            }
            output.write(10);
        }
        output.flush();
    }

    public static <T extends Map.Entry<?, ?>> void store(OutputStream output, Iterable<T> props) throws IOException {
        PropertiesUtils.store(new OutputStreamWriter(output, StandardCharsets.UTF_8), props);
    }

    public static <T extends Map.Entry<?, ?>> void store(Path path, Iterable<T> props) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            PropertiesUtils.store(writer, props);
        }
    }

    private static String escape(String str) {
        return str.replace("\\", "\\\\").replace("\f", "\\f").replace("\t", "\\t").replace("\r", "\\r").replace("\n", "\\n");
    }
}

