/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import org.openl.util.IOUtils;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 0x800000;

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static void copy(File src, File dest) throws IOException {
        String destPath;
        if (!src.exists()) {
            throw new FileNotFoundException(String.format("Source '%s' does not exist", src));
        }
        String srcPath = src.getCanonicalPath();
        if (srcPath.equals(destPath = dest.getCanonicalPath())) {
            throw new IOException(String.format("Source '%s' and destination '%s' are the same", src, dest));
        }
        if (src.isDirectory()) {
            Collection<String> looped = FileUtils.getLoopedDirectories(src, dest);
            FileUtils.doCopyDirectory(src, dest, looped);
        } else {
            if (destPath.startsWith(srcPath)) {
                throw new IOException(String.format("Destination '%s' has the same path of the source '%s'", dest, src));
            }
            File destFile = dest;
            if (dest.isDirectory()) {
                destFile = new File(dest, src.getName());
            } else {
                File parentFile = dest.getParentFile();
                if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
                    throw new IOException(String.format("Destination '%s' directory cannot be created", parentFile));
                }
            }
            FileUtils.doCopyFile(src, destFile);
        }
    }

    private static Collection<String> getLoopedDirectories(File src, File dest) throws IOException {
        if (!dest.getCanonicalPath().startsWith(src.getCanonicalPath())) {
            return null;
        }
        ArrayList<String> looped = null;
        File[] srcFiles = src.listFiles();
        if (srcFiles != null && srcFiles.length > 0) {
            looped = new ArrayList<String>(srcFiles.length + 1);
            for (File srcFile : srcFiles) {
                File copiedFile = new File(dest, srcFile.getName());
                if (!srcFile.isDirectory()) continue;
                looped.add(copiedFile.getCanonicalPath());
            }
            if (!dest.exists()) {
                looped.add(dest.getCanonicalPath());
            }
        }
        return looped;
    }

    private static void doCopyDirectory(File srcDir, File destDir, Collection<String> excluded) throws IOException {
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException(String.format("Destination '%s' exists but is not a directory", destDir));
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException(String.format("Destination '%s' directory cannot be created", destDir));
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (excluded != null && excluded.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                FileUtils.doCopyDirectory(srcFile, dstFile, excluded);
                continue;
            }
            FileUtils.doCopyFile(srcFile, dstFile);
        }
        if (!destDir.setLastModified(srcDir.lastModified())) {
            LoggerFactory.getLogger(FileUtils.class).warn("Failed to set modified time to file '{}'.", (Object)destDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException(String.format("Destination '%s' exists but is a directory", destFile));
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, 0x800000L)) {
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            IOUtils.closeQuietly(fos);
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly(output);
        IOUtils.closeQuietly(fos);
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(fis);
        if (srcFile.length() != destFile.length()) {
            throw new IOException(String.format("Failed to copy full contents from '%s' to '%s'", srcFile, destFile));
        }
        if (!destFile.setLastModified(srcFile.lastModified())) {
            LoggerFactory.getLogger(FileUtils.class).warn("Failed to set modified time to file '{}'.", (Object)destFile);
        }
    }

    public static void move(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(String.format("Source '%s' does not exist", src));
        }
        if (dest.exists()) {
            throw new IOException(String.format("Destination '%s' already exists", dest));
        }
        boolean rename = src.renameTo(dest);
        if (!rename) {
            if (src.isDirectory() && dest.getCanonicalPath().startsWith(src.getCanonicalPath())) {
                throw new IOException(String.format("Cannot move directory '%s' to a subdirectory of itself '%s'.", src, dest));
            }
            FileUtils.copy(src, dest);
            FileUtils.delete(src);
            if (src.exists()) {
                throw new IOException(String.format("Failed to delete original directory or file '%s' after copy to '%s'", src, dest));
            }
        }
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                throw new IOException("Failed to list contents of directory: " + file);
            }
            IOException exception = null;
            for (File fl : files) {
                try {
                    FileUtils.delete(fl);
                }
                catch (IOException ioe) {
                    exception = ioe;
                }
            }
            if (null != exception) {
                throw exception;
            }
            if (!file.delete()) {
                throw new IOException("Unable to delete directory: " + file);
            }
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                throw new IOException("Unable to delete file: " + file);
            }
        }
    }

    public static void delete(Path root) throws IOException {
        if (!Files.exists(root, new LinkOption[0])) {
            throw new FileNotFoundException("Path does not exist: " + root);
        }
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileUtils.delete0(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileUtils.delete0(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void delete0(Path path) throws IOException {
        File toDelete = path.toFile();
        if (!toDelete.delete()) {
            throw new IOException("Failed to delete: " + path);
        }
    }

    public static void deleteQuietly(File file) {
        if (file == null) {
            return;
        }
        try {
            FileUtils.delete(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteQuietly(Path path) {
        if (path == null) {
            return;
        }
        try {
            FileUtils.delete(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int sep = FileUtils.getSeparatorIndex(filename);
        return filename.substring(sep + 1);
    }

    public static String getBaseName(String filename) {
        int sep;
        if (filename == null) {
            return null;
        }
        int dot = filename.lastIndexOf(46);
        if (dot > (sep = FileUtils.getSeparatorIndex(filename))) {
            return filename.substring(sep + 1, dot);
        }
        return filename.substring(sep + 1);
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int dot = FileUtils.getExtensionIndex(filename);
        if (dot == -1) {
            return "";
        }
        return filename.substring(dot + 1);
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int dot = FileUtils.getExtensionIndex(filename);
        if (dot == -1) {
            return filename;
        }
        return filename.substring(0, dot);
    }

    private static int getSeparatorIndex(String filename) {
        int winSep = filename.lastIndexOf(92);
        int unixSep = filename.lastIndexOf(47);
        return Math.max(winSep, unixSep);
    }

    private static int getExtensionIndex(String filename) {
        int dot = filename.lastIndexOf(46);
        if (dot == -1) {
            return -1;
        }
        int sep = FileUtils.getSeparatorIndex(filename);
        if (dot > sep) {
            return dot;
        }
        return -1;
    }
}

