/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import org.openl.util.ZipArchiver;

public final class ProjectPackager
implements FileVisitor<Path> {
    private static final List<String> systems = Arrays.asList("rules.xml", "rules-deploy.xml");
    private final Path dir;
    private final ZipArchiver arch;
    private boolean emptyDir;

    private ProjectPackager(Path dir, ZipArchiver arch) {
        this.dir = dir;
        this.arch = arch;
    }

    public static void addOpenLProject(File sourceDir, String[] includes, ZipArchiver arch) throws IOException {
        Path path = sourceDir.toPath();
        ProjectPackager.resolveSystemFiles(path, arch);
        for (String file : includes) {
            if (systems.contains(file)) continue;
            arch.addEntry(path.resolve(file), file);
        }
    }

    public static void addOpenLProject(File sourceDir, ZipArchiver arch) throws IOException {
        Path path = sourceDir.toPath();
        ProjectPackager.resolveSystemFiles(path, arch);
        Files.walkFileTree(path, new ProjectPackager(path, arch));
    }

    private static void resolveSystemFiles(Path sourceDir, ZipArchiver arch) throws IOException {
        for (String item : systems) {
            arch.addEntry(sourceDir.resolve(item), item);
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        this.emptyDir = false;
        String relativePath = this.toRelative(file);
        if (!systems.contains(relativePath)) {
            this.arch.addEntry(file, relativePath);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
        this.emptyDir = true;
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path file, IOException exc) throws IOException {
        if (this.emptyDir) {
            this.emptyDir = false;
            String relativePath = this.toRelative(file);
            this.arch.addEntry(file, relativePath);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        throw exc;
    }

    private String toRelative(Path file) {
        return this.dir.relativize(file).toString();
    }
}

