/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.print;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openl.util.print.NicePrinter;
import org.openl.util.print.NicePrinterAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanNicePrinterAdaptor
extends NicePrinterAdaptor {
    private static final Logger LOG = LoggerFactory.getLogger(BeanNicePrinterAdaptor.class);
    private static final Object[] EMPTY = new Object[0];

    @Override
    public void printObject(Object obj, int newID, NicePrinter printer) {
        if (BeanNicePrinterAdaptor.isToStringSpecified(obj.getClass())) {
            super.printObject(obj, newID, printer);
        } else {
            this.printReference(obj, newID, printer);
            Map<String, Object> fieldMap = BeanNicePrinterAdaptor.getFieldMap(obj);
            this.printMap(fieldMap, null, printer);
        }
    }

    private static Map<String, Object> getFieldMap(Object obj) {
        PropertyDescriptor[] propertyDescriptors;
        try {
            propertyDescriptors = Introspector.getBeanInfo(obj.getClass()).getPropertyDescriptors();
        }
        catch (Exception e) {
            LOG.debug("Ignored error: ", (Throwable)e);
            return Collections.emptyMap();
        }
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            try {
                String propertyName = descriptor.getDisplayName();
                if ("class".endsWith(propertyName)) continue;
                Object propertyValue = descriptor.getReadMethod().invoke(obj, EMPTY);
                fieldMap.put(propertyName, propertyValue);
            }
            catch (Exception e) {
                LOG.debug("Ignored error: ", (Throwable)e);
            }
        }
        return fieldMap;
    }

    private static boolean isToStringSpecified(Class<?> clazz) {
        try {
            return clazz.getMethod("toString", new Class[0]).getDeclaringClass() != Object.class;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

