/* JGrammar.java */
/* Generated By:JavaCC: Do not edit this line. JGrammar.java */
package org.openl.grammar.jgrammar;

public class JGrammar extends org.openl.grammar.JavaCC30Grammar implements JGrammarConstants {

    public JGrammar() {
        this(new java.io.StringReader(""));
    }

    protected org.openl.util.text.IPosition begin(Token t) {
        return pos(t.beginLine, t.beginColumn);
    }

    protected org.openl.util.text.IPosition end(Token t) {
        return pos(t.endLine, t.endColumn);
    }

    protected org.openl.util.text.TextInterval pos(Token t) {
        return t == null ? null : new org.openl.util.text.TextInterval(begin(t), end(t));
    }

    protected org.openl.util.text.TextInterval pos(Token t1, Token t2) {
        return new org.openl.util.text.TextInterval(begin(t1), end(t2));
    }

    protected org.openl.util.text.TextInterval pos(String lexError, Token t, StringBuffer resMessage) {
        String prefix = "Lexical error at line ";

        if (!lexError.startsWith(prefix)) {
            resMessage.append(lexError);
            return pos(t);
        }

        lexError = lexError.substring(prefix.length());

        int i = 0;
        int line = 0;
        int col = 0;

        while (Character.isDigit(lexError.charAt(i))) {
            line = line * 10 + lexError.charAt(i) - '0';
            ++i;
        }

        String prefix2 = ", column ";
        i += prefix2.length();

        while (Character.isDigit(lexError.charAt(i))) {
            col = col * 10 + lexError.charAt(i) - '0';
            ++i;
        }

        resMessage.append(lexError.substring(i + 2));

        return new org.openl.util.text.TextInterval(pos(line, col), pos(line, col));

    }

    @Override
    public void parseTopNode(String type) {
        try {
            if (type.equals("method.body")) {
                parseTopNodeInternal();
            } else if (type.equals("method.header")) {
                MethodHeader();
            } else if (type.equals("module")) {
                parseModuleInternal();
            } else if (type.equals("type")) {
                Type();
            }

        } catch (ParseException pe) {
            // pe.printStackTrace();
            // throw pe;
            syntaxBuilder.addError(new org.openl.syntax.exception.SyntaxNodeException(pe.getMessage(),
                null,
                pos(pe.currentToken),
                syntaxBuilder.getModule()));
        } catch (TokenMgrError err) {
            StringBuffer buf = new StringBuffer();
            org.openl.util.text.TextInterval loc = pos(err.getMessage(), token, buf);

            syntaxBuilder.addError(new org.openl.syntax.exception.SyntaxNodeException(buf.toString(),
                null,
                loc,
                syntaxBuilder.getModule()));
        } catch (Exception e) {
            syntaxBuilder.addError(
                new org.openl.syntax.exception.SyntaxNodeException("", e, pos(token), syntaxBuilder.getModule()));
        } catch (Throwable t) {
            syntaxBuilder.addError(
                new org.openl.syntax.exception.SyntaxNodeException("", t, pos(token), syntaxBuilder.getModule()));
        }
    }

    /*
     * Expression syntax follows.
     */
    final public void Expression() throws ParseException {
        Token x;
        String func = null;
        ConditionalExpression();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case ASSIGN:
            case PLUSASSIGN:
            case MINUSASSIGN:
            case STARASSIGN:
            case SLASHASSIGN:
            case ANDASSIGN:
            case ORASSIGN:
            case XORASSIGN:
            case REMASSIGN: {
                switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                    case ASSIGN: {
                        x = jj_consume_token(ASSIGN);
                        func = "op.assign";
                        break;
                    }
                    case PLUSASSIGN: {
                        x = jj_consume_token(PLUSASSIGN);
                        func = "op.assign.add";
                        break;
                    }
                    case MINUSASSIGN: {
                        x = jj_consume_token(MINUSASSIGN);
                        func = "op.assign.subtract";
                        break;
                    }
                    case STARASSIGN: {
                        x = jj_consume_token(STARASSIGN);
                        func = "op.assign.multiply";
                        break;
                    }
                    case SLASHASSIGN: {
                        x = jj_consume_token(SLASHASSIGN);
                        func = "op.assign.divide";
                        break;
                    }
                    case ANDASSIGN: {
                        x = jj_consume_token(ANDASSIGN);
                        func = "op.assign.bitand";
                        break;
                    }
                    case ORASSIGN: {
                        x = jj_consume_token(ORASSIGN);
                        func = "op.assign.bitor";
                        break;
                    }
                    case XORASSIGN: {
                        x = jj_consume_token(XORASSIGN);
                        func = "op.assign.bitnot";
                        break;
                    }
                    case REMASSIGN: {
                        x = jj_consume_token(REMASSIGN);
                        func = "op.assign.rem";
                        break;
                    }
                    default:
                        jj_la1[0] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                Expression();
                syntaxBuilder.bop(func, pos(x));
                break;
            }
            default:
                jj_la1[1] = jj_gen;
                ;
        }
    }

    final public void ConditionalExpression() throws ParseException {
        Token x;
        ConditionalImplExpression();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case HOOK: {
                x = jj_consume_token(HOOK);
                ConditionalExpression();
                jj_consume_token(COLON);
                ConditionalExpression();
                syntaxBuilder.nop("op.conditional.qmark", pos(x), 3);
                break;
            }
            default:
                jj_la1[2] = jj_gen;
                ;
        }
    }

    final public void ConditionalImplExpression() throws ParseException {
        Token x;
        ConditionalOrExpression();
        label_1: while (true) {
            if (jj_2_1(2147483647)) {

            } else {
                break label_1;
            }
            x = jj_consume_token(IMPL);
            ConditionalOrExpression();
            syntaxBuilder.bop("op.binary.impl", pos(x));
        }
    }

    final public void ConditionalOrExpression() throws ParseException {
        Token x;
        ConditionalXorExpression();
        label_2: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case SC_OR: {

                    break;
                }
                default:
                    jj_la1[3] = jj_gen;
                    break label_2;
            }
            x = jj_consume_token(SC_OR);
            ConditionalXorExpression();
            syntaxBuilder.bop("op.binary.or", pos(x));
        }
    }

    final public void ConditionalXorExpression() throws ParseException {
        Token x;
        ConditionalAndExpression();
        label_3: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case XOR: {

                    break;
                }
                default:
                    jj_la1[4] = jj_gen;
                    break label_3;
            }
            x = jj_consume_token(XOR);
            ConditionalAndExpression();
            syntaxBuilder.bop("op.binary.xor", pos(x));
        }
    }

    final public void ConditionalAndExpression() throws ParseException {
        Token x;
        EqualityExpression();
        label_4: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case SC_AND: {

                    break;
                }
                default:
                    jj_la1[5] = jj_gen;
                    break label_4;
            }
            x = jj_consume_token(SC_AND);
            EqualityExpression();
            syntaxBuilder.bop("op.binary.and", pos(x));
        }
    }

    final public void EqualityExpression() throws ParseException {
        Token x;
        String func = null;
        RelationalExpression();
        label_5: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case EQ:
                case NE: {

                    break;
                }
                default:
                    jj_la1[6] = jj_gen;
                    break label_5;
            }
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case EQ: {
                    x = jj_consume_token(EQ);
                    func = "eq";
                    break;
                }
                case NE: {
                    x = jj_consume_token(NE);
                    func = "ne";
                    break;
                }
                default:
                    jj_la1[7] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
            RelationalExpression();
            syntaxBuilder.bop("op.binary." + func, pos(x));
        }
    }

    final public void RelationalExpression() throws ParseException {
        Token x;
        String func = null;
        AdditiveExpression();
        label_6: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case GT:
                case LT:
                case LE:
                case GE: {

                    break;
                }
                default:
                    jj_la1[8] = jj_gen;
                    break label_6;
            }
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case LT: {
                    x = jj_consume_token(LT);
                    func = "lt";
                    break;
                }
                case GT: {
                    x = jj_consume_token(GT);
                    func = "gt";
                    break;
                }
                case LE: {
                    x = jj_consume_token(LE);
                    func = "le";
                    break;
                }
                case GE: {
                    x = jj_consume_token(GE);
                    func = "ge";
                    break;
                }
                default:
                    jj_la1[9] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
            AdditiveExpression();
            {
                syntaxBuilder.bop("op.binary." + func, pos(x));
            }
        }
    }

    final public void AdditiveExpression() throws ParseException {
        Token x;
        String func = null;
        MultiplicativeExpression();
        label_7: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case PLUS:
                case MINUS: {

                    break;
                }
                default:
                    jj_la1[10] = jj_gen;
                    break label_7;
            }
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case PLUS: {
                    x = jj_consume_token(PLUS);
                    func = "add";
                    break;
                }
                case MINUS: {
                    x = jj_consume_token(MINUS);
                    func = "subtract";
                    break;
                }
                default:
                    jj_la1[11] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
            MultiplicativeExpression();
            syntaxBuilder.bop("op.binary." + func, pos(x));
        }
    }

    final public void MultiplicativeExpression() throws ParseException {
        Token x;
        String func = null;
        PowerExpression();
        label_8: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case STAR:
                case SLASH:
                case REM: {

                    break;
                }
                default:
                    jj_la1[12] = jj_gen;
                    break label_8;
            }
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case STAR: {
                    x = jj_consume_token(STAR);
                    func = "multiply";
                    break;
                }
                case SLASH: {
                    x = jj_consume_token(SLASH);
                    func = "divide";
                    break;
                }
                case REM: {
                    x = jj_consume_token(REM);
                    func = "rem";
                    break;
                }
                default:
                    jj_la1[13] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
            PowerExpression();
            syntaxBuilder.bop("op.binary." + func, pos(x));
        }
    }

    final public void PowerExpression() throws ParseException {
        Token x;
        UnaryExpression();
        label_9: while (true) {
            if (jj_2_2(2147483647)) {

            } else {
                break label_9;
            }
            x = jj_consume_token(EXP);
            UnaryExpression();
            syntaxBuilder.bop("op.binary.pow", pos(x));
        }
    }

    final public void UnaryExpression() throws ParseException {
        Token x;
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case PLUS: {
                x = jj_consume_token(PLUS);
                UnaryExpression();
                syntaxBuilder.uop("op.unary.positive", pos(x));
                break;
            }
            case MINUS: {
                x = jj_consume_token(MINUS);
                UnaryExpression();
                syntaxBuilder.uop("op.unary.negative", pos(x));
                break;
            }
            case BANG: {
                x = jj_consume_token(BANG);
                UnaryExpression();
                syntaxBuilder.uop("op.unary.not", pos(x));
                break;
            }
            case INCR: {
                PreIncrementExpression();
                break;
            }
            case DECR: {
                PreDecrementExpression();
                break;
            }
            default:
                jj_la1[14] = jj_gen;
                if (jj_2_3(2147483647)) {
                    CastExpression();
                } else {
                    switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                        case FALSE:
                        case NEW:
                        case NULL:
                        case TRUE:
                        case LPAREN:
                        case BIT_OR:
                        case INTEGER_LITERAL:
                        case FLOATING_POINT_LITERAL:
                        case CHARACTER_LITERAL:
                        case STRING_LITERAL:
                        case IDENTIFIER: {
                            PostfixExpression();
                            break;
                        }
                        default:
                            jj_la1[15] = jj_gen;
                            jj_consume_token(-1);
                            throw new ParseException();
                    }
                }
        }
    }

    final public void PreIncrementExpression() throws ParseException {
        Token x;
        x = jj_consume_token(INCR);
        PrimaryExpression();
        syntaxBuilder.uop("op.prefix.inc", pos(x));
    }

    final public void PreDecrementExpression() throws ParseException {
        Token x;
        x = jj_consume_token(DECR);
        PrimaryExpression();
        syntaxBuilder.uop("op.prefix.dec", pos(x));
    }

    final public void PostfixExpression() throws ParseException {
        Token x;
        PrimaryExpression();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case INCR:
            case DECR: {
                switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                    case INCR: {
                        x = jj_consume_token(INCR);
                        syntaxBuilder.uop("op.suffix.inc", pos(x));
                        break;
                    }
                    case DECR: {
                        x = jj_consume_token(DECR);
                        syntaxBuilder.uop("op.suffix.dec", pos(x));
                        break;
                    }
                    default:
                        jj_la1[16] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jj_la1[17] = jj_gen;
                ;
        }
    }

    final public void PrimaryExpression() throws ParseException {
        int args = 1;
        PrimaryPrefix();
        label_10: while (true) {
            if (jj_2_4(2)) {

            } else {
                break label_10;
            }
            PrimarySuffix();
            ++args;
        }
        if (args > 1) {
            syntaxBuilder.nop("chain", null, args);
        }
    }

    final public void PrimaryPrefix() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case FALSE:
            case NULL:
            case TRUE:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case CHARACTER_LITERAL:
            case STRING_LITERAL: {
                Literal();
                break;
            }
            case BIT_OR: {
                AbsExpression();
                break;
            }
            case LPAREN: {
                jj_consume_token(LPAREN);
                Expression();
                jj_consume_token(RPAREN);
                break;
            }
            case NEW: {
                AllocationExpression();
                break;
            }
            default:
                jj_la1[18] = jj_gen;
                if (jj_2_5(2147483647)) {
                    function();
                } else {
                    switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                        case IDENTIFIER: {
                            identifier();
                            break;
                        }
                        default:
                            jj_la1[19] = jj_gen;
                            jj_consume_token(-1);
                            throw new ParseException();
                    }
                }
        }
    }

    final public void PrimarySuffix() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case LBRACKET: {
                index();
                break;
            }
            default:
                jj_la1[20] = jj_gen;
                if (jj_2_6(2147483647)) {
                    jj_consume_token(DOT);
                    function();
                } else {
                    switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                        case DOT: {
                            jj_consume_token(DOT);
                            identifier();
                            break;
                        }
                        default:
                            jj_la1[21] = jj_gen;
                            jj_consume_token(-1);
                            throw new ParseException();
                    }
                }
        }
    }

    final public void CastExpression() throws ParseException {
        Token x1, x2;
        x1 = jj_consume_token(LPAREN);
        Type();
        x2 = jj_consume_token(RPAREN);
        UnaryExpression();
        syntaxBuilder.bop("type.cast", pos(x1, x2));
    }

    final public void CastLookahead() throws ParseException {
        jj_consume_token(LPAREN);
        Type();
        jj_consume_token(RPAREN);
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case TILDE: {
                jj_consume_token(TILDE);
                break;
            }
            case BANG: {
                jj_consume_token(BANG);
                break;
            }
            case LPAREN: {
                jj_consume_token(LPAREN);
                break;
            }
            case LBRACKET: {
                jj_consume_token(LBRACKET);
                break;
            }
            case IDENTIFIER: {
                jj_consume_token(IDENTIFIER);
                break;
            }
            case NEW: {
                jj_consume_token(NEW);
                break;
            }
            case FALSE:
            case NULL:
            case TRUE:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case CHARACTER_LITERAL:
            case STRING_LITERAL: {
                Literal();
                break;
            }
            default:
                jj_la1[22] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public void identifier() throws ParseException {
        jj_consume_token(IDENTIFIER);
        syntaxBuilder.identifier("identifier", pos(token), token.image);
    }

    final public void TypeDimension() throws ParseException {
        Token x1, x2;
        x1 = jj_consume_token(LBRACKET);
        x2 = jj_consume_token(RBRACKET);
        syntaxBuilder.uop("type.index", pos(x1, x2));
    }

    final public void Type() throws ParseException {
        ClassName();
        label_11: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case LBRACKET: {

                    break;
                }
                default:
                    jj_la1[23] = jj_gen;
                    break label_11;
            }
            TypeDimension();
        }
        syntaxBuilder.uop("type.declaration", null);
    }

    final public void ResultType() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case VOID: {
                jj_consume_token(VOID);
                syntaxBuilder.identifier("type.name", pos(token), token.image);
                syntaxBuilder.uop("type.declaration", null);
                break;
            }
            case IDENTIFIER: {
                Type();
                break;
            }
            default:
                jj_la1[24] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public void ClassName() throws ParseException {
        String name;
        Token x1, x2;
        x1 = jj_consume_token(IDENTIFIER);
        name = token.image;
        x2 = x1;
        label_12: while (true) {
            if (jj_2_7(2)) {

            } else {
                break label_12;
            }
            jj_consume_token(DOT);
            x2 = jj_consume_token(IDENTIFIER);
            name = name + "." + token.image;
        }
        syntaxBuilder.identifier("type.name", pos(x1, x2), name);
    }

    final public void function() throws ParseException {
        String funcname;
        int args = 0;
        Token x1, x2;
        x1 = jj_consume_token(IDENTIFIER);
        funcname = token.image;
        jj_consume_token(LPAREN);
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case FALSE:
            case NEW:
            case NULL:
            case TRUE:
            case LPAREN:
            case BANG:
            case INCR:
            case DECR:
            case PLUS:
            case MINUS:
            case BIT_OR:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case CHARACTER_LITERAL:
            case STRING_LITERAL:
            case IDENTIFIER: {
                Expression();
                args++;
                label_13: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                        case COMMA: {

                            break;
                        }
                        default:
                            jj_la1[25] = jj_gen;
                            break label_13;
                    }
                    jj_consume_token(COMMA);
                    Expression();
                    args++;
                }
                break;
            }
            default:
                jj_la1[26] = jj_gen;
                ;
        }
        x2 = jj_consume_token(RPAREN);
        syntaxBuilder.identifier("funcname", pos(x1), funcname);
        syntaxBuilder.nop("function", pos(x1, x2), args + 1);
    }

    final public void AllocationExpression() throws ParseException {
        int args = 0;
        Token x1, x2;
        x1 = jj_consume_token(NEW);
        ClassName();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case LPAREN: {
                jj_consume_token(LPAREN);
                switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                    case FALSE:
                    case NEW:
                    case NULL:
                    case TRUE:
                    case LPAREN:
                    case BANG:
                    case INCR:
                    case DECR:
                    case PLUS:
                    case MINUS:
                    case BIT_OR:
                    case INTEGER_LITERAL:
                    case FLOATING_POINT_LITERAL:
                    case CHARACTER_LITERAL:
                    case STRING_LITERAL:
                    case IDENTIFIER: {
                        Expression();
                        args++;
                        label_14: while (true) {
                            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                                case COMMA: {

                                    break;
                                }
                                default:
                                    jj_la1[27] = jj_gen;
                                    break label_14;
                            }
                            jj_consume_token(COMMA);
                            Expression();
                            args++;
                        }
                        break;
                    }
                    default:
                        jj_la1[28] = jj_gen;
                        ;
                }
                x2 = jj_consume_token(RPAREN);
                syntaxBuilder.nop("op.new.object", pos(x1, x2), args + 1);
                break;
            }
            case LBRACKET: {
                ArrayDimsAndInits();
                syntaxBuilder.uop("op.new.array", pos(x1));
                break;
            }
            default:
                jj_la1[29] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    /*
     * The second LOOKAHEAD specification below is to parse to PrimarySuffix if there is an expression between the
     * "[...]".
     */
    final public void ArrayDimsAndInits() throws ParseException {
        Token x1, x2;
        int cnt = 0;
        if (jj_2_10(2)) {
            label_15: while (true) {
                x1 = jj_consume_token(LBRACKET);
                Expression();
                x2 = jj_consume_token(RBRACKET);
                syntaxBuilder.bop("array.index.expression", pos(x1, x2));
                cnt++;
                if (jj_2_8(2)) {

                } else {
                    break label_15;
                }
            }
            label_16: while (true) {
                if (jj_2_9(2)) {

                } else {
                    break label_16;
                }
                x1 = jj_consume_token(LBRACKET);
                x2 = jj_consume_token(RBRACKET);
                syntaxBuilder.uop("array.index.empty", pos(x1, x2));
            }
        } else {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case LBRACKET: {
                    label_17: while (true) {
                        TypeDimension();
                        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                            case LBRACKET: {

                                break;
                            }
                            default:
                                jj_la1[30] = jj_gen;
                                break label_17;
                        }
                    }
                    ArrayInitializer();
                    break;
                }
                default:
                    jj_la1[31] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
    }

    final public void index() throws ParseException {
        Token x1, x2;
        x1 = jj_consume_token(LBRACKET);
        Expression();
        x2 = jj_consume_token(RBRACKET);
        syntaxBuilder.uop("op.index", pos(x1, x2));
    }

    final public void AbsExpression() throws ParseException {
        Token x1, x2;
        x1 = jj_consume_token(BIT_OR);
        Expression();
        x2 = jj_consume_token(BIT_OR);
        syntaxBuilder.uop("|.|", pos(x1, x2));
    }

    final public void Literal() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case INTEGER_LITERAL: {
                jj_consume_token(INTEGER_LITERAL);
                syntaxBuilder.literal("literal.integer", pos(token), token.image);
                break;
            }
            case FLOATING_POINT_LITERAL: {
                jj_consume_token(FLOATING_POINT_LITERAL);
                syntaxBuilder.literal("literal.real", pos(token), token.image);
                break;
            }
            case STRING_LITERAL: {
                jj_consume_token(STRING_LITERAL);
                syntaxBuilder.literal("literal.string", pos(token), token.image);
                break;
            }
            case CHARACTER_LITERAL: {
                jj_consume_token(CHARACTER_LITERAL);
                syntaxBuilder.literal("literal.char", pos(token), token.image);
                break;
            }
            case FALSE:
            case TRUE: {
                BooleanLiteral();
                break;
            }
            case NULL: {
                NullLiteral();
                break;
            }
            default:
                jj_la1[32] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public void BooleanLiteral() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case TRUE: {
                jj_consume_token(TRUE);
                syntaxBuilder.literal("literal.bool", pos(token), token.image);
                break;
            }
            case FALSE: {
                jj_consume_token(FALSE);
                syntaxBuilder.literal("literal.bool", pos(token), token.image);
                break;
            }
            default:
                jj_la1[33] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public void NullLiteral() throws ParseException {
        jj_consume_token(NULL);
        syntaxBuilder.literal("literal.null", pos(token), token.image);
    }

    final public void Block() throws ParseException {
        Token x1, x2;
        x1 = jj_consume_token(LBRACE);
        BlockStatementList();
        x2 = jj_consume_token(RBRACE);

    }

    final public void BlockStatementList() throws ParseException {
        int args = 0;
        label_18: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case BREAK:
                case CONTINUE:
                case DO:
                case FALSE:
                case FOR:
                case IF:
                case NEW:
                case NULL:
                case RETURN:
                case THROW:
                case TRUE:
                case WHILE:
                case LPAREN:
                case LBRACE:
                case SEMICOLON:
                case BANG:
                case INCR:
                case DECR:
                case PLUS:
                case MINUS:
                case BIT_OR:
                case INTEGER_LITERAL:
                case FLOATING_POINT_LITERAL:
                case CHARACTER_LITERAL:
                case STRING_LITERAL:
                case IDENTIFIER: {

                    break;
                }
                default:
                    jj_la1[34] = jj_gen;
                    break label_18;
            }
            BlockStatement();
            args++;
        }
        syntaxBuilder.nop("block.statement", null, args);
    }

    final public void OptionalSemiColon() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case SEMICOLON: {
                jj_consume_token(SEMICOLON);
                break;
            }
            case 0: {
                jj_consume_token(0);
                break;
            }
            default:
                jj_la1[35] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public void Statement() throws ParseException {
        if (jj_2_11(2)) {
            LabeledStatement();
        } else {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case LBRACE: {
                    Block();
                    break;
                }
                case SEMICOLON: {
                    EmptyStatement();
                    break;
                }
                case FALSE:
                case NEW:
                case NULL:
                case TRUE:
                case LPAREN:
                case BANG:
                case INCR:
                case DECR:
                case PLUS:
                case MINUS:
                case BIT_OR:
                case INTEGER_LITERAL:
                case FLOATING_POINT_LITERAL:
                case CHARACTER_LITERAL:
                case STRING_LITERAL:
                case IDENTIFIER: {
                    StatementExpression();
                    OptionalSemiColon();
                    break;
                }
                case IF: {
                    IfStatement();
                    break;
                }
                case WHILE: {
                    WhileStatement();
                    break;
                }
                case DO: {
                    DoStatement();
                    break;
                }
                case FOR: {
                    ForStatement();
                    break;
                }
                case BREAK: {
                    BreakStatement();
                    break;
                }
                case CONTINUE: {
                    ContinueStatement();
                    break;
                }
                case RETURN: {
                    ReturnStatement();
                    break;
                }
                case THROW: {
                    ThrowStatement();
                    break;
                }
                default:
                    jj_la1[36] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
    }

    final public void LabeledStatement() throws ParseException {
        String label;
        jj_consume_token(IDENTIFIER);
        label = token.image;
        jj_consume_token(COLON);
        syntaxBuilder.notImplemented("startLabel(label)");
        Statement();
        syntaxBuilder.notImplemented("endLabel()");
    }

    final public void BlockStatement() throws ParseException {
        if (jj_2_12(2147483647)) {
            LocalVariableDeclaration();
            OptionalSemiColon();
        } else {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case BREAK:
                case CONTINUE:
                case DO:
                case FALSE:
                case FOR:
                case IF:
                case NEW:
                case NULL:
                case RETURN:
                case THROW:
                case TRUE:
                case WHILE:
                case LPAREN:
                case LBRACE:
                case SEMICOLON:
                case BANG:
                case INCR:
                case DECR:
                case PLUS:
                case MINUS:
                case BIT_OR:
                case INTEGER_LITERAL:
                case FLOATING_POINT_LITERAL:
                case CHARACTER_LITERAL:
                case STRING_LITERAL:
                case IDENTIFIER: {
                    Statement();
                    break;
                }
                default:
                    jj_la1[37] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
    }

    final public void StatementExpression() throws ParseException {
        Expression();
    }

    final public void EmptyStatement() throws ParseException {
        jj_consume_token(SEMICOLON);
        syntaxBuilder.emptyStatement(token.image, pos(token));
    }

    final public void IfStatement() throws ParseException {
        Token x1;
        int nodes = 2;
        x1 = jj_consume_token(IF);
        jj_consume_token(LPAREN);
        Expression();
        jj_consume_token(RPAREN);
        Statement();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case ELSE: {
                jj_consume_token(ELSE);
                Statement();
                ++nodes;
                break;
            }
            default:
                jj_la1[38] = jj_gen;
                ;
        }
        syntaxBuilder.nop("control.if", pos(x1), nodes);
    }

    final public void WhileStatement() throws ParseException {
        Token x;
        // { syntaxBuilder.notImplemented("startLabel(null)"); } // anonymous label for cycles
        x = jj_consume_token(WHILE);
        jj_consume_token(LPAREN);
        Expression();
        jj_consume_token(RPAREN);
        Statement();
        syntaxBuilder.bop("control.while", pos(x));
    }

    final public void ReturnStatement() throws ParseException {
        int args = 0;
        Token x;
        x = jj_consume_token(RETURN);
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case FALSE:
            case NEW:
            case NULL:
            case TRUE:
            case LPAREN:
            case BANG:
            case INCR:
            case DECR:
            case PLUS:
            case MINUS:
            case BIT_OR:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case CHARACTER_LITERAL:
            case STRING_LITERAL:
            case IDENTIFIER: {
                Expression();
                ++args;
                break;
            }
            default:
                jj_la1[39] = jj_gen;
                ;
        }
        jj_consume_token(SEMICOLON);
        syntaxBuilder.nop("control.return", pos(x), args);
    }

    final public void ThrowStatement() throws ParseException {
        jj_consume_token(THROW);
        Expression();
        jj_consume_token(SEMICOLON);
    }

    final public void DoStatement() throws ParseException {
        syntaxBuilder.notImplemented("startLabel(null)");
        jj_consume_token(DO);
        Statement();
        jj_consume_token(WHILE);
        jj_consume_token(LPAREN);
        Expression();
        jj_consume_token(RPAREN);
        OptionalSemiColon();
        syntaxBuilder.notImplemented("doStatement()");
        syntaxBuilder.notImplemented("endLabel()");
    }

    final public void LocalVariableDeclaration() throws ParseException {
        int args = 0;
        Type();
        VariableDeclarator();
        args++;
        label_19: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case COMMA: {

                    break;
                }
                default:
                    jj_la1[40] = jj_gen;
                    break label_19;
            }
            jj_consume_token(COMMA);
            VariableDeclarator();
            args++;
        }
        syntaxBuilder.nop("local.var.declaration", null, args + 1);
    }

    final public void VariableDeclarator() throws ParseException {
        boolean withInitializer = false;
        VariableDeclaratorId();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case ASSIGN: {
                jj_consume_token(ASSIGN);
                VariableInitializer();
                withInitializer = true;
                break;
            }
            default:
                jj_la1[41] = jj_gen;
                ;
        }
        if (withInitializer) {
            syntaxBuilder.bop("local.var.name.init", null);
        } else {
            // syntaxBuilder.uop("local.name.noinit", pos(x));
        }
        // syntaxBuilder.notImplemented("varDeclarator(withInitializer)");

    }

    final public void VariableDeclaratorId() throws ParseException {
        identifier();
        label_20: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case LBRACKET: {

                    break;
                }
                default:
                    jj_la1[42] = jj_gen;
                    break label_20;
            }
            TypeDimension();
        }
    }

    final public void VariableInitializer() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case LBRACE: {
                ArrayInitializer();
                break;
            }
            case FALSE:
            case NEW:
            case NULL:
            case TRUE:
            case LPAREN:
            case BANG:
            case INCR:
            case DECR:
            case PLUS:
            case MINUS:
            case BIT_OR:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case CHARACTER_LITERAL:
            case STRING_LITERAL:
            case IDENTIFIER: {
                Expression();
                break;
            }
            default:
                jj_la1[43] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public void ArrayInitializer() throws ParseException {
        int args = 0;
        Token x1, x2;
        x1 = jj_consume_token(LBRACE);
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case FALSE:
            case NEW:
            case NULL:
            case TRUE:
            case LPAREN:
            case LBRACE:
            case BANG:
            case INCR:
            case DECR:
            case PLUS:
            case MINUS:
            case BIT_OR:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case CHARACTER_LITERAL:
            case STRING_LITERAL:
            case IDENTIFIER: {
                VariableInitializer();
                args++;
                label_21: while (true) {
                    if (jj_2_13(2)) {

                    } else {
                        break label_21;
                    }
                    jj_consume_token(COMMA);
                    VariableInitializer();
                    args++;
                }
                break;
            }
            default:
                jj_la1[44] = jj_gen;
                ;
        }
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case COMMA: {
                jj_consume_token(COMMA);
                break;
            }
            default:
                jj_la1[45] = jj_gen;
                ;
        }
        x2 = jj_consume_token(RBRACE);
        syntaxBuilder.nop("array.init", pos(x1, x2), args);
    }

    final public void ForStatement() throws ParseException {
        boolean[] bParts = new boolean[4];
        Token x;

        // anonymous label for cycles
        x = jj_consume_token(FOR);
        jj_consume_token(LPAREN);
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case FALSE:
            case NEW:
            case NULL:
            case TRUE:
            case LPAREN:
            case BANG:
            case INCR:
            case DECR:
            case PLUS:
            case MINUS:
            case BIT_OR:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case CHARACTER_LITERAL:
            case STRING_LITERAL:
            case IDENTIFIER: {
                ForInit();
                bParts[0] = true;
                break;
            }
            default:
                jj_la1[46] = jj_gen;
                ;
        }
        jj_consume_token(SEMICOLON);
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case FALSE:
            case NEW:
            case NULL:
            case TRUE:
            case LPAREN:
            case BANG:
            case INCR:
            case DECR:
            case PLUS:
            case MINUS:
            case BIT_OR:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case CHARACTER_LITERAL:
            case STRING_LITERAL:
            case IDENTIFIER: {
                Expression();
                bParts[1] = true;
                break;
            }
            default:
                jj_la1[47] = jj_gen;
                ;
        }
        jj_consume_token(SEMICOLON);
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case FALSE:
            case NEW:
            case NULL:
            case TRUE:
            case LPAREN:
            case BANG:
            case INCR:
            case DECR:
            case PLUS:
            case MINUS:
            case BIT_OR:
            case INTEGER_LITERAL:
            case FLOATING_POINT_LITERAL:
            case CHARACTER_LITERAL:
            case STRING_LITERAL:
            case IDENTIFIER: {
                ForUpdate();
                bParts[2] = true;
                break;
            }
            default:
                jj_la1[48] = jj_gen;
                ;
        }
        jj_consume_token(RPAREN);
        Statement();
        bParts[3] = true;
        syntaxBuilder.nop("control.for", pos(x), bParts);

    }

    final public void ForInit() throws ParseException {
        if (jj_2_14(2147483647)) {
            LocalVariableDeclaration();
        } else {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case FALSE:
                case NEW:
                case NULL:
                case TRUE:
                case LPAREN:
                case BANG:
                case INCR:
                case DECR:
                case PLUS:
                case MINUS:
                case BIT_OR:
                case INTEGER_LITERAL:
                case FLOATING_POINT_LITERAL:
                case CHARACTER_LITERAL:
                case STRING_LITERAL:
                case IDENTIFIER: {
                    StatementExpressionList();
                    break;
                }
                default:
                    jj_la1[49] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
    }

    final public void StatementExpressionList() throws ParseException {
        int args = 0;
        StatementExpression();
        args++;
        label_22: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case COMMA: {

                    break;
                }
                default:
                    jj_la1[50] = jj_gen;
                    break label_22;
            }
            jj_consume_token(COMMA);
            StatementExpression();
            args++;
        }
        if (args > 1) {
            syntaxBuilder.nop("statement_list", null, args);
        }
    }

    final public void ForUpdate() throws ParseException {
        StatementExpressionList();
    }

    final public void BreakStatement() throws ParseException {
        String label = null;
        jj_consume_token(BREAK);
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case IDENTIFIER: {
                jj_consume_token(IDENTIFIER);
                label = token.image;
                break;
            }
            default:
                jj_la1[51] = jj_gen;
                ;
        }
        OptionalSemiColon();
        syntaxBuilder.notImplemented("doBreak(label)");
    }

    final public void ContinueStatement() throws ParseException {
        String label = null;
        jj_consume_token(CONTINUE);
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case IDENTIFIER: {
                jj_consume_token(IDENTIFIER);
                label = token.image;
                break;
            }
            default:
                jj_la1[52] = jj_gen;
                ;
        }
        OptionalSemiColon();
        syntaxBuilder.notImplemented("doContinue(label)");
    }

    final public void MethodHeader() throws ParseException {
        label_23: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case ABSTRACT:
                case FINAL:
                case NATIVE:
                case PRIVATE:
                case PROTECTED:
                case PUBLIC:
                case STATIC:
                case SYNCHRONIZED: {

                    break;
                }
                default:
                    jj_la1[53] = jj_gen;
                    break label_23;
            }
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case PUBLIC: {
                    jj_consume_token(PUBLIC);
                    break;
                }
                case PROTECTED: {
                    jj_consume_token(PROTECTED);
                    break;
                }
                case PRIVATE: {
                    jj_consume_token(PRIVATE);
                    break;
                }
                case STATIC: {
                    jj_consume_token(STATIC);
                    break;
                }
                case ABSTRACT: {
                    jj_consume_token(ABSTRACT);
                    break;
                }
                case FINAL: {
                    jj_consume_token(FINAL);
                    break;
                }
                case NATIVE: {
                    jj_consume_token(NATIVE);
                    break;
                }
                case SYNCHRONIZED: {
                    jj_consume_token(SYNCHRONIZED);
                    break;
                }
                default:
                    jj_la1[54] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
        ResultType();
        MethodDeclarator();
        syntaxBuilder.nop("method.header", null, 3);
    }

    final public void MethodDeclaration() throws ParseException {
        label_24: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case ABSTRACT:
                case FINAL:
                case NATIVE:
                case PRIVATE:
                case PROTECTED:
                case PUBLIC:
                case STATIC:
                case SYNCHRONIZED: {

                    break;
                }
                default:
                    jj_la1[55] = jj_gen;
                    break label_24;
            }
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case PUBLIC: {
                    jj_consume_token(PUBLIC);
                    break;
                }
                case PROTECTED: {
                    jj_consume_token(PROTECTED);
                    break;
                }
                case PRIVATE: {
                    jj_consume_token(PRIVATE);
                    break;
                }
                case STATIC: {
                    jj_consume_token(STATIC);
                    break;
                }
                case ABSTRACT: {
                    jj_consume_token(ABSTRACT);
                    break;
                }
                case FINAL: {
                    jj_consume_token(FINAL);
                    break;
                }
                case NATIVE: {
                    jj_consume_token(NATIVE);
                    break;
                }
                case SYNCHRONIZED: {
                    jj_consume_token(SYNCHRONIZED);
                    break;
                }
                default:
                    jj_la1[56] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
        ResultType();
        MethodDeclarator();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case LBRACE: {
                Block();
                syntaxBuilder.nop("method.declaration", null, 4);
                break;
            }
            case SEMICOLON: {
                jj_consume_token(SEMICOLON);
                break;
            }
            default:
                jj_la1[57] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public void MethodDeclarator() throws ParseException {
        MethodName();
        FormalParameters();
    }

    final public void MethodName() throws ParseException {
        identifier();
    }

    final public void FormalParameters() throws ParseException {
        int args = 0;
        Token x1, x2;
        x1 = jj_consume_token(LPAREN);
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case IDENTIFIER: {
                FormalParameter();
                ++args;
                label_25: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                        case COMMA: {

                            break;
                        }
                        default:
                            jj_la1[58] = jj_gen;
                            break label_25;
                    }
                    jj_consume_token(COMMA);
                    FormalParameter();
                    ++args;
                }
                break;
            }
            default:
                jj_la1[59] = jj_gen;
                ;
        }
        x2 = jj_consume_token(RPAREN);
        syntaxBuilder.nop("method.parameters", pos(x1, x2), args);
    }

    final public void FormalParameter() throws ParseException {
        Type();
        VariableDeclaratorId();
        syntaxBuilder.nop("parameter.declaration", null, 2);
    }

    final public void VarDeclaration() throws ParseException {
        LocalVariableDeclaration();
        jj_consume_token(SEMICOLON);
        syntaxBuilder.uop("var.declaration", null);
    }

    final public void MethodOrVarDeclaration() throws ParseException {
        if (jj_2_15(2147483647)) {
            MethodDeclaration();
        } else {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case IDENTIFIER: {
                    VarDeclaration();
                    break;
                }
                default:
                    jj_la1[60] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
    }

    final public void parseModuleInternal() throws ParseException {
        int nMethods = 1;
        MethodOrVarDeclaration();
        label_26: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case ABSTRACT:
                case FINAL:
                case NATIVE:
                case PRIVATE:
                case PROTECTED:
                case PUBLIC:
                case STATIC:
                case SYNCHRONIZED:
                case VOID:
                case IDENTIFIER: {

                    break;
                }
                default:
                    jj_la1[61] = jj_gen;
                    break label_26;
            }
            MethodOrVarDeclaration();
            ++nMethods;
        }
        if (nMethods > 0) {
            syntaxBuilder.nop("module.top", null, nMethods);
        }
        jj_consume_token(0);
    }

    /*
     */
    final public void parseTopNodeInternal() throws ParseException {
        BlockStatementList();
        syntaxBuilder.uop("block.top", null);
        jj_consume_token(0);
    }

    private boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_1());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(0, xla);
        }
    }

    private boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_2());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(1, xla);
        }
    }

    private boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_3());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(2, xla);
        }
    }

    private boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_4());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(3, xla);
        }
    }

    private boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_5());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(4, xla);
        }
    }

    private boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_6());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(5, xla);
        }
    }

    private boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_7());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(6, xla);
        }
    }

    private boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_8());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(7, xla);
        }
    }

    private boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_9());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(8, xla);
        }
    }

    private boolean jj_2_10(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_10());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(9, xla);
        }
    }

    private boolean jj_2_11(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_11());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(10, xla);
        }
    }

    private boolean jj_2_12(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_12());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(11, xla);
        }
    }

    private boolean jj_2_13(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_13());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(12, xla);
        }
    }

    private boolean jj_2_14(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_14());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(13, xla);
        }
    }

    private boolean jj_2_15(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_15());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(14, xla);
        }
    }

    private boolean jj_3R_99() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_106()) {
            jj_scanpos = xsp;
            if (jj_3R_107()) {
                return true;
            }
        }
        if (jj_3R_94()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_29() {
        if (jj_scan_token(IDENTIFIER)) {
            return true;
        }
        if (jj_scan_token(LPAREN)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_40()) {
            jj_scanpos = xsp;
        }
        if (jj_scan_token(RPAREN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_92() {
        if (jj_3R_94()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_99()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        if (jj_scan_token(DOT)) {
            return true;
        }
        if (jj_scan_token(IDENTIFIER)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_31() {
        if (jj_scan_token(IDENTIFIER)) {
            return true;
        }
        if (jj_scan_token(COLON)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_103() {
        if (jj_scan_token(GE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_42() {
        if (jj_scan_token(IDENTIFIER)) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3_7()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_102() {
        if (jj_scan_token(LE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_101() {
        if (jj_scan_token(GT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_100() {
        if (jj_scan_token(LT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_95() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_100()) {
            jj_scanpos = xsp;
            if (jj_3R_101()) {
                jj_scanpos = xsp;
                if (jj_3R_102()) {
                    jj_scanpos = xsp;
                    if (jj_3R_103()) {
                        return true;
                    }
                }
            }
        }
        if (jj_3R_92()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_43() {
        if (jj_3R_55()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_47() {
        if (jj_3R_32()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_90() {
        if (jj_3R_92()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_95()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_46() {
        if (jj_scan_token(VOID)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_34() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_46()) {
            jj_scanpos = xsp;
            if (jj_3R_47()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_14() {
        if (jj_3R_32()) {
            return true;
        }
        if (jj_scan_token(IDENTIFIER)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_97() {
        if (jj_scan_token(NE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_96() {
        if (jj_scan_token(EQ)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_93() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_96()) {
            jj_scanpos = xsp;
            if (jj_3R_97()) {
                return true;
            }
        }
        if (jj_3R_90()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_32() {
        if (jj_3R_42()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_43()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_87() {
        if (jj_scan_token(SC_OR)) {
            return true;
        }
        if (jj_3R_80()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_88() {
        if (jj_3R_90()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_93()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3_11() {
        if (jj_3R_31()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_55() {
        if (jj_scan_token(LBRACKET)) {
            return true;
        }
        if (jj_scan_token(RBRACKET)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_91() {
        if (jj_scan_token(SC_AND)) {
            return true;
        }
        if (jj_3R_88()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_85() {
        if (jj_3R_88()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_91()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_52() {
        if (jj_scan_token(IDENTIFIER)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_89() {
        if (jj_scan_token(XOR)) {
            return true;
        }
        if (jj_3R_85()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_80() {
        if (jj_3R_85()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_89()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        if (jj_scan_token(IMPL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_27() {
        if (jj_scan_token(LPAREN)) {
            return true;
        }
        if (jj_3R_32()) {
            return true;
        }
        if (jj_scan_token(RPAREN)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(59)) {
            jj_scanpos = xsp;
            if (jj_scan_token(58)) {
                jj_scanpos = xsp;
                if (jj_scan_token(46)) {
                    jj_scanpos = xsp;
                    if (jj_scan_token(50)) {
                        jj_scanpos = xsp;
                        if (jj_scan_token(102)) {
                            jj_scanpos = xsp;
                            if (jj_scan_token(27)) {
                                jj_scanpos = xsp;
                                if (jj_3R_36()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_6() {
        if (jj_scan_token(DOT)) {
            return true;
        }
        if (jj_3R_29()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_65() {
        if (jj_3R_80()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_87()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3_13() {
        if (jj_scan_token(COMMA)) {
            return true;
        }
        if (jj_3R_33()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_121() {
        if (jj_scan_token(LPAREN)) {
            return true;
        }
        if (jj_3R_32()) {
            return true;
        }
        if (jj_scan_token(RPAREN)) {
            return true;
        }
        if (jj_3R_104()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_143() {
        if (jj_3R_33()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3_13()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_84() {
        if (jj_scan_token(IMPL)) {
            return true;
        }
        if (jj_3R_65()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_39() {
        if (jj_scan_token(DOT)) {
            return true;
        }
        if (jj_3R_52()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_38() {
        if (jj_scan_token(DOT)) {
            return true;
        }
        if (jj_3R_29()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_5() {
        if (jj_3R_29()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_56() {
        if (jj_scan_token(LBRACE)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_143()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_scan_token(53)) {
            jj_scanpos = xsp;
        }
        if (jj_scan_token(RBRACE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_54() {
        if (jj_3R_65()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_84()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_37() {
        if (jj_3R_51()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_28() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_37()) {
            jj_scanpos = xsp;
            if (jj_3R_38()) {
                jj_scanpos = xsp;
                if (jj_3R_39()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_86() {
        if (jj_3R_55()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_69() {
        if (jj_scan_token(NULL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_70() {
        if (jj_scan_token(HOOK)) {
            return true;
        }
        if (jj_3R_41()) {
            return true;
        }
        if (jj_scan_token(COLON)) {
            return true;
        }
        if (jj_3R_41()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_131() {
        if (jj_3R_52()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_45() {
        if (jj_3R_30()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_41() {
        if (jj_3R_54()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_70()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_130() {
        if (jj_3R_29()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_44() {
        if (jj_3R_56()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_33() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_44()) {
            jj_scanpos = xsp;
            if (jj_3R_45()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_83() {
        if (jj_scan_token(FALSE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_4() {
        if (jj_3R_28()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_68() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_82()) {
            jj_scanpos = xsp;
            if (jj_3R_83()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_82() {
        if (jj_scan_token(TRUE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_129() {
        if (jj_3R_135()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_79() {
        if (jj_scan_token(REMASSIGN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_81() {
        if (jj_3R_52()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_86()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_78() {
        if (jj_scan_token(XORASSIGN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_128() {
        if (jj_scan_token(LPAREN)) {
            return true;
        }
        if (jj_3R_30()) {
            return true;
        }
        if (jj_scan_token(RPAREN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_77() {
        if (jj_scan_token(ORASSIGN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_76() {
        if (jj_scan_token(ANDASSIGN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_127() {
        if (jj_3R_134()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_75() {
        if (jj_scan_token(SLASHASSIGN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_63() {
        if (jj_3R_69()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_74() {
        if (jj_scan_token(STARASSIGN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_126() {
        if (jj_3R_50()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_124() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_126()) {
            jj_scanpos = xsp;
            if (jj_3R_127()) {
                jj_scanpos = xsp;
                if (jj_3R_128()) {
                    jj_scanpos = xsp;
                    if (jj_3R_129()) {
                        jj_scanpos = xsp;
                        if (jj_3R_130()) {
                            jj_scanpos = xsp;
                            if (jj_3R_131()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_62() {
        if (jj_3R_68()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_73() {
        if (jj_scan_token(MINUSASSIGN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_15() {
        if (jj_3R_34()) {
            return true;
        }
        if (jj_3R_35()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_72() {
        if (jj_scan_token(PLUSASSIGN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_71() {
        if (jj_scan_token(ASSIGN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_61() {
        if (jj_scan_token(CHARACTER_LITERAL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_64() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_71()) {
            jj_scanpos = xsp;
            if (jj_3R_72()) {
                jj_scanpos = xsp;
                if (jj_3R_73()) {
                    jj_scanpos = xsp;
                    if (jj_3R_74()) {
                        jj_scanpos = xsp;
                        if (jj_3R_75()) {
                            jj_scanpos = xsp;
                            if (jj_3R_76()) {
                                jj_scanpos = xsp;
                                if (jj_3R_77()) {
                                    jj_scanpos = xsp;
                                    if (jj_3R_78()) {
                                        jj_scanpos = xsp;
                                        if (jj_3R_79()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (jj_3R_30()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_60() {
        if (jj_scan_token(STRING_LITERAL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_59() {
        if (jj_scan_token(FLOATING_POINT_LITERAL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_67() {
        if (jj_scan_token(COMMA)) {
            return true;
        }
        if (jj_3R_66()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_123() {
        if (jj_3R_124()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3_4()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_30() {
        if (jj_3R_41()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_64()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_50() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_58()) {
            jj_scanpos = xsp;
            if (jj_3R_59()) {
                jj_scanpos = xsp;
                if (jj_3R_60()) {
                    jj_scanpos = xsp;
                    if (jj_3R_61()) {
                        jj_scanpos = xsp;
                        if (jj_3R_62()) {
                            jj_scanpos = xsp;
                            if (jj_3R_63()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_58() {
        if (jj_scan_token(INTEGER_LITERAL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_118() {
        if (jj_scan_token(REM)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_133() {
        if (jj_scan_token(DECR)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_132() {
        if (jj_scan_token(INCR)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_125() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_132()) {
            jj_scanpos = xsp;
            if (jj_3R_133()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_134() {
        if (jj_scan_token(BIT_OR)) {
            return true;
        }
        if (jj_3R_30()) {
            return true;
        }
        if (jj_scan_token(BIT_OR)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_122() {
        if (jj_3R_123()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_125()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_120() {
        if (jj_scan_token(DECR)) {
            return true;
        }
        if (jj_3R_123()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_3() {
        if (jj_3R_27()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_66() {
        if (jj_3R_32()) {
            return true;
        }
        if (jj_3R_81()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_51() {
        if (jj_scan_token(LBRACKET)) {
            return true;
        }
        if (jj_3R_30()) {
            return true;
        }
        if (jj_scan_token(RBRACKET)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_119() {
        if (jj_scan_token(INCR)) {
            return true;
        }
        if (jj_3R_123()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_57() {
        if (jj_3R_66()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_67()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_142() {
        if (jj_3R_55()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_141() {
        Token xsp;
        if (jj_3R_142()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_142()) {
                jj_scanpos = xsp;
                break;
            }
        }
        if (jj_3R_56()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_114() {
        if (jj_3R_122()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_9() {
        if (jj_scan_token(LBRACKET)) {
            return true;
        }
        if (jj_scan_token(RBRACKET)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_140() {
        if (jj_scan_token(COMMA)) {
            return true;
        }
        if (jj_3R_30()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_8() {
        if (jj_scan_token(LBRACKET)) {
            return true;
        }
        if (jj_3R_30()) {
            return true;
        }
        if (jj_scan_token(RBRACKET)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_117() {
        if (jj_scan_token(SLASH)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_113() {
        if (jj_3R_121()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_139() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_10()) {
            jj_scanpos = xsp;
            if (jj_3R_141()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_10() {
        Token xsp;
        if (jj_3_8()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3_8()) {
                jj_scanpos = xsp;
                break;
            }
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3_9()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_112() {
        if (jj_3R_120()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_111() {
        if (jj_3R_119()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_49() {
        if (jj_scan_token(LPAREN)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_57()) {
            jj_scanpos = xsp;
        }
        if (jj_scan_token(RPAREN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_110() {
        if (jj_scan_token(BANG)) {
            return true;
        }
        if (jj_3R_104()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_109() {
        if (jj_scan_token(MINUS)) {
            return true;
        }
        if (jj_3R_104()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_2() {
        if (jj_scan_token(EXP)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_108() {
        if (jj_scan_token(PLUS)) {
            return true;
        }
        if (jj_3R_104()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_104() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_108()) {
            jj_scanpos = xsp;
            if (jj_3R_109()) {
                jj_scanpos = xsp;
                if (jj_3R_110()) {
                    jj_scanpos = xsp;
                    if (jj_3R_111()) {
                        jj_scanpos = xsp;
                        if (jj_3R_112()) {
                            jj_scanpos = xsp;
                            if (jj_3R_113()) {
                                jj_scanpos = xsp;
                                if (jj_3R_114()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_48() {
        if (jj_3R_52()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_137() {
        if (jj_3R_139()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_53() {
        if (jj_scan_token(COMMA)) {
            return true;
        }
        if (jj_3R_30()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_35() {
        if (jj_3R_48()) {
            return true;
        }
        if (jj_3R_49()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_115() {
        if (jj_scan_token(EXP)) {
            return true;
        }
        if (jj_3R_104()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_107() {
        if (jj_scan_token(MINUS)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_138() {
        if (jj_3R_30()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_140()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_136() {
        if (jj_scan_token(LPAREN)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_138()) {
            jj_scanpos = xsp;
        }
        if (jj_scan_token(RPAREN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_98() {
        if (jj_3R_104()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_115()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_135() {
        if (jj_scan_token(NEW)) {
            return true;
        }
        if (jj_3R_42()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_136()) {
            jj_scanpos = xsp;
            if (jj_3R_137()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_116() {
        if (jj_scan_token(STAR)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_105() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_116()) {
            jj_scanpos = xsp;
            if (jj_3R_117()) {
                jj_scanpos = xsp;
                if (jj_3R_118()) {
                    return true;
                }
            }
        }
        if (jj_3R_98()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_94() {
        if (jj_3R_98()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_105()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3_12() {
        if (jj_3R_32()) {
            return true;
        }
        if (jj_scan_token(IDENTIFIER)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_40() {
        if (jj_3R_30()) {
            return true;
        }
        Token xsp;
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_53()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_36() {
        if (jj_3R_50()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_106() {
        if (jj_scan_token(PLUS)) {
            return true;
        }
        return false;
    }

    /** Generated Token Manager. */
    public JGrammarTokenManager token_source;
    SimpleCharStream jj_input_stream;
    /** Current token. */
    public Token token;
    /** Next token. */
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos, jj_lastpos;
    private int jj_la;
    private int jj_gen;
    final private int[] jj_la1 = new int[62];
    static private int[] jj_la1_0;
    static private int[] jj_la1_1;
    static private int[] jj_la1_2;
    static private int[] jj_la1_3;
    static {
        jj_la1_init_0();
        jj_la1_init_1();
        jj_la1_init_2();
        jj_la1_init_3();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[] { 0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x18010000,
                0x0,
                0x0,
                0x18010000,
                0x0,
                0x0,
                0x0,
                0x18010000,
                0x0,
                0x0,
                0x0,
                0x18010000,
                0x0,
                0x18010000,
                0x0,
                0x0,
                0x0,
                0x10010000,
                0x10000,
                0x18292880,
                0x1,
                0x18292880,
                0x18292880,
                0x4000,
                0x18010000,
                0x0,
                0x0,
                0x0,
                0x18010000,
                0x18010000,
                0x0,
                0x18010000,
                0x18010000,
                0x18010000,
                0x18010000,
                0x0,
                0x0,
                0x0,
                0xc4020040,
                0xc4020040,
                0xc4020040,
                0xc4020040,
                0x0,
                0x0,
                0x0,
                0x0,
                0xc4020040, };
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[] { 0x800000,
                0x800000,
                0x10000000,
                0x0,
                0x0,
                0x0,
                0x40000000,
                0x40000000,
                0x83000000,
                0x83000000,
                0x0,
                0x0,
                0x0,
                0x0,
                0x4000000,
                0x4200,
                0x0,
                0x0,
                0x4200,
                0x0,
                0x40000,
                0x400000,
                0xc044200,
                0x40000,
                0x800,
                0x200000,
                0x4004200,
                0x200000,
                0x4004200,
                0x44000,
                0x40000,
                0x40000,
                0x200,
                0x200,
                0x4116242,
                0x100000,
                0x4116242,
                0x4116242,
                0x0,
                0x4004200,
                0x200000,
                0x800000,
                0x40000,
                0x4014200,
                0x4014200,
                0x200000,
                0x4004200,
                0x4004200,
                0x4004200,
                0x4004200,
                0x200000,
                0x0,
                0x0,
                0x25,
                0x25,
                0x25,
                0x25,
                0x110000,
                0x200000,
                0x0,
                0x0,
                0x825, };
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[] { 0x1fe0000,
                0x1fe0000,
                0x0,
                0x4,
                0x1000,
                0x8,
                0x2,
                0x2,
                0x1,
                0x1,
                0xc0,
                0xc0,
                0x2300,
                0x2300,
                0xf0,
                0x40000800,
                0x30,
                0x30,
                0x40000800,
                0x0,
                0x0,
                0x0,
                0x40000000,
                0x0,
                0x0,
                0x0,
                0x400008f0,
                0x0,
                0x400008f0,
                0x0,
                0x0,
                0x0,
                0x40000000,
                0x0,
                0x400008f0,
                0x0,
                0x400008f0,
                0x400008f0,
                0x0,
                0x400008f0,
                0x0,
                0x0,
                0x0,
                0x400008f0,
                0x400008f0,
                0x0,
                0x400008f0,
                0x400008f0,
                0x400008f0,
                0x400008f0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0, };
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[] { 0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x74,
                0x0,
                0x0,
                0x34,
                0x40,
                0x0,
                0x0,
                0x74,
                0x0,
                0x40,
                0x0,
                0x74,
                0x0,
                0x74,
                0x0,
                0x0,
                0x0,
                0x34,
                0x0,
                0x74,
                0x0,
                0x74,
                0x74,
                0x0,
                0x74,
                0x0,
                0x0,
                0x0,
                0x74,
                0x74,
                0x0,
                0x74,
                0x74,
                0x74,
                0x74,
                0x0,
                0x40,
                0x40,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x0,
                0x40,
                0x40,
                0x40, };
    }

    final private JJCalls[] jj_2_rtns = new JJCalls[15];
    private boolean jj_rescan = false;
    private int jj_gc = 0;

    /** Constructor with InputStream. */
    public JGrammar(java.io.InputStream stream) {
        this(stream, null);
    }

    /** Constructor with InputStream and supplied encoding */
    public JGrammar(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new JGrammarTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 62; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /** Reinitialise. */
    public void ReInit(java.io.InputStream stream) {
        ReInit(stream, null);
    }

    /** Reinitialise. */
    public void ReInit(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 62; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /** Constructor. */
    public JGrammar(java.io.Reader stream) {
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new JGrammarTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 62; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /** Reinitialise. */
    @Override
    public void ReInit(java.io.Reader stream) {
        if (jj_input_stream == null) {
            jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            jj_input_stream.ReInit(stream, 1, 1);
        }
        if (token_source == null) {
            token_source = new JGrammarTokenManager(jj_input_stream);
        }

        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 62; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /** Constructor with generated Token Manager. */
    public JGrammar(JGrammarTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 62; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /** Reinitialise. */
    public void ReInit(JGrammarTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 62; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken;
        if ((oldToken = token).next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    @SuppressWarnings("serial")
    static private final class LookaheadSuccess extends java.lang.Error {
    }

    final private LookaheadSuccess jj_ls = new LookaheadSuccess();

    private boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
            } else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        } else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                i++;
                tok = tok.next;
            }
            if (tok != null) {
                jj_add_error_token(kind, i);
            }
        }
        if (jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    /** Get the next Token. */
    final public Token getNextToken() {
        if (token.next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        jj_gen++;
        return token;
    }

    /** Get the specific Token. */
    final public Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; i++) {
            if (t.next != null) {
                t = t.next;
            } else {
                t = t.next = token_source.getNextToken();
            }
        }
        return t;
    }

    private int jj_ntk_f() {
        if ((jj_nt = token.next) == null) {
            return (jj_ntk = (token.next = token_source.getNextToken()).kind);
        } else {
            return (jj_ntk = jj_nt.kind);
        }
    }

    private java.util.List<int[]> jj_expentries = new java.util.ArrayList<>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }

        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];

            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }

            for (int[] oldentry : jj_expentries) {
                if (oldentry.length == jj_expentry.length) {
                    boolean isMatched = true;

                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            isMatched = false;
                            break;
                        }

                    }
                    if (isMatched) {
                        jj_expentries.add(jj_expentry);
                        break;
                    }
                }
            }

            if (pos != 0) {
                jj_lasttokens[(jj_endpos = pos) - 1] = kind;
            }
        }
    }

    /** Generate ParseException. */
    public ParseException generateParseException() {
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[111];
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 62; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & (1 << j)) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & (1 << j)) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jj_la1_2[i] & (1 << j)) != 0) {
                        la1tokens[64 + j] = true;
                    }
                    if ((jj_la1_3[i] & (1 << j)) != 0) {
                        la1tokens[96 + j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 111; i++) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.add(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = jj_expentries.get(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    private int trace_indent = 0;
    private boolean trace_enabled;

    /** Trace enabled. */
    final public boolean trace_enabled() {
        return trace_enabled;
    }

    /** Enable tracing. */
    final public void enable_tracing() {
    }

    /** Disable tracing. */
    final public void disable_tracing() {
    }

    private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 15; i++) {
            try {
                JJCalls p = jj_2_rtns[i];

                do {
                    if (p.gen > jj_gen) {
                        jj_la = p.arg;
                        jj_lastpos = jj_scanpos = p.first;
                        switch (i) {
                            case 0:
                                jj_3_1();
                                break;
                            case 1:
                                jj_3_2();
                                break;
                            case 2:
                                jj_3_3();
                                break;
                            case 3:
                                jj_3_4();
                                break;
                            case 4:
                                jj_3_5();
                                break;
                            case 5:
                                jj_3_6();
                                break;
                            case 6:
                                jj_3_7();
                                break;
                            case 7:
                                jj_3_8();
                                break;
                            case 8:
                                jj_3_9();
                                break;
                            case 9:
                                jj_3_10();
                                break;
                            case 10:
                                jj_3_11();
                                break;
                            case 11:
                                jj_3_12();
                                break;
                            case 12:
                                jj_3_13();
                                break;
                            case 13:
                                jj_3_14();
                                break;
                            case 14:
                                jj_3_15();
                                break;
                        }
                    }
                    p = p.next;
                } while (p != null);

            } catch (LookaheadSuccess ls) {
            }
        }
        jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }

        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;
    }

} // EOF JGrammar
