/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import org.openl.rules.util.Numbers;

public final class Strings {
    private Strings() {
    }

    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.contains(searchStr);
    }

    public static boolean contains(String str, char searchChar) {
        if (Strings.isEmpty0(str)) {
            return false;
        }
        return str.indexOf(searchChar) != -1;
    }

    public static boolean containsAny(String str, char ... chars) {
        if (Strings.isEmpty0(str) || chars == null || chars.length == 0) {
            return false;
        }
        for (char ch : chars) {
            if (str.indexOf(ch) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String str, String searchChars) {
        if (Strings.isEmpty0(str) || Strings.isEmpty0(searchChars)) {
            return false;
        }
        return Strings.containsAny(str, searchChars.toCharArray());
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !Strings.isEmpty(str);
    }

    public static int length(String str) {
        return str == null ? 0 : str.length();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean startsWith(String str, String prefix) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.startsWith(prefix);
    }

    public static boolean endsWith(String str, String suffix) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        return str.endsWith(suffix);
    }

    public static String substr(String str, int pos, int length) {
        return Strings.substring(str, pos, pos + length);
    }

    public static String substring(String str, int beginIndex) {
        if (str == null) {
            return null;
        }
        if (beginIndex < 0) {
            beginIndex = str.length() + beginIndex;
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (beginIndex > str.length()) {
            return "";
        }
        return str.substring(beginIndex);
    }

    public static String substring(String str, int beginIndex, int endIndex) {
        if (str == null) {
            return null;
        }
        if (endIndex < 0) {
            endIndex = str.length() + endIndex;
        }
        if (beginIndex < 0) {
            beginIndex = str.length() + beginIndex;
        }
        if (endIndex > str.length()) {
            endIndex = str.length();
        }
        if (beginIndex > endIndex) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        return str.substring(beginIndex, endIndex);
    }

    public static String removeStart(String str, String remove) {
        if (Strings.isEmpty0(str) || Strings.isEmpty0(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (Strings.isEmpty0(str) || Strings.isEmpty0(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String replace(String str, String searchString, String replacement) {
        return Strings.replace(str, searchString, replacement, -1);
    }

    public static String replace(String str, String searchString, String replacement, int max) {
        if (Strings.isEmpty0(str) || Strings.isEmpty0(searchString) || replacement == null || max == 0) {
            return str;
        }
        int start = 0;
        int end = str.indexOf(searchString, start);
        if (end == -1) {
            return str;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(str.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(str, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = str.indexOf(searchString, start);
        }
        buf.append(str.substring(start));
        return buf.toString();
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return Numbers.toString((Number)obj);
        }
        return obj.toString();
    }

    public static Integer toInteger(String str) {
        try {
            return Strings.isEmpty(str) ? null : Integer.valueOf(Integer.parseInt(Strings.trim(str)));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Double toDouble(String str) {
        try {
            return Strings.isEmpty(str) ? null : Double.valueOf(Double.parseDouble(str));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Number toNumber(String str) {
        if (Strings.isEmpty(str)) {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number parsed = NumberFormat.getInstance(Locale.US).parse(str, parsePosition);
        if (parsePosition.getIndex() != str.length()) {
            return null;
        }
        return parsed;
    }

    public static boolean isNumeric(String str) {
        return Strings.toDouble(str) != null;
    }

    public static String concatenate(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        StringBuilder builder = null;
        for (Object obj : objects) {
            if (obj == null) continue;
            if (builder == null) {
                builder = new StringBuilder(16 * objects.length);
            }
            builder.append(obj);
        }
        return builder == null ? null : builder.toString();
    }

    private static boolean isEmpty0(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean like(String str, String pattern) {
        if (Strings.isEmpty0(str)) {
            return Strings.isEmpty0(pattern);
        }
        if (Strings.isEmpty0(pattern)) {
            return false;
        }
        String likePattern = Strings.parseLikePattern(pattern);
        Pattern regex = Pattern.compile(likePattern);
        return regex.matcher(str).matches();
    }

    private static String parseLikePattern(String pattern) {
        int size = pattern.length();
        StringBuilder regex = new StringBuilder(size * 2);
        int i = 0;
        int prevCh = 0;
        char nextCh = pattern.charAt(i);
        boolean inSet = false;
        while (i < size) {
            char ch = nextCh;
            nextCh = ++i < size ? pattern.charAt(i) : (char)'\u0000';
            switch (ch) {
                case '?': {
                    if (!inSet) {
                        regex.append('.');
                        break;
                    }
                    regex.append(ch);
                    break;
                }
                case '*': {
                    if (!inSet) {
                        regex.append(".*");
                        break;
                    }
                    regex.append(ch);
                    break;
                }
                case '#': {
                    if (!inSet) {
                        regex.append("\\d");
                        break;
                    }
                    regex.append(ch);
                    break;
                }
                case '@': {
                    if (!inSet) {
                        regex.append("\\p{Alpha}");
                        break;
                    }
                    regex.append(ch);
                    break;
                }
                case '!': {
                    if (inSet && prevCh == 91 && nextCh != ']') {
                        regex.append('^');
                        break;
                    }
                    regex.append(ch);
                    break;
                }
                case '[': {
                    if (inSet) {
                        regex.append('\\');
                    }
                    regex.append(ch);
                    inSet = true;
                    break;
                }
                case ']': {
                    regex.append(ch);
                    inSet = false;
                    break;
                }
                case ' ': {
                    if (prevCh == 32) break;
                    regex.append("\\s+");
                    break;
                }
                case '+': {
                    if (prevCh != 63 && prevCh != 64 && prevCh != 35 && prevCh != 93) {
                        regex.append('\\');
                    }
                    regex.append(ch);
                    break;
                }
                case '\\': {
                    regex.append('\\');
                    regex.append(ch);
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '{': 
                case '|': 
                case '}': {
                    if (!inSet) {
                        regex.append('\\');
                    }
                    regex.append(ch);
                    break;
                }
                default: {
                    regex.append(ch);
                }
            }
            prevCh = ch;
        }
        return regex.toString();
    }

    public static String textJoin(String delimiter, Object ... values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return "";
        }
        boolean hasDelimiter = !Strings.isEmpty0(delimiter);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object o : values) {
            String str;
            if (o == null || Strings.isEmpty0(str = String.valueOf(o))) continue;
            if (hasDelimiter && i > 0) {
                sb.append(delimiter);
            }
            sb.append(str);
            ++i;
        }
        return sb.toString();
    }

    public static String[] textSplit(String delimiter, String str) {
        if (str == null) {
            return null;
        }
        if (Strings.isEmpty0(str) || Strings.isEmpty0(delimiter)) {
            return new String[]{str};
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int lenDelim = delimiter.length();
        int start = 0;
        int pos = 0;
        while (pos < len) {
            int posDelim = 0;
            boolean matched = true;
            int end = pos;
            while (posDelim < lenDelim && pos < len) {
                if (delimiter.charAt(posDelim++) == str.charAt(pos++)) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            if (start < end) {
                list.add(str.substring(start, end));
            }
            start = pos;
        }
        if (start < len) {
            list.add(str.substring(start, len));
        }
        return list.toArray(new String[0]);
    }

    public static String format(String pattern, Object ... args) {
        if (pattern == null || Strings.isEmpty0(pattern)) {
            return pattern;
        }
        MessageFormat msg = new MessageFormat(pattern, Locale.US);
        return msg.format(args);
    }

    public static Locale toLocale(String localeStr) {
        if (Strings.isEmpty0(localeStr)) {
            return null;
        }
        return Locale.forLanguageTag(localeStr);
    }
}

