/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Comparator;

public final class Arrays {
    private Arrays() {
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !Arrays.isEmpty(array);
    }

    public static <T> int length(T[] array) {
        return array == null ? 0 : array.length;
    }

    public static <T> T[] addElement(T[] array, int index, T ... elements) {
        Class<?> elementsComponentType;
        if (elements == null) {
            return array;
        }
        if (array == null) {
            return elements;
        }
        Class<?> arrayComponentType = array.getClass().getComponentType();
        Class<Object> componentType = arrayComponentType.isAssignableFrom(elementsComponentType = elements.getClass().getComponentType()) ? arrayComponentType : (elementsComponentType.isAssignableFrom(arrayComponentType) ? elementsComponentType : Object.class);
        Object[] result = (Object[])Array.newInstance(componentType, array.length + elements.length);
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(elements, 0, result, index, elements.length);
        System.arraycopy(array, index, result, index + elements.length, array.length - index);
        return result;
    }

    public static <T> T[] addElement(T[] array, int index, T element) {
        if (array == null && element == null) {
            return null;
        }
        Object oneElementArray = Array.newInstance(element != null ? element.getClass() : array.getClass().getComponentType(), 1);
        if (element != null) {
            Array.set(oneElementArray, 0, element);
        }
        return Arrays.addElement(array, index, (Object[])oneElementArray);
    }

    public static <T> T[] slice(T[] values, int startIndexInclusive) {
        return Arrays.slice(values, startIndexInclusive, Integer.MAX_VALUE);
    }

    public static <T> T[] slice(T[] values, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (Arrays.isEmpty(values)) {
            return values;
        }
        int size = values.length;
        if (endIndexExclusive < 0) {
            endIndexExclusive = size + endIndexExclusive;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = size + startIndexInclusive;
        }
        if (endIndexExclusive > size) {
            endIndexExclusive = size;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive < 0) {
            endIndexExclusive = 0;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) == size && startIndexInclusive == 0) {
            return values;
        }
        if (newSize <= 0) {
            return (Object[])Array.newInstance(values.getClass().getComponentType(), 0);
        }
        return java.util.Arrays.copyOfRange(values, startIndexInclusive, endIndexExclusive);
    }

    public static <T, E extends T> T[] removeElement(T[] array, E ... elements) {
        if (array == null) {
            return null;
        }
        if (elements == null) {
            return array;
        }
        ArrayList<T> result = new ArrayList<T>(java.util.Arrays.asList(array));
        java.util.Arrays.stream(elements).forEach(result::remove);
        return result.toArray();
    }

    public static <T> T[] removeNulls(T ... elements) {
        if (Arrays.isEmpty(elements)) {
            return elements;
        }
        int count = 0;
        for (T value : elements) {
            if (value == null) continue;
            ++count;
        }
        if (count == elements.length) {
            return elements;
        }
        Class<?> componentType = elements.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(componentType, count);
        int i = 0;
        for (T value : elements) {
            if (value == null) continue;
            result[i] = value;
            ++i;
        }
        return result;
    }

    public static <T> boolean noNulls(T ... values) {
        if (Arrays.isEmpty(values)) {
            return false;
        }
        for (T item : values) {
            if (item != null) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> T[] sort(T ... values) {
        if (Arrays.isEmpty(values)) {
            return values;
        }
        Comparable[] sortedArray = (Comparable[])values.clone();
        java.util.Arrays.sort(sortedArray, Comparator.nullsLast(Comparator.naturalOrder()));
        return sortedArray;
    }
}

