/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Year;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.openl.rules.util.dates.DateInterval;

public final class Dates {
    private Dates() {
    }

    public static Date Date(int year, int month, int day) {
        return Dates.Date(year, month, day, 0, 0, 0, 0);
    }

    public static Date Date(int year, int month, int day, int hours, int minutes) {
        return Dates.Date(year, month, day, hours, minutes, 0, 0);
    }

    public static Date Date(int year, int month, int day, int hours, int minutes, int seconds) {
        return Dates.Date(year, month, day, hours, minutes, seconds, 0);
    }

    public static Date Date(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, hours, minutes, seconds);
        calendar.set(14, milliseconds);
        calendar.setLenient(false);
        try {
            return calendar.getTime();
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static String toString(Date date) {
        return Dates.toString(date, "MM/dd/yyyy");
    }

    public static String toString(Date date, String pattern) {
        return date == null ? null : Dates.getDateFormat(pattern).format(date);
    }

    public static Date toDate(String str) {
        Date isoDate = Dates.toDate(str, "yyyy-MM-dd");
        return isoDate != null ? isoDate : Dates.toDate(str, "MM/dd/yy");
    }

    public static Date toDate(String str, String pattern) {
        return Dates.isEmpty(str) ? null : Dates.parse(str, pattern);
    }

    public static Date setTime(Date date, int hours, int minutes) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.setLenient(false);
        try {
            return calendar.getTime();
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static Date setTime(Date date, int hours, int minutes, int seconds) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.setLenient(false);
        try {
            return calendar.getTime();
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static Date setTime(Date date, int hours, int minutes, int seconds, int milliseconds) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, milliseconds);
        calendar.setLenient(false);
        try {
            return calendar.getTime();
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static Date setDate(Date date, int year, int month, int day) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.setLenient(false);
        try {
            return calendar.getTime();
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static Boolean isLeap(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return Year.isLeap(calendar.get(1));
    }

    public static Boolean isLeap(Integer year) {
        if (year == null) {
            return null;
        }
        return Year.isLeap(year.intValue());
    }

    private static Date parse(String str, String pattern) {
        try {
            return Dates.getDateFormat(pattern).parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static DateFormat getDateFormat(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(Dates.isEmpty(pattern) ? "MM/dd/yyyy" : pattern, Locale.US);
        df.setLenient(false);
        df.getCalendar().set(0, 0, 0, 0, 0, 0);
        df.getCalendar().set(14, 0);
        return df;
    }

    public static Double dateDif(Date startDate, Date endDate, String unitName) {
        DateInterval.Unit unit = DateInterval.Unit.getUnit(unitName);
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Unsupported unit '%s'", unitName));
        }
        DateInterval interval = DateInterval.between(startDate, endDate);
        switch (unit) {
            case DAYS: {
                return interval.toDays();
            }
            case WEEKS: {
                return interval.toWeeks(DateInterval.Scale.INT);
            }
            case MONTHS: {
                return interval.toMonths(DateInterval.Scale.INT);
            }
            case YEARS: {
                return interval.toYears(DateInterval.Scale.INT);
            }
            case DAYS_EXCLUDE_MONTHS_AND_YEARS: {
                return interval.toDaysExcludeYearsAndMonths();
            }
            case MONTHS_EXCLUDE_YEARS: {
                return interval.toMonthsExcludeYears(DateInterval.Scale.INT);
            }
            case DAYS_EXCLUDE_YEARS: {
                return interval.toDaysExcludeYears();
            }
            case WEEKS_FRACTIONAL: {
                return interval.toWeeks(DateInterval.Scale.FRAC);
            }
            case MONTHS_FRACTIONAL: {
                return interval.toMonths(DateInterval.Scale.FRAC);
            }
            case YEARS_FRACTIONAL: {
                return interval.toYears(DateInterval.Scale.FRAC);
            }
            case MONTHS_FRACTIONAL_EXCLUDE_YEARS: {
                return interval.toMonthsExcludeYears(DateInterval.Scale.FRAC);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported unit '%s'", unitName));
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

