/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class Numbers {
    public static final String POSITIVE_INFINITY_SIGN = "\u221e";
    public static final String NEGATIVE_INFINITY_SIGN = "-\u221e";
    public static final String NOT_A_NUMBER = "NaN";

    private Numbers() {
    }

    public static String toString(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            Double doubleNumber = (Double)number;
            if (doubleNumber.isInfinite()) {
                return doubleNumber > 0.0 ? POSITIVE_INFINITY_SIGN : NEGATIVE_INFINITY_SIGN;
            }
            if (doubleNumber.isNaN()) {
                return NOT_A_NUMBER;
            }
        } else if (number instanceof Float) {
            Float floatNumber = (Float)number;
            if (floatNumber.isInfinite()) {
                return floatNumber.floatValue() > 0.0f ? POSITIVE_INFINITY_SIGN : NEGATIVE_INFINITY_SIGN;
            }
            if (floatNumber.isNaN()) {
                return NOT_A_NUMBER;
            }
        }
        if (number instanceof Double || number instanceof Float) {
            return Numbers.toString(new BigDecimal(number.toString()));
        }
        if (number instanceof BigDecimal) {
            return Numbers.toString((BigDecimal)number);
        }
        return number.toString();
    }

    private static String toString(BigDecimal bd) {
        if (bd.scale() > 10000 || bd.scale() < -10000) {
            return bd.toString();
        }
        return bd.stripTrailingZeros().toPlainString();
    }

    public static String toString(Number number, String pattern) {
        if (number == null || pattern == null) {
            return null;
        }
        try {
            DecimalFormat decimalFormat = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.US));
            return decimalFormat.format(number);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }
}

