/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

public final class Statistics {
    private Statistics() {
    }

    public static <T extends Comparable<T>> T max(T ... values) {
        return (T)((Comparable)Statistics.process(values, new Result<T, T>(){

            @Override
            public void processNonNull(T value) {
                if (this.result == null || ((Comparable)this.result).compareTo(value) < 0) {
                    this.result = value;
                }
            }
        }));
    }

    public static <T extends Comparable<T>> T min(T ... values) {
        return (T)((Comparable)Statistics.process(values, new Result<T, T>(){

            @Override
            public void processNonNull(T value) {
                if (this.result == null || ((Comparable)this.result).compareTo(value) > 0) {
                    this.result = value;
                }
            }
        }));
    }

    static <V, R> R process(V[] values, Processor<V, R> processor) {
        if (values == null || values.length == 0) {
            return null;
        }
        for (V value : values) {
            processor.process(value);
        }
        return processor.result();
    }

    static abstract class Result<V, R>
    implements Processor<V, R> {
        R result;
        int counter;

        Result() {
        }

        void processNonNull(V value) {
        }

        @Override
        public void process(V value) {
            if (value != null) {
                this.processNonNull(value);
                ++this.counter;
            }
        }

        @Override
        public R result() {
            return this.result;
        }
    }

    static interface Processor<V, R> {
        public void process(V var1);

        public R result();
    }
}

