/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util.dates;

import java.util.Calendar;
import java.util.Date;
import org.openl.rules.util.dates.CalendarWrapper;
import org.openl.rules.util.dates.DateInterval;
import org.openl.rules.util.dates.NullableInterval;

final class DateIntervalImpl
extends DateInterval {
    static final DateInterval NULLABLE = new NullableInterval();
    private final CalendarWrapper startDate;
    private final CalendarWrapper endDate;
    private final boolean isNegative;

    DateIntervalImpl(Date start, Date end) {
        if (start.after(end)) {
            this.startDate = new CalendarWrapper(end);
            this.endDate = new CalendarWrapper(start);
            this.isNegative = true;
        } else {
            this.startDate = new CalendarWrapper(start);
            this.endDate = new CalendarWrapper(end);
            this.isNegative = false;
        }
    }

    DateIntervalImpl(Calendar start, Calendar end) {
        if (start.after(end)) {
            this.startDate = new CalendarWrapper(end);
            this.endDate = new CalendarWrapper(start);
            this.isNegative = true;
        } else {
            this.startDate = new CalendarWrapper(start);
            this.endDate = new CalendarWrapper(end);
            this.isNegative = false;
        }
    }

    @Override
    public Double toDays() {
        double result = this.endDate.daysDiff(this.startDate);
        return this.toSignDouble(result);
    }

    @Override
    public Double toWeeks(DateInterval.Scale scale) {
        double result = (double)this.endDate.daysDiff(this.startDate) / 7.0;
        if (DateInterval.Scale.FRAC == scale) {
            return this.toSignDouble(result);
        }
        return this.toSignAndRemoveFraction(result);
    }

    @Override
    public Double toMonths(DateInterval.Scale scale) {
        int result = this.endDate.monthsDiff(this.startDate);
        if (DateInterval.Scale.INT == scale) {
            return this.toSignDouble(result);
        }
        double daysDif = this.endDate.daysDiffExcludeYearsAndMonths(this.startDate);
        int prevMonthL = this.getUncompleteMonthLength();
        return this.toSignDouble((double)result + daysDif / (double)prevMonthL);
    }

    @Override
    public Double toYears(DateInterval.Scale scale) {
        int result = this.endDate.yearsDiff(this.startDate);
        if (DateInterval.Scale.INT == scale) {
            return this.toSignDouble(result);
        }
        double daysDif = this.endDate.daysDiffExcludeYears(this.startDate);
        int yearLen = this.endDate.getUncompleteYearLength(this.startDate);
        return this.toSignDouble((double)result + daysDif / (double)yearLen);
    }

    @Override
    public Double toDaysExcludeYearsAndMonths() {
        int result = this.endDate.daysDiffExcludeYearsAndMonths(this.startDate);
        return this.toSignDouble(result);
    }

    @Override
    public Double toDaysExcludeYears() {
        int result = this.endDate.daysDiffExcludeYears(this.startDate);
        return this.toSignDouble(result);
    }

    @Override
    public Double toMonthsExcludeYears(DateInterval.Scale scale) {
        int result = this.endDate.monthsDiff(this.startDate) % 12;
        if (DateInterval.Scale.INT == scale) {
            return this.toSignDouble(result);
        }
        double daysDif = this.endDate.daysDiffExcludeYearsAndMonths(this.startDate);
        int prevMonthL = this.getUncompleteMonthLength();
        return this.toSignDouble((double)result + daysDif / (double)prevMonthL);
    }

    private double toSignDouble(double d) {
        if (d == 0.0) {
            return d;
        }
        return this.isNegative ? -1.0 * d : d;
    }

    private double toSignAndRemoveFraction(double d) {
        return (int)this.toSignDouble(d);
    }

    private int getUncompleteMonthLength() {
        if (this.startDate.getDay() <= this.endDate.getDay()) {
            return this.endDate.getActualMonthLength();
        }
        return this.endDate.getPrevMonthLength();
    }
}

