/*
 * Decompiled with CFR 0.152.
 */
package org.openl.spring.env;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

class CompositePropertySource
extends EnumerablePropertySource<Object> {
    private final LinkedList<PropertySource<?>> propertySources = new LinkedList();

    CompositePropertySource(String name) {
        super(name, new Object());
    }

    void addFirst(PropertySource<?> propertySource) {
        if (propertySource != null) {
            this.propertySources.addFirst(propertySource);
        }
    }

    PropertySource<?> get() {
        if (this.propertySources.isEmpty()) {
            return null;
        }
        if (this.propertySources.size() == 1) {
            return this.propertySources.getFirst();
        }
        return this;
    }

    public Object getProperty(String name) {
        for (PropertySource propertySource : this.propertySources) {
            Object candidate = propertySource.getProperty(name);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public boolean containsProperty(String name) {
        for (PropertySource propertySource : this.propertySources) {
            if (!propertySource.containsProperty(name)) continue;
            return true;
        }
        return false;
    }

    public String[] getPropertyNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (PropertySource propertySource : this.propertySources) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            names.addAll(Arrays.asList(((EnumerablePropertySource)propertySource).getPropertyNames()));
        }
        return names.toArray(new String[names.size()]);
    }

    public String toString() {
        return String.format("%s [name='%s', propertySources=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.name, this.propertySources);
    }
}

