/*
 * Decompiled with CFR 0.152.
 */
package org.openl.spring.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertyResolver;

public class PropertyResourceResolver {
    public static final String APP_NAME_TAG = "{appName}";
    public static final String PROFILE_TAG = "{profile}";
    private String appName;
    private String[] profiles;
    private PropertyResolver resolver;
    private final Logger log = LoggerFactory.getLogger(PropertyResourceResolver.class);

    public PropertyResourceResolver(PropertyResolver resolver, String appName, String ... profiles) {
        this.resolver = resolver;
        this.appName = appName;
        this.profiles = profiles;
    }

    private String getAppName() {
        return this.appName;
    }

    private String[] getProfiles() {
        return this.profiles;
    }

    public List<String> resolvePlaceholders(String ... values) {
        if (CollectionUtils.isEmpty((Object[])values)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(32);
        for (String value : values) {
            String[] splitted;
            String resolved = this.resolver.resolvePlaceholders(value);
            if (StringUtils.isBlank((CharSequence)resolved)) {
                this.log.debug("!       Empty: '{}'", (Object)value);
                continue;
            }
            for (String s : splitted = StringUtils.split((String)resolved, (char)',')) {
                List<String> withTags = this.resolveTags(s);
                result.addAll(withTags);
            }
        }
        return result;
    }

    private List<String> resolveTags(String value) {
        String withApp = this.resolveAppName(value);
        return this.resolveProfile(withApp);
    }

    private String resolveAppName(String value) {
        if (value.contains(APP_NAME_TAG)) {
            String appName = this.getAppName();
            if (StringUtils.isBlank((CharSequence)appName)) {
                this.log.debug("- No app name: '{}'", (Object)value);
                value = "";
            } else {
                value = value.replace(APP_NAME_TAG, appName);
            }
        }
        return value;
    }

    private List<String> resolveProfile(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptyList();
        }
        if (value.contains(PROFILE_TAG)) {
            Object[] profiles = this.getProfiles();
            if (CollectionUtils.isEmpty((Object[])profiles)) {
                this.log.debug("- No profiles: '{}'", (Object)value);
                return Collections.emptyList();
            }
            int size = profiles.length;
            ArrayList<String> result = new ArrayList<String>(size);
            for (Object profile : profiles) {
                result.add(value.replace(PROFILE_TAG, (CharSequence)profile));
            }
            return result;
        }
        return Collections.singletonList(value);
    }
}

