/*
 * Decompiled with CFR 0.152.
 */
package org.openl.spring.env;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openl.info.OpenLVersion;
import org.openl.spring.env.CompositePropertySource;
import org.openl.spring.env.PropertyResourceResolver;
import org.openl.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PlaceholderConfigurerSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.util.StringValueResolver;

public class PropertySourcesLoader
extends PlaceholderConfigurerSupport
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
ApplicationContextAware {
    public static final String OPENL_DEFAULT_PROPS = "OpenL default properties";
    public static final String OPENL_APPLICATION_PROPS = "OpenL application properties";
    public static final String OPENL_ADDITIONAL_PROPS = "OpenL additional properties";
    public static final String ENVIRONMENT_PROPS = "environmentProps";
    private static final String VERSION = OpenLVersion.getVersion();
    private final Logger log = LoggerFactory.getLogger((String)"OpenL.config");
    private ApplicationContext appContext;
    private MutablePropertySources propertySources;

    public PropertySourcesLoader() {
        this.setIgnoreResourceNotFound(true);
    }

    public void initialize(ConfigurableApplicationContext appContext) {
        this.log.info("The initialization of properties from 'contextInitializerClasses' context-param in web.xml");
        this.setApplicationContext((ApplicationContext)appContext);
        ConfigurableEnvironment env = appContext.getEnvironment();
        MutablePropertySources propertySources = env.getPropertySources();
        this.loadProperties(propertySources, (Environment)env);
    }

    private void loadProperties(MutablePropertySources propertySources, Environment env) {
        PropertySourcesPropertyResolver propertyResolver = new PropertySourcesPropertyResolver((PropertySources)propertySources);
        String[] profiles = env == null ? null : env.getActiveProfiles();
        PropertyResourceResolver resolver = new PropertyResourceResolver((PropertyResolver)propertyResolver, this.getAppName(this.appContext), profiles);
        this.log.info("Loading default properties...");
        CompositePropertySource defaultProps = new CompositePropertySource(OPENL_DEFAULT_PROPS);
        List<String> locations = resolver.resolvePlaceholders("classpath*:openl-default.properties", "${openl.config.default}");
        for (String location : locations) {
            this.addResource(defaultProps, location);
        }
        propertySources.addLast((PropertySource)defaultProps);
        this.log.info("Loading application properties...");
        CompositePropertySource applicationProps = new CompositePropertySource(OPENL_APPLICATION_PROPS);
        List<String> lc = resolver.resolvePlaceholders("${openl.config.location}");
        List<String> nm = resolver.resolvePlaceholders("${openl.config.name}");
        for (String location : lc) {
            if (location.endsWith("/") || location.endsWith("\\") || location.endsWith(":")) {
                for (String name : nm) {
                    this.addResource(applicationProps, location + name);
                }
                continue;
            }
            this.addResource(applicationProps, location);
        }
        propertySources.addBefore(OPENL_DEFAULT_PROPS, (PropertySource)applicationProps);
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
    }

    private String getAppName(ApplicationContext appContext) {
        String appName = appContext.getApplicationName();
        if (appName == null || appName.isEmpty()) {
            return "";
        }
        return appName.replace('/', ' ').replace('\\', ' ').trim().replace(' ', '-');
    }

    private void addResource(CompositePropertySource propertySource, String location) {
        PropertySource<?> found = this.find(location, (ResourcePatternResolver)this.appContext);
        propertySource.addFirst(found);
    }

    private PropertySource<?> find(String location, ResourcePatternResolver resourcePattern) {
        Object[] resources;
        if (location == null) {
            return null;
        }
        if (location.matches("[\\{\\}]")) {
            this.log.info("! Unresolved: '{}'", (Object)location);
        }
        try {
            resources = resourcePattern.getResources(location);
        }
        catch (IOException e) {
            this.log.debug("!     Error: '{}'", new Object[]{location, e});
            return null;
        }
        if (CollectionUtils.isEmpty((Object[])resources)) {
            this.log.debug("- Not found: [{}]", (Object)location);
            return null;
        }
        Arrays.sort(resources, Comparator.comparing(Resource::getFilename, Comparator.comparingInt(String::length).thenComparing(Comparator.naturalOrder())));
        CompositePropertySource propertySource = new CompositePropertySource(location);
        for (Object resource : resources) {
            try {
                if (resource.exists()) {
                    propertySource.addFirst((PropertySource<?>)new ResourcePropertySource((Resource)resource));
                    this.log.info("+        Add: [{}] '{}'", (Object)location, this.getInfo((Resource)resource));
                    continue;
                }
                this.log.debug("- Not exist: [{}] '{}'", new Object[]{location, this.getInfo((Resource)resource)});
            }
            catch (Exception ex) {
                this.log.debug("!     Error: [{}] '{}'", new Object[]{location, this.getInfo((Resource)resource), ex});
            }
        }
        return propertySource.get();
    }

    private Object getInfo(Resource resource) {
        try {
            return resource.getURL();
        }
        catch (Exception e) {
            return resource;
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertySources == null) {
            this.log.info("The initialization of properties from the Spring configuration.");
            Environment env = this.appContext.getEnvironment();
            if (env instanceof ConfigurableEnvironment) {
                this.propertySources = ((ConfigurableEnvironment)env).getPropertySources();
            } else {
                this.propertySources = new MutablePropertySources();
                if (env != null) {
                    this.propertySources.addLast((PropertySource)new PropertySource<Environment>(ENVIRONMENT_PROPS, env){

                        public String getProperty(String key) {
                            return ((Environment)this.source).getProperty(key);
                        }
                    });
                }
            }
            this.load(this.propertySources, env);
        }
        this.processProperties(beanFactory, (PropertySources)this.propertySources);
    }

    private void load(MutablePropertySources propertySources, Environment env) {
        Properties properties;
        if (propertySources.contains(OPENL_ADDITIONAL_PROPS)) {
            this.log.info("The second initialization of properties. The previous application properties have been kept.");
            return;
        }
        if (!propertySources.contains(OPENL_DEFAULT_PROPS)) {
            this.log.info("The first initialization of properties. Creating new application properties...");
            this.loadProperties(propertySources, env);
        }
        try {
            properties = this.mergeProperties();
        }
        catch (IOException ex) {
            this.log.warn("Could not load properties", (Throwable)ex);
            return;
        }
        if (CollectionUtils.isEmpty((Map)properties)) {
            this.log.debug("Additional properties are absent.");
            return;
        }
        PropertiesPropertySource additionalProps = new PropertiesPropertySource(OPENL_ADDITIONAL_PROPS, properties);
        if (this.localOverride) {
            this.log.info("Loading additional properties... Overriding the application properties...");
            propertySources.addBefore(OPENL_APPLICATION_PROPS, (PropertySource)additionalProps);
        } else {
            this.log.info("Loading additional properties... Appending to the application properties...");
            propertySources.addAfter(OPENL_APPLICATION_PROPS, (PropertySource)additionalProps);
        }
    }

    @Deprecated
    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) {
        throw new UnsupportedOperationException("Call processProperties(ConfigurableListableBeanFactory, ConfigurablePropertyResolver) instead");
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, PropertySources propertySources) throws BeansException {
        this.log.info("Apply properties.");
        final PropertySourcesPropertyResolver propertyResolver = new PropertySourcesPropertyResolver(propertySources);
        propertyResolver.setPlaceholderPrefix(this.placeholderPrefix);
        propertyResolver.setPlaceholderSuffix(this.placeholderSuffix);
        propertyResolver.setValueSeparator(this.valueSeparator);
        StringValueResolver valueResolver = new StringValueResolver(){

            public String resolveStringValue(String strVal) {
                String resolved = PropertySourcesLoader.this.ignoreUnresolvablePlaceholders ? propertyResolver.resolvePlaceholders(strVal) : propertyResolver.resolveRequiredPlaceholders(strVal);
                return resolved.equals(PropertySourcesLoader.this.nullValue) ? null : resolved;
            }
        };
        this.doProcessProperties(beanFactory, valueResolver);
    }
}

