/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.maven;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.ClassMatcher;
import org.eclipse.jetty.webapp.WebAppContext;

public class AppServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void check(String pathDeployment, Collection<File> jars, String workDir) throws Exception {
        List libs = jars.stream().map(Resource::newResource).collect(Collectors.toList());
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setResourceBase("");
        webAppContext.addSystemClassMatcher(new ClassMatcher("org.slf4j."));
        webAppContext.addSystemClassMatcher(new ClassMatcher("-javax.activation."));
        webAppContext.setExtraClasspath(libs);
        webAppContext.setInitParameter("openl.config.location", "");
        webAppContext.setInitParameter("user.home", workDir);
        webAppContext.setInitParameter("production-repository.factory", "repo-zip");
        webAppContext.setInitParameter("production-repository.archives", pathDeployment);
        webAppContext.setAttribute("org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern", (Object)".*ruleservice.ws[^/]*\\.jar$");
        Server server = new Server(0);
        server.setHandler((Handler)webAppContext);
        Properties backupProperties = System.getProperties();
        try {
            System.setProperty("groovy.use.classvalue", "false");
            server.start();
            int port = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
            HttpClient client = HttpClient.newBuilder().executor(Runnable::run).version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(60L)).build();
            URI uri = new URL("http", "localhost", port, "/admin/healthcheck/readiness").toURI();
            HttpRequest req = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofSeconds(60L)).GET().build();
            HttpResponse<String> resp = client.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() != 200 || !resp.body().equals("READY")) {
                throw new IOException("Server startup failure: " + resp);
            }
        }
        finally {
            server.stop();
            server.destroy();
            System.setProperties(backupProperties);
        }
    }
}

