/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.maven;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openl.CompiledOpenClass;
import org.openl.OpenClassUtil;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.Severity;
import org.openl.rules.maven.BaseOpenLMojo;
import org.openl.rules.project.instantiation.SimpleProjectEngineFactory;
import org.openl.rules.project.validation.openapi.OpenApiProjectValidator;
import org.openl.types.IOpenClass;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class CompileMojo
extends BaseOpenLMojo {
    @Parameter
    private Map<String, Object> externalParameters;
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    private List<String> classpath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String sourcePath, boolean hasDependencies) throws Exception {
        URL[] urls = this.toURLs(this.classpath);
        URLClassLoader classLoader = null;
        try {
            classLoader = new URLClassLoader(urls, SimpleProjectEngineFactory.class.getClassLoader());
            long memStart = CompileMojo.memUsed();
            long start = System.nanoTime();
            SimpleProjectEngineFactory.SimpleProjectEngineFactoryBuilder builder = new SimpleProjectEngineFactory.SimpleProjectEngineFactoryBuilder();
            if (hasDependencies) {
                builder.setWorkspace(this.workspaceFolder.getPath());
            }
            SimpleProjectEngineFactory factory = builder.setProject(sourcePath).setClassLoader((ClassLoader)classLoader).setExecutionMode(true).setExternalParameters(this.externalParameters).build();
            CompiledOpenClass openLRules = new OpenApiProjectValidator().validate(factory.getProjectDescriptor(), factory.getRulesInstantiationStrategy());
            openLRules.throwErrorExceptionsIfAny();
            IOpenClass openClass = openLRules.getOpenClass();
            long end = System.nanoTime();
            long memEnd = CompileMojo.memUsed();
            Collection warnMessages = OpenLMessagesUtils.filterMessagesBySeverity((Collection)openLRules.getAllMessages(), (Severity)Severity.WARN);
            this.info("Compilation has finished.", new Object[0]);
            this.info("DataTypes    : ", openClass.getTypes().size());
            this.info("Methods      : ", openClass.getMethods().size());
            this.info("Warnings     : ", warnMessages.size());
            this.info("Memory used  : ", (double)((memEnd - memStart) / 262144L) / 4.0, " MiB");
            this.info("Time elapsed : ", (double)((end - start) / 10000000L) / 100.0, " s");
        }
        catch (Throwable throwable) {
            OpenClassUtil.releaseClassLoader(classLoader);
            throw throwable;
        }
        OpenClassUtil.releaseClassLoader((ClassLoader)classLoader);
    }

    @Override
    String getHeader() {
        return "OPENL COMPILATION";
    }

    private static long memUsed() throws InterruptedException {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        rt.gc();
        rt.gc();
        Thread.sleep(10L);
        rt.runFinalization();
        Thread.sleep(3L);
        rt.gc();
        rt.gc();
        Thread.sleep(3L);
        rt.gc();
        rt.gc();
        Thread.sleep(3L);
        rt.gc();
        Thread.sleep(10L);
        return rt.totalMemory() - rt.freeMemory();
    }
}

