/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.rules.testmethod.ITestUnit;
import org.openl.rules.testmethod.TestStatus;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.result.ComparedResult;

class JUnitReportWriter {
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
    private final File dir;
    private XMLStreamWriter xml;
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";

    JUnitReportWriter(File dir) {
        this.dir = dir;
    }

    private void writeCData(String data) throws XMLStreamException {
        this.xml.writeCData(data.replace(CDATA_END, "]]]]><![CDATA[>"));
    }

    private void newLine() throws XMLStreamException {
        this.text("\n");
    }

    private String getCurrentDateTime() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
    }

    private String getTime(long nanos) {
        return this.numberFormat.format((double)nanos / 1.0E9);
    }

    private void attr(String name, String value) throws XMLStreamException {
        this.xml.writeAttribute(name, value);
    }

    private void start(String name) throws XMLStreamException {
        this.newLine();
        this.xml.writeStartElement(name);
    }

    private void end() throws XMLStreamException {
        this.newLine();
        this.xml.writeEndElement();
    }

    private void empty(String name) throws XMLStreamException {
        this.newLine();
        this.xml.writeEmptyElement(name);
    }

    private void text(String text) throws XMLStreamException {
        this.xml.writeCharacters(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(TestUnitsResults result) throws Exception {
        TestSuite testSuite = result.getTestSuite();
        String testName = testSuite.getTestSuiteMethod().getName();
        String moduleName = testSuite.getTestSuiteMethod().getModuleName();
        String suitName = "OpenL." + moduleName + "." + testName;
        String filename = "TEST-" + suitName + ".xml";
        int tests = result.getNumberOfTestUnits();
        int failures = result.getNumberOfAssertionFailures();
        int errors = result.getNumberOfErrors();
        long executionTime = result.getExecutionTime();
        List testUnits = result.getTestUnits();
        this.dir.mkdirs();
        File file = new File(this.dir, filename);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.xml = factory.createXMLStreamWriter(writer);
            try {
                this.writeTestsuite(suitName, tests, failures, errors, executionTime, testUnits);
            }
            finally {
                this.xml.flush();
                this.xml.close();
                this.xml = null;
            }
        }
    }

    private void writeTestsuite(String name, int tests, int failures, int errors, long executionTime, List<ITestUnit> testUnits) throws XMLStreamException {
        this.xml.writeStartDocument("UTF-8", "1.0");
        this.start("testsuite");
        this.attr("name", name);
        this.attr("tests", String.valueOf(tests));
        this.attr("skipped", "0");
        this.attr("failures", String.valueOf(failures));
        this.attr("errors", String.valueOf(errors));
        this.attr("time", this.getTime(executionTime));
        this.attr("timestamp", this.getCurrentDateTime());
        for (ITestUnit test : testUnits) {
            this.writeTestcase(name, test);
        }
        this.end();
        this.newLine();
        this.xml.writeEndDocument();
    }

    private void writeTestcase(String testName, ITestUnit test) throws XMLStreamException {
        if (test.getResultStatus() == TestStatus.TR_OK) {
            this.empty("testcase");
        } else {
            this.start("testcase");
        }
        this.attr("name", test.getTest().getId());
        this.attr("classname", testName);
        this.attr("time", this.getTime(test.getExecutionTime()));
        this.writeErrorOrFailureElement(test);
        if (test.getResultStatus() != TestStatus.TR_OK) {
            this.end();
        }
    }

    private void writeErrorOrFailureElement(ITestUnit test) throws XMLStreamException {
        TestStatus testStatus = test.getResultStatus();
        switch (testStatus) {
            case TR_OK: {
                break;
            }
            case TR_NEQ: {
                this.start("failure");
                this.attr("type", "ComparisonFailure");
                this.writeCData(this.failureMessage(test));
                this.end();
                break;
            }
            case TR_EXCEPTION: {
                Throwable throwable = (Throwable)test.getActualResult();
                this.start("error");
                this.attr("type", throwable.getClass().getName());
                this.attr("message", throwable.getMessage());
                this.writeCData(ExceptionUtils.getStackTrace((Throwable)throwable));
                this.end();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected TestStatus." + testStatus.name());
            }
        }
    }

    private String failureMessage(ITestUnit testUnit) {
        StringBuilder summaryBuilder = new StringBuilder();
        List comparisonResults = testUnit.getComparisonResults();
        for (ComparedResult comparisonResult : comparisonResults) {
            if (comparisonResult.getStatus() == TestStatus.TR_OK) continue;
            summaryBuilder.append('\n');
            if (comparisonResult.getFieldName() == null || "this".equals(comparisonResult.getFieldName())) {
                summaryBuilder.append("Expected: <").append(comparisonResult.getExpectedValue()).append("> but was <").append(comparisonResult.getActualValue()).append(">");
                continue;
            }
            summaryBuilder.append("Field ").append(comparisonResult.getFieldName()).append(" expected: <").append(comparisonResult.getExpectedValue()).append("> but was <").append(comparisonResult.getActualValue()).append(">");
        }
        return summaryBuilder.toString();
    }
}

